file=Makefile
echo "Extracting $file"
rm -f $file

file=Makefile.$osname-$arch$suffix
rm -f $file

if test -n "$GP_INSTALL_PREFIX"; then
  date=`date +%Y%m%d%H%M`; date="-t $date"
fi

case "$status" in
  alpha|beta|kernel) suf_status=".$status";;
  *) suf_status=;;
esac

tar="/bin/tar"
tarfile=pari-$version.$patch$suf_status.tar
case "`$tar 2>&1`" in
  *"--help"*) fl=cfXt; inc="";;
  *) fl=FcfX; inc="-I";;
esac

cat > $file << EOT
#
# This file was created by Configure. All changes made will be lost
# next time Configure is run.
#
SHELL = $make_sh
RM = /bin/rm -f

dft target::
	@echo "Possible targets are :"
	@echo "	gp			 Compilation"
	@echo "	bench, test, test-compat Compilation and test"
	@echo "	dobench, dotest 	 Test only"
	@echo "	doc			 Documentation"
	@echo "	install			 Installation"
	@echo "	clean, cleantest         Cleaning up"
	@echo "For pari maintainers..."
	@echo "	all			Compile gp-sta gp-dyn lib-sta lib-dyn"
	@echo "	distrib			For distribution of pari/gp"
	@echo "	bigdistrib		Idem, with all directories"

gp all ftest bench test test-compat test-graphic install clean cleantest install-bin install-lib-sta install-bin-sta dobench dotest::
	cd $objdir; \$(MAKE) \$@

doc::
	cd doc; \$(MAKE)

RCS::
	cd src; ci -f -l -r\$\${REVISION:-$rcsrevision} -m"." */*.[chs] kernel/*/*.[chs]
	cd src; /bin/touch -m $date */*.[chs]

setdir::
	@dir=pari-$version.$patch$suf_status; if test -d \$\$dir; then \\
	   echo "Remove \$\$dir before building a new release"; exit 1;\\
	fi;\\
	mkdir \$\$dir; mv $tarfile \$\$dir; \\
	cd \$\$dir; tar xf $tarfile; \$(RM) $tarfile; cd ..; \\
	tar cf $tarfile \$\$dir; \\
	rm -r \$\$dir

tarclean:
	\$(RM) examples/Makefile*
	rm -f $tarfile.gz

bigdistrib: bigtar setdir
	gzip $tarfile

uu: bigdistrib
	uuencode $tarfile.gz $tarfile.gz > pari.uu

distrib: tar setdir
	gzip $tarfile

bigtar: tar
	$tar rf $tarfile doc/gp.1 doc/tutorial.tex doc/app* doc/usersch*\
          doc/macros.tex.in doc/macrosbig.tex doc/Makefile.SOS doc/refcard.tex\
          doc/users.tex doc/users.help.tex doc/translations doc/gphelp.in

tar: tarclean
	$tar $fl $tarfile $config_dir/tar_exclude $inc $config_dir/tar_include
EOT

$ln_s $file Makefile 
