/**************************************************************/
/**************************************************************/
/*                                                            */
/*                        NUMBER FIELDS                       */
/*                                                            */
/**************************************************************/
/**************************************************************/
/* $Id: base1.c,v 2.0.0.8 1998/05/04 12:58:03 belabas Exp belabas $ */
#include "pari.h"
#include "parinf.h"

void
checkrnf(GEN rnf)
{
  if (typ(rnf)!=t_VEC) err(idealer1);
  if (lg(rnf)!=12) err(idealer1);
}

void
checkbnf(GEN bnf)
{
  if (typ(bnf)!=t_VEC) err(idealer1);
  if (lg(bnf)!=11)
  {
    if (lg(bnf)==10 && typ(bnf[1])==t_POL)
      err(talker,"please apply bnfinit first");
    err(idealer1);
  }
}

GEN
checknf(GEN nf)
{
  if (typ(nf)==t_POL) err(talker,"please apply nfinit first");
  if (typ(nf)!=t_VEC) err(idealer1);
  if (lg(nf)==10) return nf;
  if (lg(nf)==11) return checknf((GEN)nf[7]);
  err(idealer1);
  return NULL; /* not reached */
}

void
checkbnr(GEN bnr)
{
  if (typ(bnr)!=t_VEC || lg(bnr)!=7)
    err(talker,"incorrect bigray field");
  checkbnf((GEN)bnr[1]);
}

void
checkbnrgen(GEN bnr)
{
  checkbnr(bnr);
  if (lg(bnr[5])<=3)
    err(talker,"please apply bnrinit(,,1) and not bnrinit(,)");
}

void
checkid(GEN x, long N)
{
  if (typ(x)!=t_MAT) err(idealer2);
  if (lg(x) == 1 || lg(x[1]) != N+1)
    err(talker,"incorrect matrix for ideal");
}

void
checkbid(GEN bid)
{
  if (typ(bid)!=t_VEC || lg(bid)!=6)
    err(talker,"incorrect bigideal");
}

void
checkprimeid(GEN id)
{
  if (typ(id) != t_VEC || lg(id) != 6)
    err(talker,"incorrect prime ideal");
}

void
checkprhall(GEN prhall)
{
  if (typ(prhall) != t_VEC || lg(prhall) != 3 || typ(prhall[1]) != t_MAT)
    err(talker,"incorrect prhall format");
}

GEN
get_bnf(GEN x, int *t)
{
  switch(typ(x))
  {
    case t_POL: *t = typ_POL;  return NULL;
    case t_QUAD: *t = typ_Q  ; return NULL;
    case t_VEC:
      switch(lg(x))
      {
        case 6 : *t = typ_QUA; return NULL;
        case 10: *t = typ_NF; return NULL;
        case 11: *t = typ_BNF; return x;
        case 7 : *t = typ_BNR;
          x = (GEN)x[1]; if (typ(x)!=t_VEC || lg(x)!=11) break; 
          return x;
      }
    case t_MAT:
      if (lg(x)==2)
        switch(lg(x[1]))
        {
          case 8: case 11:
            *t = typ_CLA; return NULL;
        }
  }
  *t = typ_NULL; return NULL;
}

GEN
get_nf(GEN x, int *t)
{
  switch(typ(x))
  {
    case t_POL : *t = typ_POL; return NULL;
    case t_QUAD: *t = typ_Q  ; return NULL;
    case t_VEC:
      switch(lg(x))
      {
        case 10: *t = typ_NF; return x;
        case 11: *t = typ_BNF;
          x = (GEN)x[7]; if (typ(x)!=t_VEC || lg(x)!=10) break;
          return x;
        case 7 : *t = typ_BNR;
          x = (GEN)x[1]; if (typ(x)!=t_VEC || lg(x)!=11) break; 
          x = (GEN)x[7]; if (typ(x)!=t_VEC || lg(x)!=10) break;
          return x;

        case 14: case 20:
          *t = typ_ELL; return NULL;
      }break;
    case t_MAT:
      if (lg(x)==2)
        switch(lg(x[1]))
        {
          case 8: case 11:
            *t = typ_CLA; return NULL;
        }
  }
  *t = typ_NULL; return NULL;
}

/*************************************************************************/
/**									**/
/**			       GALOIS GROUP   				**/
/**									**/
/*************************************************************************/

/* exchange elements i and j in vector x */
static GEN
transroot(GEN x, int i, int j)
{
  long k;
  x = dummycopy(x);
  k=x[i]; x[i]=x[j]; x[j]=k; return x;
}

GEN
tschirnhaus(GEN x)
{
  long av=avma,tetpil,v,n,a,b,c;
  GEN u;

  if (typ(x)!=t_POL) err(notpoler,"tschirnhaus");
  n=lgef(x)-3; if (n<=0) err(constpoler,"tschirnhaus");
  v = varn(x);
  if (v) { u=dummycopy(x); setvarn(u,0); x=u; }
  do
  {
    a = mymyrand() & 3; if (!a) a=1;
    b = mymyrand() & 7; if (b>=4) b-=8;
    c = mymyrand() & 7; if (c>=4) c-=8;
    u=gmodulcp(gaddsg(c,gmul(polx[0],gaddsg(b,gmulsg(a,polx[0])))), x);
    tetpil=avma; u=caract(u,v); a=avma;
  }
  while (lgef(srgcd(u,deriv(u,v))) >= 4);
  if (DEBUGLEVEL>1)
  {
    fprintferr("transformation de Tschirnhaus: nouveau polynome ");
    outerr(u); flusherr();
  }
  avma=a; return gerepile(av,tetpil,u);
}

int
gpolcomp(GEN p1, GEN p2)
{
  int s,j = lgef(p1)-2;

  if (lgef(p2)-2 != j)
    err(bugparier,"gpolcomp (different degrees)");
  for (; j>=2; j--)
  {
    s = absi_cmp((GEN)p1[j], (GEN)p2[j]);
    if (s) return s;
  }
  return 0;
}

/* pol is assumed to be primitive and integral */
static GEN
primitive_pol_to_monic(GEN pol, GEN *lead)
{
  long n = lgef(pol)-1;
  GEN p2,p1,res; 
  
  if (gcmp1((GEN)pol[n])) { if (lead) *lead = NULL; return pol; }
  res = cgetg(n+1,t_POL); res[1]=pol[1];
  p2 = p1 = (GEN) pol[n];
  res[n] = un;     n--;
  res[n] = pol[n]; n--;
  for (;;)
  {
    res[n] = lmulii(p2,(GEN)pol[n]);
    if (n==2) { if (lead) *lead = p1; return res; }
    p2 = mulii(p1,p2); n--;
  }
}

/* compute x1*x2^2 + x2*x3^2 + x3*x4^2 + x4*x1^2 */
static GEN
get_F4(GEN x)
{
  GEN p1=gzero;
  long i;

  for (i=1; i<=4; i++)
    p1 = gadd(p1, gmul((GEN)x[i], gsqr((GEN)x[(i&3)+1])));
  return p1;
}

GEN galoisbig(GEN x, long prec);

GEN
galois(GEN x, long prec)
{
  long av=avma,av1,i,j,k,n,f,l,l2,e,e1,pr;
  GEN x1,p1,p2,p3,p4,p5,p6,y;
  static int ind5[20]={2,5,3,4, 1,3,4,5, 1,5,2,4, 1,2,3,5, 1,4,2,3};
  static int ind6[60]={3,5,4,6, 2,6,4,5, 2,3,5,6, 2,4,3,6, 2,5,3,4,
                       1,4,5,6, 1,5,3,6, 1,6,3,4, 1,3,4,5, 1,6,2,5,
                       1,2,4,6, 1,5,2,4, 1,3,2,6, 1,2,3,5, 1,4,2,3};
  if (typ(x)!=t_POL) err(notpoler,"galois");
  n=lgef(x)-3; if (n<=0) err(constpoler,"galois");
  if (n>11) err(impl,"galois of degree higher than 11");
  x = gdiv(x,content(x));
  for (i=2; i<=n+2; i++) 
    if (typ(x[i])!=t_INT) err(polrationer,"galois");
  if (gisirreducible(x) != gun)
    err(impl,"galois of reducible polynomial");

  if (n<4)
  {
    if (n<3)
    {
      avma=av; y=cgetg(4,t_VEC);
      y[1] = (n==1)? un: deux;
      y[2]=lnegi(gun);
    }
    else /* n=3 */
    {
      f=carreparfait(discsr(x));
      avma=av; y=cgetg(4,t_VEC);
      if (f) { y[1]=lstoi(3); y[2]=un; }
      else   { y[1]=lstoi(6); y[2]=lnegi(gun); }
    }
    y[3]=un; return y;
  }
  x1 = x = primitive_pol_to_monic(x,NULL); av1=avma;
  if (n>7) return galoisbig(x,prec);
  for(;;)
  {
    switch(n)
    {
      case 4:
        for(;;)
	{
	  p1=roots(x,prec); 
          p2=p1;  p4=gsub(polx[0], get_F4(p2));  p2=transroot(p1,1,2);
	  p4=gmul(p4,gsub(polx[0], get_F4(p2))); p2=transroot(p1,1,3);
	  p4=gmul(p4,gsub(polx[0], get_F4(p2))); p2=transroot(p1,1,4);
	  p4=gmul(p4,gsub(polx[0], get_F4(p2))); p2=transroot(p1,2,3);
	  p4=gmul(p4,gsub(polx[0], get_F4(p2))); p2=transroot(p1,3,4);
	  p4=gmul(p4,gsub(polx[0], get_F4(p2)));
          p5=grndtoi(greal(p4),&e); 
          e1=gexpo(gimag(p4)); if (e1>e) e=e1;
          if (e <= -10) break;
	  prec = (prec<<1)-2;
	}
	p6=ggcd(p5,deriv(p5,0));
	if (typ(p6)==t_POL && lgef(p6)>3) goto tchi;
	p1=factor(p5); p2=(GEN)p1[1]; l=lg(p2)-1;
	switch(l)
	{
	  case 1: f=carreparfait(discsr(x)); avma=av; y=cgetg(4,t_VEC);
	    y[3]=un;
	    if (f) { y[2]=un; y[1]=lstoi(12); return y; }
	    y[2]=lnegi(gun); y[1]=lstoi(24); return y;

	  case 2: avma=av; y=cgetg(4,t_VEC);
	    y[3]=un; y[2]=lnegi(gun); y[1]=lstoi(8); return y;
	
	  case 3: avma=av; y=cgetg(4,t_VEC);
	    y[1]=lstoi(4); y[3]=un;
	    y[2] = (lgef(p2[1])==5)? un: lnegi(gun);
	    return y;

	  default: err(bugparier,"galois (bug1)");
	}

      case 5:
        for(;;)
	{
          GEN ee = cgeti(7), z = cgetg(7,t_VEC);
          for(;;)
	  {
	    p1=roots(x,prec);
	    for (l=1; l<=5; l++)
	    {
	      p2=(l==1)?p1:transroot(p1,1,l);
	      p3=gzero; k=0;
              for (i=1; i<=5; i++)
	      {
		p5=gadd(gmul((GEN)p2[ind5[k]],(GEN)p2[ind5[k+1]]),
		        gmul((GEN)p2[ind5[k+2]],(GEN)p2[ind5[k+3]]));
		p3=gadd(p3,gmul(gsqr((GEN)p2[i]),p5)); k+=4;
	      }
	      z[l]=lrndtoi(greal(p3),&e);
              e1 = gexpo(gimag(p3)); ee[l]=max(e,e1);
	      p4 = (l==1) ?gsub(polx[0],p3):gmul(p4,gsub(polx[0],p3));
	    }
	    p2=transroot(p1,2,5);
	    p3=gzero; k=0;
            for (i=1; i<=5; i++)
	    {
	      p5=gadd(gmul((GEN)p2[ind5[k]],(GEN)p2[ind5[k+1]]),
	              gmul((GEN)p2[ind5[k+2]],(GEN)p2[ind5[k+3]]));
	      p3=gadd(p3,gmul(gsqr((GEN)p2[i]),p5)); k+=4;
	    }
	    z[6]=lrndtoi(greal(p3),&e);
            e1 = gexpo(gimag(p3)); if (e1>e) e=e1;
	    ee[6]=e;
	    p4=gmul(p4,gsub(polx[0],p3));
	    p5=grndtoi(greal(p4),&e);
            e1 = gexpo(gimag(p4)); if (e1>e) e=e1;
            if (e <= -10) break;
	    prec = (prec<<1)-2;
	  }
	  p6=ggcd(p5,deriv(p5,0));
	  if (typ(p6)==t_POL && lgef(p6)>3) goto tchi;
	  p3=factor(p5); l=lg(p3[1])-1;
	  f=carreparfait(discsr(x));
	  if (l==1)
	  {
	    avma=av; y=cgetg(4,t_VEC); y[3]=un;
	    if (f) { y[2]=un; y[1]=lstoi(60); return y; }
	    else { y[2]=lneg(gun); y[1]=lstoi(120); return y; }
	  }
	  if (!f)
	  {
	    avma=av; y=cgetg(4,t_VEC);
	    y[3]=un; y[2]=lneg(gun); y[1]=lstoi(20); return y;
	  }
          pr = - (bit_accuracy(prec) >> 1);
          for (l=1; l<=6; l++)
	    if (ee[l] <= pr && gcmp0(poleval(p5,(GEN)z[l]))) break;
	  if (l>6) err(bugparier,"galois (bug4)");
	  p2=(l==6)? transroot(p1,2,5):transroot(p1,1,l);
	  p3=gzero;
	  for (i=1; i<=5; i++)
	  {
	    j=(i%5)+1;
	    p3=gadd(p3,gmul(gmul((GEN)p2[i],(GEN)p2[j]),
			    gsub((GEN)p2[j],(GEN)p2[i])));
	  }
	  p5=gsqr(p3); p4=grndtoi(greal(p5),&e);
          e1 = gexpo(gimag(p5)); if (e1>e) e=e1;
	  if (e <= -10)
	  {
	    if (gcmp0(p4)) goto tchi;
	    f=carreparfait(p4); avma=av; y=cgetg(4,t_VEC);
	    y[3]=y[2]=un; y[1]=lstoi(f?5:10);
	    return y;
	  }
	  prec=(prec<<1)-2;
	}

      case 6:
        for(;;)
	{
          for(;;)
	  {
	    p1=roots(x,prec);
	    for (l=1; l<=6; l++)
	    {
	      p2=(l==1)?p1:transroot(p1,1,l);
	      p3=gzero; k=0;
              for (i=1; i<=5; i++) for (j=i+1; j<=6; j++)
	      {
		p5=gadd(gmul((GEN)p2[ind6[k]],(GEN)p2[ind6[k+1]]),
		        gmul((GEN)p2[ind6[k+2]],(GEN)p2[ind6[k+3]]));
		p3=gadd(p3,gmul(gsqr(gmul((GEN)p2[i],(GEN)p2[j])),p5)); k+=4;
	      }
	      p4 = (l==1) ? gsub(polx[0],p3):gmul(p4,gsub(polx[0],p3));
	    }
	    p5=grndtoi(greal(p4),&e); 
            e1 = gexpo(gimag(p4)); if (e1>e) e=e1;
            if (e <= -10) break;
	    prec=(prec<<1)-2;
	  }
	  p6=ggcd(p5,deriv(p5,0));
	  if (typ(p6)==t_POL && lgef(p6)>3) goto tchi;
	  p3=factor(p5); p2=(GEN)p3[1]; l=lg(p2)-1;
	  switch(l)
	  {
	    case 1:
	      p3=gadd(gmul(gmul((GEN)p1[1],(GEN)p1[2]),(GEN)p1[3]),
	              gmul(gmul((GEN)p1[4],(GEN)p1[5]),(GEN)p1[6]));
	      p4=gsub(polx[0],p3);
	      for (i=1; i<=3; i++)
		for (j=4; j<=6; j++)
		{
		  p2=transroot(p1,i,j);
		  p3=gadd(gmul(gmul((GEN)p2[1],(GEN)p2[2]),(GEN)p2[3]),
		          gmul(gmul((GEN)p2[4],(GEN)p2[5]),(GEN)p2[6]));
		  p4=gmul(p4,gsub(polx[0],p3));
		}
	      p5=grndtoi(greal(p4),&e);
              e1 = gexpo(gimag(p4)); if (e1>e) e=e1;
	      if (e <= -10)
	      {
		p6=ggcd(p5,deriv(p5,0));
		if (typ(p6)==t_POL && lgef(p6)>3) goto tchi;
		p3=factor(p5); p2=(GEN)p3[1]; l=lg(p2)-1;
		f=carreparfait(discsr(x));
		avma=av; y=cgetg(4,t_VEC); y[3]=un;
		if (l==1)
		{
		  if (f) { y[2]=un; y[1]=lstoi(360); }
		  else { y[2]=lnegi(gun); y[1]=lstoi(720); }
		}
		else
		{
		  if (f) { y[2]=un; y[1]=lstoi(36); }
		  else { y[2]=lnegi(gun); y[1]=lstoi(72); }
		}
                return y;
	      }
	      prec=(prec<<1)-2; break;
		
	    case 2: l2=lgef(p2[1])-3; if (l2>3) l2=6-l2;
	      switch(l2)
	      {
		case 1: f=carreparfait(discsr(x));
		  avma=av; y=cgetg(4,t_VEC); y[3]=un;
		  if (f) { y[2]=un; y[1]=lstoi(60); }
		  else { y[2]=lneg(gun); y[1]=lstoi(120); }
		  return y;
		case 2: f=carreparfait(discsr(x));
		  if (f)
		  {
		    avma=av; y=cgetg(4,t_VEC);
		    y[3]=y[2]=un; y[1]=lstoi(24);
		  }
		  else
		  {
		    p3=(lgef(p2[1])==5) ? (GEN)p2[2]:(GEN)p2[1];
		    f=carreparfait(discsr(p3));
		    avma=av; y=cgetg(4,t_VEC); y[2]=lneg(gun);
		    if (f) { y[1]=lstoi(24); y[3]=deux; }
		    else { y[1]=lstoi(48); y[3]=un; }
		  }
		  return y;
		case 3: f=carreparfait(discsr((GEN)p2[1]))
		       || carreparfait(discsr((GEN)p2[2]));
		  avma=av; y=cgetg(4,t_VEC);
		  y[3]=un; y[2]=lneg(gun); y[1]=lstoi(f? 18: 36);
		  return y;
	      }
	    case 3:
	      for (l2=1; l2<=3; l2++)
		if (lgef(p2[l2])>=6) p3=(GEN)p2[l2];
	      if (lgef(p3)==6)
	      {
		f=carreparfait(discsr(p3)); avma=av; y=cgetg(4,t_VEC);
                y[2]=lneg(gun); y[1]=lstoi(f? 6: 12);
	      }
	      else
	      {
		f=carreparfait(discsr(x)); avma=av; y=cgetg(4,t_VEC);
		if (f) { y[2]=un; y[1]=lstoi(12); }
		else { y[2]=lneg(gun); y[1]=lstoi(24); }
	      }
              y[3]=un; return y;
	    case 4: avma=av; y=cgetg(4,t_VEC);
	      y[1]=lstoi(6); y[2]=lneg(gun); y[3]=deux; return y;
            default: err(bugparier,"galois (bug3)");
	  }
	}
	
      case 7:
        for(;;)
	{
	  p1=roots(x,prec); p4=gun;
	  for (i=1; i<=5; i++)
	    for (j=i+1; j<=6; j++)
            {
              p6 = gadd((GEN)p1[i],(GEN)p1[j]);
	      for (k=j+1; k<=7; k++)
		p4 = gmul(p4,gsub(polx[0], gadd(p6,(GEN)p1[k])));
            }
          p5=grndtoi(greal(p4),&e); 
          e1 = gexpo(gimag(p4)); if (e1>e) e=e1;
	  if (e <= -10) break;
          prec = (prec<<1)-2;
	}
	p6=ggcd(p5,deriv(p5,0));
	if (typ(p6)==t_POL && lgef(p6)>3) goto tchi;
	p1=factor(p5); p2=(GEN)p1[1]; l=lg(p2)-1;
	switch(l)
	{
	  case 1: f=carreparfait(discsr(x)); avma=av; y=cgetg(4,t_VEC); y[3]=un;
	    if (f) { y[2]=un; y[1]=lstoi(2520); }
	    else { y[2]=lneg(gun); y[1]=lstoi(5040); }
	    return y;
	  case 2: f=lgef(p2[1])-3; avma=av; y=cgetg(4,t_VEC); y[3]=un;
	    if (f==7 || f==28) { y[2]=un; y[1]=lstoi(168); }
	    else { y[2]=lneg(gun); y[1]=lstoi(42); }
	    return y;
	  case 3: avma=av; y=cgetg(4,t_VEC);
	    y[3]=y[2]=un; y[1]=lstoi(21); return y;
	  case 4: avma=av; y=cgetg(4,t_VEC);
	    y[3]=un; y[2]=lneg(gun); y[1]=lstoi(14); return y;
	  case 5: avma=av; y=cgetg(4,t_VEC);
	    y[3]=y[2]=un; y[1]=lstoi(7); return y;
          default: err(talker,"galois (bug2)");
	}
    }
    tchi: avma=av1; x=tschirnhaus(x1);
  }
}

/*************************************************************************/
/**									**/
/**                           GALOIS CONJUGATES        		        **/
/**									**/
/*************************************************************************/

static long
computehenselbound(GEN nf, GEN p)
{
  long n,r1,r2,ru,i,j,e,av=avma;
  GEN p1,m,mm,pt6,mi,pmax;

  r1=itos(gmael(nf,2,1)); r2=itos(gmael(nf,2,2));
  ru=r1+r2; n=lgef(nf[1])-3;
  mm=gmael(nf,5,1); m=cgetg(n+1,t_MAT);
  for (j=1; j<=n; j++)
  {
    p1=cgetg(n+1,t_COL); m[j]=(long)p1;
    for (i=1; i<=ru; i++) p1[i] = coeff(mm,i,j);
    for (   ; i<=n ; i++) p1[i] = lconj(gcoeff(mm,i-r2,j));
  }
  mi = gmul(m,gmael(nf,5,6)); pmax=gzero;
  for (j=1; j<=n; j++)
  {
    p1 = gnorml2((GEN)mi[j]);
    if (cmpii(p1,pmax) > 0) pmax = p1;
  }
  pt6=(GEN)nf[6]; p1=gzero;
  for (i=1; i<=r1; i++) p1=gadd(p1,gnorm((GEN)pt6[i]));
  for (   ; i<=ru; i++) p1=gadd(p1,gmul2n(gnorm((GEN)pt6[i]),1));
  p1=gaddsg(1,gmulsg(n,gsqr(gmul(p1,pmax))));

  e = gexpo(p1); avma=av;
  e = (e+n+1)/expi(p) + 3; /* A MODIFIER */
  if (DEBUGLEVEL>1) { fprintferr("exponent = %ld\n",e); flusherr(); }
  return e;
}

static long
is_totally_split(GEN f, long p)
{
  long av = avma, n=lgef(f);
  GEN x;
  
  if (n-3 > p) return 0;
  f = gmul(f, gmodulss(1,p));
  if (lgef(f) != n) { avma=av; return 0; }
  x = cgetg(3,t_POLMOD); x[1]=(long)f; x[2]=lpolx[varn(f)];
  x = gadd(gpuigs(x,p), gneg(x)); /* x^p-x mod (f(x),p) */
  n = gcmp0(x); avma = av; return n;
}

static GEN
check_conj(GEN p1, GEN nf, GEN pol1, GEN pol2, long n)
{
  GEN p2 = (GEN)p1[n+1];
  if (is_pm1(p2))
  { 
    setlg(p1,n+1); p1 = gmul((GEN)nf[7], p1);
    if (signe(p2) > 0) p1 = gneg(p1);
    if (gcmp0(poleval(pol1,gmodulcp(p1,pol2)))) return p1;
  }
  return NULL; /* not a conjugate */
}

/* initialize m */
static void
init_conj(GEN m, GEN nf, GEN fa, GEN pe, long v, long n)
{
  GEN a,a1,mred;
  long i;
  
  coeff(m,1,1) = (long)pe; a=gmodulcp((GEN)fa[1],pe);
  a1=centerlift(gneg(gsubst((GEN)nf[7],v,a)));
  for (i=2; i<=n; i++) coeff(m,1,i)=a1[i];
  setlg(m,n+1); mred=gmul(m,lllint(m)); setlg(m,n+2);
  for (i=1; i<=n; i++) m[i]=mred[i];
  if (DEBUGLEVEL>1) { fprintferr("initial LLL done\n"); flusherr(); }
}

/* return smallest p not dividing bad, such that x is (totally) split mod p */
static GEN
choose_p(GEN bad, GEN x)
{
  byteptr pt = diffptr;
  long p = *pt++; /* = 2 */

  for(;;)
  {
    p += *pt++; if (!*pt) err(primer1);
    if (smodis(bad,p) && is_totally_split(x,p)) break;
  }
  if (DEBUGLEVEL>1) { fprintferr("choosing p = %ld\n",p); flusherr(); }
  return stoi(p);
}

GEN
galoisconj(GEN nf)
{
  long av=avma,tetpil,i,k,n,v,e;
  GEN x,y,p1,p,m,fa,pe,mred;

  if (DEBUGLEVEL>1)
    { fprintferr("Entree dans galoisconj()\n"); flusherr(); }
  nf=checknf(nf); x=(GEN)nf[1];
  n=lgef(x)-3; if (n<=0) return cgetg(1,t_VEC);
  p1 = mulii((GEN)nf[3],(GEN)nf[4]);
  p = choose_p(p1,x); e = computehenselbound(nf,p);

  m=idmat(n+1); fa = gtrunc(rootpadicfast(x,p,e,1));
  pe=gpuigs(p,e); v=varn(x); init_conj(m,nf,fa,pe,v,n);

  y=cgetg(n+1,t_VEC); y[1]=(long)polx[v];
  for (i=2; i<=n; i++)
  {
    coeff(m,1,n+1) = (long) centerlift(gneg(gmodulcp((GEN)fa[i],pe)));
    mred = gmul(m,lllint(m));
    for (k=1; k<=n; k++)
    {
      p1 = check_conj((GEN)mred[k],nf,x,x,n);
      if (p1) { y[i]=(long)p1; break; }
    }
    if (k > n) y[i]=zero; /* conjugate not found */
  }
  tetpil=avma; return gerepile(av,tetpil,gcopy(y));
}

/* fliso = 0 test for inclusion, else for isomorphism */
GEN
isisomfastall(GEN nf1, GEN nf2, long fliso)
{
  long av=avma,tetpil,i,k,n,n1,e,count;
  GEN x1,x2,y,p1,p,m,fa1,fa2,pe,mred;

  nf1=checknf(nf1); x1=(GEN)nf1[1];
  nf2=checknf(nf2); x2=(GEN)nf2[1];
  if (fliso)
  {
    if (!gegal((GEN)nf1[2],(GEN)nf2[2])) { avma=av; return gzero; }
    if (!gegal((GEN)nf1[3],(GEN)nf2[3])) { avma=av; return gzero; }
    n1 = n = lgef(x1)-3;
    if (n<=0) err(constpoler,"isisomfastall");
  }
  else
  {
    n=lgef(x2)-3; n1=lgef(x1)-3;
    if (n<=0 || n1<=0) err(constpoler,"isisomfastall");
    if (n%n1 || !divise((GEN)nf2[3],gpuigs((GEN)nf1[3],n/n1)))
      { avma=av; return gzero; }
  }
  p1 = mulii(mulii((GEN)nf2[3],(GEN)nf1[4]),(GEN)nf2[4]);
  p = choose_p(p1,x2);
  if (!is_totally_split(x1,p[2])) { avma=av; return gzero; }

  /* A MODIFIER nf1 et nf2 doivent etre pris en compte a la fois */
  e = max(computehenselbound(nf2,p), computehenselbound(nf1,p));
  pe=gpuigs(p,e); m=idmat(n+1);
  fa1=gtrunc(rootpadicfast(x1,p,e,1));
  fa2=gtrunc(rootpadicfast(x2,p,e,0));
  init_conj(m,nf2,fa2,pe,varn(x2),n);

  y=cgetg(n1+1,t_VEC); count=1;
  for (i=1; i<=n1; i++)
  {
    coeff(m,1,n+1) = (long) centerlift(gneg(gmodulcp((GEN)fa1[i],pe)));
    mred = gmul(m,lllint(m));
    for (k=1; k<=n; k++)
    {
      p1 = check_conj((GEN)mred[k],nf2,x1,x2,n);
      if (p1) { y[count++]=(long)p1; break; }
    }
  }
  if (count==1) { avma=av; return gzero; }
  tetpil=avma; setlg(y,count);
  return gerepile(av,tetpil,gcopy(y));
}

GEN
isisomfast(GEN nf1, GEN nf2)
{
  return isisomfastall(nf1,nf2,1);
}

GEN
isinclfast(GEN nf1, GEN nf2)
{
  return isisomfastall(nf1,nf2,0);
}

/* modify polr */
static void
henselstep(GEN x, GEN polr, long e)
{
  GEN yi,xp;
  long i,n;

  n=lgef(x)-3; xp=deriv(x,varn(x));
  for (i=1; i<=n; i++)
  {
    yi = gprec((GEN)polr[i], e);
    polr[i] = lsub(yi, gdiv(poleval(x,yi),poleval(xp,yi)));
  }
}

GEN
galoisconjforce(GEN nf)
{
  long av=avma,tetpil,av1,i,n,v,e;
  GEN x,y,p1,p,m,fa,pe,mred,polr;

  if (DEBUGLEVEL>1)
    { fprintferr("Entree dans galoisconjforce()\n"); flusherr(); }
  nf=checknf(nf); x=(GEN)nf[1];
  n=lgef(x)-3; if (n<=0) return cgetg(1,t_VEC);
  
  p1 = mulii((GEN)nf[3],(GEN)nf[4]);
  p=choose_p(p1,x); e=computehenselbound(nf,p);
  polr=rootpadicfast(x,p,e,1); pe=gpuigs(p,e);
  if (DEBUGLEVEL>1) { fprintferr("p-adic roots computed\n"); flusherr(); }
  m=idmat(n+1); v=varn(x); 

  y=cgetg(n+1,t_VEC); y[1]=(long)polx[v];
  for (i=2;;)
  {
    av1=avma; fa=gtrunc(polr); init_conj(m,nf,fa,pe,v,n);
    for ( ; i<=n; i++)
    {
      coeff(m,1,n+1) = (long) centerlift(gneg(gmodulcp((GEN)fa[i],pe)));
      mred=gmul(m,lllint(m));
      if (DEBUGLEVEL>1) { fprintferr("LLL for root done\n"); flusherr(); }
      p1 = check_conj((GEN)mred[1],nf,x,x,n);
      if (p1) { y[i]=(long)p1; continue; } /* conjugate found */

      /* otherwise increase p-adic precision, re-do outermost loop */
      avma=av1; e<<=1; henselstep(x,polr,e); pe=gsqr(pe);
      if (DEBUGLEVEL>1)
        { fprintferr("doubling exponent. new e = %ld\n",e); flusherr(); }
      break;
    }
    if (i > n)
    {
      tetpil=avma; return gerepile(av,tetpil,gcopy(y));
    }
  }
}

GEN
galoisconj1(GEN nf, long prec)
{
  long av=avma,tetpil,i,j,n,r1,ru;
  GEN x,y,w,polr,p1,p2;

  if (DEBUGLEVEL>1) { fprintferr("Entree dans galoisconj1()\n"); flusherr(); }
  nf=checknf(nf); x=(GEN)nf[1];

  n=lgef(x)-3; if (n<=0) return cgetg(1,t_VEC);
  r1 = itos(gmael(nf,2,1)); p1=(GEN)nf[6]; 
  ru = (n+r1)>>1;
  polr = cgetg(n+1,t_VEC);
  for (i=1; i<=r1; i++) polr[i]=p1[i];
  for (j=i; i<=ru; i++) { polr[j++]=p1[i]; polr[j++]=lconj((GEN)p1[i]); }
  p1=(GEN)polr[1];
  p2=gmael(nf,5,1); w=cgetg(n+1,t_VEC);
  for (i=1; i<=n; i++) w[i]=coeff(p2,1,i);

  y=cgetg(n+1,t_VEC); y[1]=(long)polx[varn(x)];
  for (i=2; i<=n; i++)
  {
    y[i] = zero;
    p1 = lindep2(concatsp(w,(GEN)polr[i]), bit_accuracy(prec)<<1);
    if (signe(p1[n+1]))
    {
      setlg(p1, n+1); settyp(p1,t_COL);
      p2 = gdiv(gmul((GEN)nf[7],p1), negi((GEN)p1[n+1]));
      if (gdivise(poleval(x,p2), x)) y[i] = (long)p2;
    }
    if (DEBUGLEVEL>1) outerr((GEN)y[i]);
  }
  tetpil=avma; return gerepile(av,tetpil,gcopy(y));
}

GEN
galoisconj2(GEN x, long prec)
{
  long av=avma,tetpil,i,n,v;
  GEN y,w,polr,p1,p2;

  if (DEBUGLEVEL>1){ fprintferr("Entree dans galoisconj2()\n"); flusherr(); }
  if (typ(x)!=t_POL) return galoisconj1(x,prec);

  n=lgef(x)-3; if (n<=0) return cgetg(1,t_VEC);
  if (gisirreducible(x) == gzero) err(redpoler,"galoisconj2");
  polr=roots(x,prec); p1=(GEN)polr[1];
  w=cgetg(n+1,t_VEC); w[1]=un;
  for (i=2; i<=n; i++) w[i]=lmul(p1,(GEN)w[i-1]);

  v=varn(x); y=cgetg(n+1,t_VEC); y[1]=(long)polx[v];
  for (i=2; i<=n; i++)
  {
    y[i] = zero;
    p1 = lindep2(concatsp(w,(GEN)polr[i]), bit_accuracy(prec)<<1);
    if (signe(p1[n+1]))
    {
      p2 = gdiv(gtopoly(p1,v), negi((GEN)p1[n+1]));
      if (gdivise(poleval(x,p2), x)) y[i] = (long)p2;
    }
    if (DEBUGLEVEL>1) outerr((GEN)y[i]);
  }
  tetpil=avma; return gerepile(av,tetpil,gcopy(y));
}

GEN
galoisconj0(GEN nf,long flag, long prec)
{
  switch(flag)
  {
    case 0: return galoisconj(nf);
    case 1: return galoisconjforce(nf);
    case 2: return galoisconj1(nf,prec);
    case 3: return galoisconj2(nf,prec);
    case 4: return conjugates(nf);
    default: err(flagerr);
  }
  return NULL; /* not reached */
}

GEN
galoisapply(GEN nf, GEN aut, GEN x)
{
  long av=avma,tetpil,lx,j,N;
  GEN p1,y,pol,unmod;

  nf=checknf(nf); pol=(GEN)nf[1];
  if (typ(aut)==t_POL) aut = gmodulcp(aut,pol);
  else
  {
    if (typ(aut)!=t_POLMOD || !gegal((GEN)aut[1],pol) || gcmp0((GEN)aut[1]))
      err(talker,"incorrect galois automorphism in galoisapply");
  }
  switch(typ(x))
  {
    case t_INT: case t_INTMOD: case t_FRAC: case t_FRACN: case t_PADIC:
      avma=av; return gcopy(x);

    case t_POLMOD: x = (GEN) x[2]; /* fall through */
    case t_POL:
      tetpil=avma; p1=gsubst(x,varn(pol),aut);
      if (typ(p1)!=t_POLMOD || !gegal((GEN)p1[1],pol))
      {
	tetpil=avma; p1=gmodulcp(p1,pol);
      }
      return gerepile(av,tetpil,p1);

    case t_VEC:
      if (lg(x)==3)
      {
	tetpil=avma; y=cgetg(3,t_VEC);
	y[1]=(long)galoisapply(nf,aut,(GEN)x[1]);
	y[2]=zero; y = gerepile(av,tetpil,y);
        y[2]=lcopy((GEN)x[2]); return y;
      }
      if (lg(x)!=6) err(typeer,"galoisapply");
      y=cgetg(6,t_VEC); y[1]=x[1]; y[3]=x[3]; y[4]=x[4];
      unmod=gmodulsg(1,(GEN)x[1]);
      p1=centerlift(gmul(unmod,algtobasis(nf,galoisapply(nf,aut,(GEN)x[2]))));
      if (gcmp1((GEN)x[3]))
	if (ggval(subres(gmul((GEN)nf[7],p1),pol),(GEN)x[1]) > itos((GEN)x[4]))
	  p1[1] =  (signe(p1[1]) > 0)? lsub((GEN)p1[1],(GEN)x[1])
	                             : ladd((GEN)p1[1],(GEN)x[1]);
      y[2]=(long)p1;
      p1=centerlift(gmul(unmod,algtobasis(nf,galoisapply(nf,aut,(GEN)x[5]))));
      y[5]=(long)p1;
      tetpil=avma; return gerepile(av,tetpil,gcopy(y));

    case t_COL:
      N=lgef(pol)-3;
      if (lg(x)!=N+1) err(typeer,"galoisapply");
      p1=galoisapply(nf,aut,gmul((GEN)nf[7],x)); tetpil=avma;
      return gerepile(av,tetpil,algtobasis(nf,p1));

    case t_MAT:
      lx=lg(x); if (lx==1) return cgetg(1,t_MAT);
      N=lgef(pol)-3;
      if (lg(x[1])!=N+1) err(typeer,"galoisapply");
      tetpil=avma; p1=cgetg(lx,t_MAT);
      for (j=1; j<lx; j++) p1[j]=(long)galoisapply(nf,aut,(GEN)x[j]);
      if (lg(x)!=N+1) return gerepile(av,tetpil,p1);
      tetpil=avma; return gerepile(av,tetpil,idealhermite(nf,p1));
  }
  err(typeer,"galoisapply");
  return NULL; /* not reached */
}

/*************************************************************************/
/**									**/
/**			       INITALG					**/
/**									**/
/*************************************************************************/

/* a usage interne. Pas de verifs.
Calcule trace(gmodulcp(x,pol)), ou sym=polsym(pol,lgef(pol)-4) */
static GEN
trace9(GEN x, GEN sym)
{
  GEN p1 = gzero;
  long i;

  if (signe(x))
    for (i=2; i<lgef(x); i++)
      p1 = gadd(p1, gmul((GEN)x[i],(GEN)sym[i-1]));
  return p1;
}

GEN
make_base(long n, GEN base)
{
  GEN p1,p2, res = cgetg(n+1,t_MAT);
  long i,j,l;

  for (j=1; j<=n; j++)
  {
    p1=cgetg(n+1,t_COL); res[j]=(long)p1;
    p2=(GEN)base[j]; 
    if (typ(p2)==t_INT) { p1[1]=(long)p2; i=2; }
    else
    { 
      l=lgef(p2)-1; p2++;
      for (i=1; i<l ; i++) p1[i]=p2[i];
    }
    for (; i<=n; i++) p1[i]=zero;
  }
  return res;
}

/* Seek a new, simpler, polynomial pol defining the same number field as
 * *ptx (assumed to be monic at this point).
 * Return the integer basis expressed on the roots of the new pol.
 * *ptx   receives pol
 * *ptdx  receives disc(pol)
 * *ptp20 expresses the new root in terms of the old one.
 */
static GEN
nfinit_reduce(long flag, GEN *ptx, GEN *ptp20, GEN *ptdx,
              long n, long r1, long PRECREG, GEN base)
{
  GEN a,phimax,dxn,adx,adxn,s,sn,p1,p2,p3,p5,p6,p7,polr,ptrace;
  GEN x = *ptx, polmax, p20, dx;
  long i,j,k,imax,nmax,numb,flc,v=varn(x);

  if (r1<n)
  {
    for (k=1; ; k++)
    {
      polr=roots(x,PRECREG); p3=cgetg(n+1,t_MAT);
      for (i=1; i<=n; i++)
      {
	p1=cgetg(n+1,t_COL); p3[i]=(long)p1;
	for (j=1; j<=n; j++)
	  p1[j] = (long)poleval((GEN)base[i],(GEN)polr[j]);
      }
      p2=greal(gmul(gconj(gtrans(p3)),p3));
      p1=lllgramintern(p2,1,PRECREG);
      if (p1) break;
      if (k == MAXITERPOL) err(accurer,"nfinit_reduce");
      PRECREG = (PRECREG<<1)-2;
      if (DEBUGLEVEL) err(warnprec,"nfinit_reduce",PRECREG);
    }
    for (s=gzero,i=1; i<=n; i++) s=gadd(s,gnorm((GEN)polr[i]));
  }
  else
  {
    ptrace=cgetg(n+1,t_VEC); ptrace[1]=lstoi(n);
    for (k=1; k<n; k++)
    {
      p3=gmulsg(k,(GEN)x[n-k+2]);
      for (i=1; i<k; i++) p3=gadd(p3,gmul((GEN)x[n-i+2],(GEN)ptrace[k-i+1]));
      ptrace[k+1]=lneg(p3);
    }
    p2=cgetg(n+1,t_MAT);
    for (i=1; i<=n; i++)
    {
      p1=cgetg(n+1,t_COL); p2[i]=(long)p1;
      for (j=1; j<i ; j++) p1[j]=lcopy(gcoeff(p2,i,j));
      for (   ; j<=n; j++)
      {
	p5=gres(gmul((GEN)base[i],(GEN)base[j]),x); p6=gzero;
	for (k=0; k<=lgef(p5)-3; k++)
	  p6=gadd(p6,gmul((GEN)p5[k+2],(GEN)ptrace[k+1]));
	p1[j]=(long)p6;
      }
    }
    p1=lllgramint(p2);
    s=(n>1)?gsub(gsqr((GEN)x[n+1]),gmul2n((GEN)x[n],1)):gsqr((GEN)x[2]);
  }
  if (DEBUGLEVEL) msgtimer("matrix T2");

  dx=discsr(x); adx=absi(dx); imax=0; polmax=x;
  nmax=(flag & nf_PARTIAL)?min(n,3):n;
  a=cgetg(n+1,t_COL); for (i=1; i<=n; i++) a[i]=lmul(base,(GEN)p1[i]);
  for (numb=0,i=1; i<=nmax || !numb; i++)
  {
    if (DEBUGLEVEL>=3) { fprintferr("i = %ld\n",i); flusherr(); }
    p3=gmodulcp((GEN)a[i],x); p7=content((GEN)p3[2]);
    if (gcmp1(p7)) p3=caract(p3,v);
    else
    {
      p3=caract(gdiv(p3,p7),v);
      p3=gmul(gpuigs(p7,lgef(p3)-3),gsubst(p3,v,gdiv(polx[v],p7)));
    }
    if (DEBUGLEVEL>=4) { outerr(p3); flusherr(); }

    p5=ggcd(deriv(p3,v),p3);
    if (lgef(p5)==3)
    {
      dxn=discsr(p3); adxn=absi(dxn); flc=gcmp(adxn,adx); numb++;
      if (flc<=0)
      {
	if (r1<n)
	  for (sn=gzero,j=1; j<=n; j++)
	    sn=gadd(sn,gnorm(poleval((GEN)a[i],(GEN)polr[j])));
	else
	  sn=(n>1)? gsub(gsqr((GEN)p3[n+1]),gmul2n((GEN)p3[n],1))
	          : gsqr((GEN)p3[2]);
	if (flc<0) { dx=dxn; adx=adxn; s=sn; polmax=p3; imax=i; }
	else
	{
	  flc=gcmp(sn,s);
	  if (flc<0 || (!flc && gpolcomp(p3,polmax) < 0))
	  { 
	    dx=dxn; adx=adxn; s=sn;
	    polmax=p3; imax=i;
	  }
	}
      }
    }
  }
  if (!numb) err(talker,"you have found a counter-example to a conjecture, "
                        "please send us\nthe polynomial as soon as possible");
  phimax=imax? (GEN)a[imax]: polx[v];
  j=n+1; while (j>=2 && !signe(polmax[j])) j-=2;
  if (j>=2 && signe(polmax[j]) > 0)
  {
    if (polmax==x) polmax=gcopy(x);
    for (; j>=2; j-=2) setsigne(polmax[j],-signe(polmax[j]));
    phimax=gneg(phimax);
  }
  if (DEBUGLEVEL)
  {
    msgtimer("polmax");
    if (DEBUGLEVEL>1) { fprintferr("polmax = "); outerr(polmax); }
  }
  p2 = gmodulcp(phimax,x); p20=polymodrecip(p2);
  p2 = gcmp0(p2)? base: lift(gsubst(base,v,p20));
  p3 = make_base(n,p2);
  base=denom(p3); p1=gmul(base,p3);
  p2=gdiv(hnfmod(p1,detint(p1)),base);
  
  p3=cgetg(n+1,t_VEC);
  for (j=1; j<=n; j++)
  {
    p1=gzero;
    for (i=n; i; i--)
      p1=gadd(gcoeff(p2,i,j),gmul(p1,polx[v]));
    p3[j]=(long)p1;
  }
  *ptx=polmax; *ptp20=p20; *ptdx=dx;
  return p3;
}

/* pol belonging to Z[x], return a monic polynomial generating the same field
 * as pol (x-> ax+b)) set lead = NULL if pol was monic (after dividing
 * by the content), and to to leading coeff otherwise.
 * No garbage collecting done.
 */
GEN
pol_to_monic(GEN pol, GEN *lead)
{
  long n = lgef(pol)-1;
  GEN p1;

  if (n==1 || gcmp1((GEN)pol[n])) { *lead = NULL; return pol; }

  p1=content(pol); if (!gcmp1(p1)) pol = gdiv(pol,p1);
  return primitive_pol_to_monic(pol,lead);
}

/* basis = integer basis. roo = real part of the roots */
GEN
make_M(long n,long ru,long v,GEN basis,GEN roo)
{
  GEN p1,res = cgetg(n+1,t_MAT);
  long i,j;

  for (j=1; j<=n; j++)
  {
    p1=cgetg(ru+1,t_COL); res[j]=(long)p1;
    for (i=1; i<=ru; i++)
      p1[i]=lsubst((GEN)basis[j],v,(GEN)roo[i]);
  }
  if (DEBUGLEVEL>4) msgtimer("matrix M");
  return res;
}

GEN
make_MC(long n,long r1,long ru,GEN M)
{
  GEN p1,p2,res=cgetg(ru+1,t_MAT);
  long i,j,av,tetpil;

  for (j=1; j<=ru; j++)
  {
    p1=cgetg(n+1,t_COL); res[j]=(long)p1;
    for (i=1; i<=n; i++)
    {
      av=avma; p2=gconj(gcoeff(M,j,i)); tetpil=avma;
      p1[i] = (j<=r1)? (long)p2: lpile(av,tetpil,gmul2n(p2,1));
    }
  }
  if (DEBUGLEVEL>4) msgtimer("matrix MC");
  return res;
}

GEN
get_roots(GEN x,long r1,long ru,long prec)
{
  GEN roo = roots(x,prec);
  long i;

  for (i=1; i<=r1; i++) roo[i]=lreal((GEN)roo[i]);
  for (   ; i<=ru; i++) roo[i]=roo[(i<<1)-r1];
  settyp(roo,t_VEC); setlg(roo,ru+1); return roo;
}

/* Initialize the number field defined by the polynomial x (in variable v)
 * flag & nf_REGULAR
 *    regular behaviour (no different).
 * flag & nf_DIFFERENT
 *    compute the different.
 * flag & nf_SMALL
 *    compute only nf[1] (pol), nf[2] (signature), nf[5][3] (T2) and 
 *    nf[7] (integer basis), the other components are filled with gzero.
 * flag & nf_REDUCE
 *    try a polred first.
 * flag & nf_PARTIAL
 *    do a partial polred, not a polredabs
 * flag & nf_ORIG
 *    do a polred and return [nfinit(x),Mod(a,red)], where
 *    Mod(a,red)=Mod(v,x) (i.e return the base change).
 */

/* here x can be a polynomial, an nf or a bnf */
GEN
initalgall0(GEN x, long flag, long prec)
{
  GEN lead = NULL,y,p1,p2,p3,p4,p5,p6,p7,p10,p11,p20,fieldd,dx,index,fa,res;
  long n,i,j,av=avma,av2,av3,tetpil,k,lgp,r1,r2,ru,PRECREG;

  if (typ(x)==t_POL)
  {
    n=lgef(x)-3; if (n<=0) err(constpoler,"initalgall0");
    for (k=2; k<=n+2; k++)
      if (typ(x[k])!=t_INT) err(talker,"polynomial not in Z[X] in nfinit");

    if (!gcmp1((GEN)x[n+2]) && !(flag & nf_REDUCE))
    {
      err(warner,"non-monic polynomial. I shall transform it");
      flag = flag | nf_REDUCE | nf_ORIG;
    }

    if (DEBUGLEVEL) timer2();
    if (flag & nf_REDUCE) x = pol_to_monic(x,&lead);

    p1=factor(x);
    if (DEBUGLEVEL) msgtimer("factpol");

    if (lgef(gcoeff(p1,1,1)) != n+3) err(redpoler,"nfinit");
    p4=allbase4(x,0,&fieldd,&fa);
    if (DEBUGLEVEL) msgtimer("round4");
    if (!(flag & nf_REDUCE)) dx=discsr(x);
    r1 = sturm(x); 
  }
  else
  {
    GEN nf=checknf(x);
    p4=(GEN)nf[7]; x=(GEN)nf[1]; n=lgef(x)-3;
    p4[1]=lpolun[varn(x)]; /* it may be gun => SEGV later */
    dx=fieldd=discsr(x);
    for (j=2; j<=n; j++)
      fieldd = gmul(fieldd, gsqr(content((GEN)p4[j])));
    r1 = itos(gmael(nf,2,1));
    if (flag & nf_DIFFERENT) fa = factor(fieldd);
  }
  r2=(n-r1)>>1; ru=r1+r2;

  PRECREG = (gexpo(fieldd)>>(TWOPOTBITS_IN_LONG+1))+(long)sqrt((double)n)+3;
  PRECREG +=prec;

  if (flag & nf_REDUCE)
    p4=nfinit_reduce(flag, &x, &p20, &dx, n, r1, PRECREG, p4);
  else
    dx=discsr(x);

  if (!carrecomplet(divii(dx,fieldd),&index))
    err(talker,"nfinit (incorrect discriminant)");

  if (!(flag & nf_SMALL))
  {
    p1=make_base(n,p4);
    p5=cgetg(n*n+1,t_MAT); for (j=1; j<=n*n; j++) p5[j]=lgetg(n+1,t_COL);
    p11=cgetg(n+1,t_MAT); for (j=1; j<=n; j++) p11[j]=lgetg(n+1,t_COL);
    p3=polsym(x,lgef(x)-4);
    for (i=1; i<=n; i++)
      for (j=i; j<=n; j++)
      {
	p10=gmod(gmul((GEN)p4[j],(GEN)p4[i]),x);
        p6 = (GEN)p5[j+(i-1)*n];
        p7 = (GEN)p5[i+(j-1)*n];
	lgp=lgef(p10)-1;
	for (k=1; k<lgp; k++) p6[k] = p7[k] = p10[k+1];
	for (   ; k<=n ; k++) p6[k] = p7[k] = zero;
	coeff(p11,i,j) = coeff(p11,j,i) = (long)trace9(p10,p3);
      }
    if (DEBUGLEVEL) msgtimer("mult. table");
  }

  p2=get_roots(x,r1,ru,PRECREG);
  if (DEBUGLEVEL) msgtimer("roots");

  tetpil = avma;
  if (flag & nf_ORIG)
  { 
    if (!(flag & nf_REDUCE)) err(talker,"bad flag in initalgall0");
    res = cgetg(3,t_VEC);
  }
  y=cgetg(10,t_VEC); 
  y[1]=lcopy(x);
  p6=cgetg(3,t_VEC); p6[1]=lstoi(r1); p6[2]=lstoi(r2);
  y[2]=(long)p6;
  if (flag & nf_SMALL) y[3]=y[4]=y[6]=y[8]=y[9]=zero;
  else
  {
    y[3]=lcopy(fieldd);
    y[4]=lcopy(index);
    y[8]=linv(p1);
    y[9]=lmul((GEN)y[8],p5);
  }

  p7 = cgetg(8,t_VEC); y[5] = (long) p7;
  p10 = make_M(n,ru,varn(x),p4,p2);
  p5 = make_MC(n,r1,ru,p10);
  p7[5]=zero; /* dummy for the different */
  if (flag & nf_SMALL)
    p7[1]=p7[2]=p7[4]=p7[6]=p7[7]=zero;
  else
  {
    GEN a2,a3;
    
    p7[1]=(long)p10;
    p7[2]=(long)p5;
    p7[4]=lcopy(p11);

    av2=avma;  p1=ginv(p11); av3=avma;
    p7[6] = lpile(av2,av3,gmul(p1, fieldd));

    av2=avma; p1=content((GEN)p7[6]); a2=gdiv((GEN)p7[6],p1);
    a3=hnfmod(a2,detint(a2)); av3=avma;
    /* Ideal basis for discriminant * (inverse of different) */
    p7[7] = lpile(av2,av3,gmul(a3,p1));
  }
  if (DEBUGLEVEL>=2) msgtimer("matrices MD and D");

  av2=avma; p10=gmul(p5,p10); av3=avma;
  p7[3]=lpile(av2,av3,greal(p10));
  if (DEBUGLEVEL) msgtimer((DEBUGLEVEL>=2)? "matrix T2": "matrices");

  if (! (flag & nf_SMALL)) y[6] = lcopy(p2);
  y[7]=lcopy(p4);

  if (flag & nf_DIFFERENT)
  {
    i = (flag & nf_REDUCE)? pari_randseed: 0;
    mael(y,5,5)=(long)differente(y,fa);
    if (i) pari_randseed = i;
    if (DEBUGLEVEL) msgtimer("different");
  }
  if (! (flag & nf_ORIG)) res = y;
  else
  { 
    res[1]=(long)y;
    res[2]=lead? ldiv(p20,lead): lcopy(p20);
  }
  return gerepile(av,tetpil,res);
}

GEN
initalgred(GEN x, long prec)
{
  return initalgall0(x,nf_REDUCE|nf_DIFFERENT,prec);
}

GEN
initalgred2(GEN x, long prec)
{
  return initalgall0(x,nf_REDUCE|nf_DIFFERENT|nf_ORIG,prec);
}

GEN
nfinit0(GEN x, long flag,long prec)
{
  switch(flag)
  {
    case 0: return initalgall0(x,nf_DIFFERENT,prec);
    case 1: return initalgall0(x,nf_REGULAR,prec);
    case 2: return initalgall0(x,nf_REDUCE|nf_DIFFERENT,prec);
    case 3: return initalgall0(x,nf_REDUCE|nf_ORIG|nf_DIFFERENT,prec);
    case 4: return initalgall0(x,nf_REDUCE|nf_PARTIAL|nf_DIFFERENT,prec);
    case 5: return initalgall0(x,nf_REDUCE|nf_ORIG|nf_PARTIAL|nf_DIFFERENT,prec);
    default: err(flagerr);
  }
  return NULL; /* not reached */
}

GEN
initalg(GEN x, long prec)
{
  return initalgall0(x,nf_DIFFERENT,prec);
}

GEN
nfnewprec(GEN nf, long prec)
{
  long av=avma,i,r1,r2,ru,n,nf_small,tetpil;
  GEN y,pol,p2,p4,p5,p7,p10;

  y=cgetg(10,t_VEC);
  for (i=1; i<=4; i++) y[i]=nf[i];
  for (i=6; i<=9; i++) y[i]=nf[i];
  nf_small = gcmp0((GEN)nf[6]);
  pol=(GEN)nf[1]; n=degree(pol);
  r1=itos(gmael(nf,2,1)); r2=itos(gmael(nf,2,2)); ru=r1+r2;
  p7=cgetg(8,t_VEC); y[5]=(long)p7;
  p4=(GEN)nf[7]; p2=get_roots(pol,r1,ru,prec);
  p10 = make_M(n,ru,varn(pol),p4,p2);
  p5 = make_MC(n,r1,ru,p10);
  if (nf_small) p7[1]=p7[2]=p7[4]=p7[5]=p7[6]=p7[7]=zero;
  else
  {
    GEN matrices=(GEN)nf[5];
    y[6]=(long)p2;
    p7[1]=(long)p10;
    p7[2]=(long)p5;
    for (i=4; i<=7; i++) p7[i]=matrices[i];
  }
  p7[3]=lreal(gmul(p5,p10));
  tetpil=avma; return gerepile(av,tetpil,gcopy(y));
}

static long
nf_pm1(GEN y)
{
  long i,l;

  if (!is_pm1(y[1])) return 0;
  l = lg(y);
  for (i=2; i<l; i++)
    if (signe(y[i])) return 0;
  return signe(y[1]);

}

static GEN
is_primitive_root(GEN nf, GEN fa, GEN x, long w)
{
  GEN y, exp = stoi(2), pp = (GEN)fa[1];
  long i,p, l = lg(pp);

  for (i=1; i<l; i++)
  {
    p = itos((GEN)pp[i]);
    exp[2] = w / p; y = element_pow(nf,x,exp);
    if (nf_pm1(y) > 0) /* y = 1 */
    {
      if (p!=2 || !gcmp1(gcoeff(fa,i,2))) return NULL;
      x = gneg(x);
    }
  }
  return x;
}

GEN
rootsof1(GEN nf)
{
  long av,tetpil,N,k,i,ws,prec;
  GEN algun,p1,y,R1,d,list,w;

  y=cgetg(3,t_VEC); av=avma; nf=checknf(nf);
  R1=gmael(nf,2,1); algun=gmael(nf,8,1);
  if (signe(R1))
  {
    y[1]=deux;
    y[2]=lneg(algun); return y;
  }
  N=lgef(nf[1])-3; prec=gprecision((GEN)nf[6]);
#ifdef LONG_IS_32BIT
  if (prec < 10) prec = 10;
#else
  if (prec < 6) prec = 6;
#endif
  for (i=1; ; i++)
  {
    p1 = fincke_pohst(gmael(nf,5,3),stoi(N),stoi(1000),1,prec);
    if (p1) break;
    if (i == MAXITERPOL) err(accurer,"rootsof1");
    prec=(prec<<1)-2;
    if (DEBUGLEVEL) err(warnprec,"rootsof1",prec);
    nf=nfnewprec(nf,prec);
  }
  if (itos(ground((GEN)p1[2])) != N) err(bugparier,"rootsof1 (bug1)");
  w=(GEN)p1[1]; ws = itos(w);
  if (ws == 2)
  {
    y[1]=deux; avma=av;
    y[2]=lneg(algun); return y;
  }

  d = decomp(w); list = (GEN)p1[3]; k = lg(list);
  for (i=1; i<k; i++)
  {
    p1 = (GEN)list[i];
    p1 = is_primitive_root(nf,d,p1,ws);
    if (p1)
    {
      tetpil=avma;
      y[2]=lpile(av,tetpil,gcopy(p1));
      y[1]=lstoi(ws); return y;
    }
  }
  err(bugparier,"rootsof1");
  return NULL; /* not reached */
}

/*******************************************************************/
/*                                                                 */
/*                     DEDEKIND ZETA FUNCTION                      */
/*                                                                 */
/*******************************************************************/

ulong smulss(ulong x, ulong y, ulong *rem);

static GEN
dirzetak0(GEN nf, long N0)
{
  GEN vect,p1,pol,disc,c,c2;
  long av=avma,i,j,k,lx;
  ulong limk,q,p,rem;
  byteptr d=diffptr;
  long court[] = {evaltyp(t_INT)|evallg(3), evalsigne(1)|evallgefint(3),0};

  pol=(GEN)nf[1]; disc=(GEN)nf[4];
  c  = (GEN) gpmalloc((N0+1)*sizeof(long));
  c2 = (GEN) gpmalloc((N0+1)*sizeof(long));
  c2[0]=c[0]=evaltyp(t_VEC) | evallg(N0+1);
  c2[1]=c[1]=1; for (i=2; i<=N0; i++) c[i]=0;
  court[2] = 0;

  while (court[2]<=N0)
  {
    court[2] += *d++; if (! *d) err(primer1);
    if (smodis(disc,court[2])) /* court does not divide index */
      { vect = (GEN) simplefactmod(pol,court)[1]; lx=lg(vect); }
    else
    {
      p1=primedec(nf,court); lx=lg(p1); vect=cgetg(lx,t_COL);
      for (i=1; i<lx; i++) vect[i]=mael(p1,i,4);
    }
    for (j=1; j<lx; j++)
    {
      p1=gpuigs(court,itos((GEN)vect[j])); /* p1 = court^f */
      if (cmpis(p1,N0) <= 0)
      {
        q=p=p1[2]; limk=N0/q;
        for (k=2; k<=N0; k++) c2[k]=c[k];
        while (q<=N0)
        {
          for (k=1; k<=limk; k++) c2[k*q] += c[k];
          q = smulss(q,p,&rem); 
          if (rem) break;
          limk /= p;
        }
        p1=c; c=c2; c2=p1;
      }
    }
    avma=av;
    if (DEBUGLEVEL>6) fprintferr(" %ld",court[2]);
  }
  if (DEBUGLEVEL>6)
    { fprintferr("\n"); flusherr(); }
  free(c2); return c;
}

GEN
dirzetak(GEN nf, GEN b)
{
  GEN z,c;
  long i;

  if (typ(b)!=t_INT) err(talker,"not an integer type in dirzetak");
  if (signe(b)<=0) return cgetg(1,t_VEC);
  nf = checknf(nf);
  if (cmpsi(VERYBIGINT,b) < 0) err(talker,"too many terms in dirzetak");
  c = dirzetak0(nf,itos(b));
  i = lg(c); z=cgetg(i,t_VEC);
  for (i-- ; i; i--) z[i]=lstoi(c[i]);
  free(c); return z;
}

GEN
initzeta(GEN pol, long prec)
{
  GEN nfz,nf,alpha,beta,mu,gr1,gr2,gru,p1,p2,p3,cst,A0,c0,c1,c2,eps,coef;
  GEN limx,bnf,resi,zet,cik,coeflog,racpi,aij,tabj,colzero, *tabcstn, *tabcstni;
  GEN c_even,ck_even,c_odd,ck_odd,serie_even,serie_odd,serie_exp;
  long N0,imin,imax,r1,r2,ru,R,N,i,j,k,n, av,av2,tetpil;
  long court[] = {evaltyp(t_INT)|evallg(3), evalsigne(1)|evallgefint(3),0};
  stackzone *zone, *zone0, *zone1;

  /*************** Calcul du residu et des constantes ***************/
  eps=gmul2n(gun,-bit_accuracy(prec)-6); p1=dbltor(0.5);
  nfz=cgetg(10,t_VEC);
  bnf=buchinit(pol,p1,p1,prec+1); prec=(prec<<1)-1;
  constpi(prec); consteuler(prec); racpi=gsqrt(gpi,prec);

  /* Nb de classes et regulateur */
  nf=(GEN)bnf[7]; N=lgef(nf[1])-3;
  gr1=gmael(nf,2,1); gr2=gmael(nf,2,2);
  r1=itos(gr1); r2=itos(gr2); ru=r1+r2; R=ru+2;
  av=avma; p1=(GEN)bnf[8]; p2 = gmul(gmul2n(gmael(p1,1,1),r1), (GEN)p1[2]);
  tetpil = avma; resi=gerepile(av,tetpil,gdiv(p2, gmael(p1,4,1)));

  /* Calcul de N0 */
  cst = cgetr(prec); av = avma;
  mu = gadd(gmul2n(gr1,-1),gr2);
  alpha = gmul2n(stoi(ru+1),-1);
  beta = gpui(gdeux,gmul2n(gr1,-1),DEFAULTPREC);
  A0 = gmul2n(gpuigs(mu,R),r1);
  A0 = gmul(A0,gpuigs(gmul2n(gpi,1),1-ru));
  A0 = gsqrt(A0,DEFAULTPREC);

  c1 = gmul(mu,gpui(beta,ginv(mu),DEFAULTPREC));
  c0 = gdiv(gmul(A0,gpuigs(gmul2n(gpi,1),ru-1)),mu);
  c0 = gmul(c0,gpui(c1,gneg(alpha),DEFAULTPREC));
  c2 = gdiv(alpha,mu);

  p1 = glog(gdiv(c0,eps),DEFAULTPREC);
  limx = gdiv(gsub(glog(p1,DEFAULTPREC),glog(c1,DEFAULTPREC)),
              gadd(c2,gdiv(p1,mu)));
  limx = gmul(gpui(gdiv(c1,p1),mu,DEFAULTPREC),
              gadd(gun,gmul(alpha,limx)));
  p1 = gsqrt(absi((GEN)nf[3]),prec);
  p2 = gmul2n(gpuigs(racpi,N),r2);
  gaffect(gdiv(p1,p2), cst);

  av = avma; p1 = gfloor(gdiv(cst,limx)); N0 = p1[2];
  if (cmpsi(VERYBIGINT,p1) < 0 || N0 > 10000000)
    err(talker,"discriminant too large for initzeta, sorry");
  if (DEBUGLEVEL>=2)
    { fprintferr("\ninitzeta:\nN0 = %ld\n",N0); flusherr(); timer2(); }

  /* Calcul de imax */

  imin=1; imax=1400;
  p1 = gmul(gpuigs(gmul2n(racpi,1),r2),gpuigs(stoi(5),r1));
  p1 = gdiv(p1,gmul(gmul(gsqrt(limx,DEFAULTPREC),gmul2n(eps,4)),
                         gpuigs(racpi,3)));
  while (imax-imin >= 4)
  {
    long itest = (imax+imin)>>1;
    p2 = gmul(gpuigs(mpfactr(itest,DEFAULTPREC),r2),gpuigs(limx,itest));
    p2 = gmul(p2,gpuigs(mpfactr(itest/2,DEFAULTPREC),r1));
    if (gcmp(p2,p1) >= 0) imax=itest; else imin=itest;
  }
  imax -= (imax & 1); avma = av;
  if (DEBUGLEVEL>=2) { fprintferr("imax = %ld\n",imax); flusherr(); }

  /* Tableau des i/cst (i=1 a N0) */

  i = prec*N0;
  zone  = switch_stack(NULL,i + 2*(N0+1) + 5*prec);
  zone1 = switch_stack(NULL,2*i);
  zone0 = switch_stack(NULL,2*i);
  switch_stack(zone,1);
  tabcstn  = (GEN*) cgetg(N0+1,t_VEC);
  tabcstni = (GEN*) cgetg(N0+1,t_VEC);
  for (i=1; i<=N0; i++)
  {
    tabcstn[i]=gdivsg(i,cst); tabcstni[i]=gun;
  }
  switch_stack(zone,0);

  /********** Calcul des coefficients a(i,j) independants de s **********/

  zet=cgetg(R,t_VEC); zet[1]=(long)geuler;
  for (i=2; i<R; i++)
    zet[i]=(long)gzeta(stoi(i),prec);

  aij=cgetg(imax+1,t_VEC);
  for (i=1; i<=imax; i++)
    aij[i]=lgetg(R,t_VEC);

  affsr(1,c_even=cgetr(prec)); c_even=gmul2n(c_even,r1);
  c_odd=gmul(c_even,gpuigs(racpi,r1));
  if (ru&1) c_odd=gneg(c_odd);
  ck_even=cgetg(R,t_VEC); ck_odd=cgetg(r2+2,t_VEC);
  for (k=1; k<R; k++)
  {
    ck_even[k]=lmul((GEN)zet[k],gadd(gr2,gmul2n(gr1,-k)));
    if (k&1) ck_even[k]=lneg((GEN)ck_even[k]);
  }
  gru=stoi(ru);
  for (k=1; k<=r2+1; k++)
  {
    ck_odd[k]=lmul((GEN)zet[k], gsub(gru, gmul2n(gr1,-k)));
    if (k&1) ck_odd[k]=lneg((GEN)ck_odd[k]);
    ck_odd[k]=ladd(gru,(GEN)ck_odd[k]);
  }
  ck_odd[1]=lsub((GEN)ck_odd[1],gmul(gr1,glog(gdeux,prec)));
  serie_even =cgetg(ru+3,t_SER); serie_odd=cgetg(r2+3,t_SER);
  serie_even[1] = serie_odd[1] = evalsigne(1)+evalvalp(1);
  i=0;

  while (i<imax/2)
  {
    for (k=1; k<R; k++)
      serie_even[k+1]=ldivgs((GEN)ck_even[k],k);
    serie_exp=gmul(c_even,gexp(serie_even,0));
    p1=(GEN)aij[2*i+1];
    for (j=1; j<R; j++) p1[j]=serie_exp[ru+3-j];

    for (k=1; k<=r2+1; k++)
      serie_odd[k+1]=ldivgs((GEN)ck_odd[k],k);
    serie_exp=gmul(c_odd,gexp(serie_odd,0));
    p1=(GEN)aij[2*i+2];
    for (j=1; j<=r2+1; j++) p1[j]=serie_exp[r2+3-j];
    for (   ; j<R; j++) p1[j]=zero;
    i++;

    c_even = gdiv(c_even,gmul(gpuigs(stoi(i),ru),gpuigs(stoi(2*i-1),r2)));
    c_odd  = gdiv(c_odd, gmul(gpuigs(stoi(i),r2),gpuigs(stoi(2*i+1),ru)));
    c_even = gmul2n(c_even,-r2);
    c_odd  = gmul2n(c_odd,r1-r2);
    if (r1&1) { c_even=gneg(c_even); c_odd=gneg(c_odd); }
    p1 = gr2; p2 = gru;
    for (k=1; k<R; k++)
    {
      p1=gdivgs(p1,2*i-1); p2=gdivgs(p2,2*i);
      ck_even[k] = ladd((GEN)ck_even[k], gadd(p1,p2));
    }
    p1 = p2 = gru; p3 = gr1;
    for (k=1; k<=r2+1; k++)
    {
      p1=gdivgs(p1,2*i+1); p2=gdivgs(p2,2*i); p3=gdivgs(p3,2*i);
      ck_odd[k] = ladd((GEN)ck_odd[k], gsub(gadd(p1,p2),p3));
    }
  }
  tetpil=avma; aij=gerepile(av,tetpil,gcopy(aij));
  if (DEBUGLEVEL>=2) msgtimer("a(i,j)");
  p1=cgetg(5,t_VEC);
  p1[1]=lstoi(r1); p1[2]=lstoi(r2); p1[3]=lstoi(imax); p1[4]=(long)bnf;
  nfz[1]=(long)p1; 
  nfz[2]=(long)resi;
  nfz[5]=(long)cst;
  nfz[6]=llog(cst,prec);
  nfz[7]=(long)aij;

  /************* Calcul du nombre d'ideaux de norme donnee *************/

  coef = dirzetak0(nf,N0); tabj = cgetg(N0+1,t_MAT);
  if (DEBUGLEVEL>=2) msgtimer("coef");
  colzero=cgetg(ru+2,t_COL); for (j=1; j<=ru+1; j++) colzero[j]=zero;
  for (i=1; i<=N0; i++)
    if (coef[i])
    {
      tabj[i]=lgetg(ru+2,t_COL); /* tabj[n,j]=coef(n)*ln(c/n)^(j-1)/(j-1)! */
      av=avma; p1=negr(glog((GEN)tabcstn[i],prec));
      coeff(tabj,1,i)=un; coeff(tabj,2,i)=(long)p1;
      for (j=2; j<=ru; j++)
	coeff(tabj,j+1,i)=ldivrs(gmul(gcoeff(tabj,j,i),p1),j);
      tetpil=avma; tabj[i]=lpile(av,tetpil,gmulgs((GEN)tabj[i],coef[i]));
    }
    else tabj[i]=(long)colzero;
  if (DEBUGLEVEL>=2) msgtimer("a(n)");

  coeflog=cgetg(N0+1,t_VEC); coeflog[1]=zero;
  for (i=2; i<=N0; i++)
    if (coef[i])
    {
      court[2]=i; p1=glog(court,prec);
      setsigne(p1,-1); coeflog[i]=(long)p1;
    }
    else coeflog[i] = zero;
  if (DEBUGLEVEL>=2) msgtimer("log(n)");

  nfz[3]=(long)tabj;
  p1=cgetg(N0+1,t_VEC); 
  for (i=1; i<=N0; i++) p1[i]=lstoi(coef[i]);
  nfz[8]=(long)p1;
  nfz[9]=(long)coeflog;

  /******************** Calcul des coefficients Cik ********************/

  cik=cgetg(ru+1,t_MAT);
  for (k=1; k<=ru; k++) cik[k]=lgetg(imax+1,t_COL);
  av2 = avma;
  for (i=1; i<=imax; i++)
  {
    stackzone *z;
    for (k=1; k<=ru; k++)
    {
      p1 = NULL;
      for (n=N0; n; n--)
        if (coef[n])
          for (j=1; j<=ru-k+1; j++)
          {
            p2 = gmul(tabcstni[n], 
                      gmul(gmael(aij,i,j+k), gcoeff(tabj,j,n)));
            p1 = p1? gadd(p1,p2): p2;
          }
      coeff(cik,i,k) = p1? (long)gerepileupto(av2,p1): zero;
      av2 = avma;
    }
    /* use a parallel stack */
    z = i&1? zone1: zone0;
    switch_stack(z, 1);
    for (n=1; n<=N0; n++)
      if (coef[n]) tabcstni[n] = mpmul(tabcstni[n],tabcstn[n]);
    /* come back */
    switch_stack(z, 0);
  }
  nfz[4] = (long) cik;
  if (DEBUGLEVEL>=2) msgtimer("Cik");
  free((void*)zone); free((void*)zone1); free((void*)zone0);
  free((void*)coef); return nfz;
}

GEN
gzetakall(GEN nfz, GEN s, long flag, long prec2)
{
  GEN resi,cik,cst,cstlog,coeflog,cs,gcoef;
  GEN lambd,gammas,gammaunmoins,gammas2,gammaunmoins2,var1,var2;
  GEN p1,unmoins,gexpro,gar,val,valm,valk,valkm,val2,valm2,valk2,valkm2;
  long ts = typ(s), r1,r2,ru,imax,i,j,k,N0,sl,prec,bigprec, av = avma;

  if (typ(nfz)!=t_VEC || lg(nfz)!=10 || typ(nfz[1]) != t_VEC)
    err(talker,"not a zeta number field in zetakall");
  if (! is_intreal_t(ts) && ts != t_COMPLEX && ! is_frac_t(ts))
    err(typeer,"gzetakall");
  resi=(GEN)nfz[2]; cik=(GEN)nfz[4]; cst=(GEN)nfz[5];
  cstlog=(GEN)nfz[6]; gcoef=(GEN)nfz[8]; coeflog=(GEN)nfz[9];
  r1  =itos(gmael(nfz,1,1));
  r2  =itos(gmael(nfz,1,2));
  imax=itos(gmael(nfz,1,3));
  N0=lg(gcoef)-1; ru=r1+r2;
  /* from initzeta. Certainly excessive, at least if LONG_IS_64BIT */
  bigprec = min(precision(cst), (prec2<<1) - 1);
  prec = prec2+1;

  if (ts==t_REAL && !signe(gfrac(s)))
    { s=mptrunc(s); avma=av; ts = t_INT; }
  if (ts==t_INT)
  {
    sl=itos(s);
    if (sl==1) err(talker,"s = 1 is a pole (gzetakall)");
    if (sl==0)
    { 
      if (flag) err(talker,"s = 0 is a pole (gzetakall)");
      if (ru == 1)
      {
        if (r1) return gneg(ghalf);
        return gneg(resi);
      }
      return gzero;
    }
    if (sl<0 && (r2 || !odd(sl)))
    {
      if (!flag) return gzero;
      s = subsi(1,s); sl = 1-sl;
    }
    unmoins=subsi(1,s);
    lambd = gdiv(resi, mulis(s,sl-1));
    gammas2=ggamma(gmul2n(s,-1),prec);
    gar=gpuigs(gammas2,r1);
    cs=gexp(gmul(cstlog,s),prec); 	
    val=s; valm=unmoins;
    if (sl<0)
    {
      gammaunmoins2=ggamma(gmul2n(unmoins,-1),prec);
      var1=var2=gun;
      for (i=2; i<=N0; i++)
	if (signe(gcoef[i]))
	{
          gexpro=gexp(gmul((GEN)coeflog[i],s),bigprec);
	  var1=gadd(var1,gmulsg(((GEN)gcoef[i])[2],gexpro));
	  var2=gadd(var2,gdivsg(((GEN)gcoef[i])[2],gmulsg(i,gexpro)));
	}
      lambd=gadd(lambd,gmul(gmul(var1,cs),gar));
      lambd=gadd(lambd,gmul(gmul(var2,gdiv(cst,cs)),
			    gpuigs(gammaunmoins2,r1)));
      for (i=1; i<=imax; i+=2)
      {
	valk=val; valkm=valm;
	for (k=1; k<=ru; k++)	
	{
	  lambd=gsub(lambd,gdiv(gcoeff(cik,i,k),valk));
	  lambd=gsub(lambd,gdiv(gcoeff(cik,i,k),valkm));
	  valk=mulii(val,valk); valkm=mulii(valm,valkm);
	}
	val=addis(val,2); valm=addis(valm,2);
      }
    }
    else
    {
      GEN tabj=(GEN)nfz[3], aij=(GEN)nfz[7]; 

      gar = gmul(gar,gpuigs(ggamma(s,prec),r2));
      var1=var2=gzero;
      for (i=1; i<=N0; i++)
	if (signe(gcoef[i]))
	{
	  gexpro=gexp(gmul((GEN)coeflog[i],s),bigprec);
	  var1=gadd(var1,gmulsg(((GEN)gcoef[i])[2],gexpro));
          if (sl <= imax)
          {
            p1=gzero;
            for (j=1; j<=ru+1; j++)
              p1 = gadd(p1, gmul(gmael(aij,sl,j), gmael(tabj,i,j)));
            var2=gadd(var2,gdiv(p1,gmulsg(i,gexpro)));
          }
	}
      lambd=gadd(lambd,gmul(gmul(var1,cs),gar));
      lambd=gadd(lambd,gmul(var2,gdiv(cst,cs)));
      for (i=1; i<=imax; i++)
      {
	valk=val; valkm=valm;
	for (k=1; k<=ru; k++)
	{	
	  lambd=gsub(lambd,gdiv(gcoeff(cik,i,k),valk));
	  if (i!=sl)
	    lambd=gsub(lambd,gdiv(gcoeff(cik,i,k),valkm));
	  valk=mulii(val,valk); valkm=mulii(valm,valkm);
	}
	val=addis(val,1); valm=addis(valm,1);
      }
    }
  }
  else
  {
    constpi(prec);
    if (is_frac_t(ts))
    {
      p1 = cgetr(bigprec); affsr(1,p1); s=gmul(s,p1); 
    }
    else s = gprec(s, (long)((bigprec-2)*pariK));

    unmoins = gsub(gun,s);
    lambd = gdiv(resi,gmul(s,gsub(s,gun)));
    gammas = ggamma(s,prec);
    gammas2= ggamma(gmul2n(s,-1),prec);
    gar = gmul(gpuigs(gammas,r2),gpuigs(gammas2,r1));
    cs = gexp(gmul(cstlog,s),prec);
    var1 = gmul(gpi,s);
    gammaunmoins = gdiv(gpi,gmul(gsin(var1,prec),gammas));
    gammaunmoins2= gdiv(gmul(gmul(gsqrt(gpi,prec),gpui(gdeux,gsub(s,gun),prec)),
                             gammas2),
                        gmul(gcos(gmul2n(var1,-1),prec),gammas));
    var1 = var2 = gun;
    for (i=2; i<=N0; i++)
      if (signe(gcoef[i]))
      {
        gexpro = gexp(gmul((GEN)coeflog[i],s),bigprec);
	var1 = gadd(var1,gmulsg(((GEN)gcoef[i])[2], gexpro));
	var2 = gadd(var2,gdivsg(((GEN)gcoef[i])[2],gmulsg(i,gexpro)));
      }
    lambd = gadd(lambd,gmul(gmul(var1,cs),gar));
    lambd = gadd(lambd,gmul(gmul(gmul(var2,gdiv(cst,cs)),
	 		         gpuigs(gammaunmoins,r2)),
                            gpuigs(gammaunmoins2,r1)));
    val=s; valm=unmoins;
    for (i=1; i<=imax; i++)
    {
      valk=val; valkm=valm;
      for (k=1; k<=ru; k++)
      {
	lambd = gsub(lambd,gdiv(gcoeff(cik,i,k),valk));
	lambd = gsub(lambd,gdiv(gcoeff(cik,i,k),valkm));
	valk = gmul(val,valk); valkm = gmul(valm,valkm);
      }
      i++;
      if (r2)
      {
	valk2 = val2 = gadd(val,gun); 
        valkm2 = valm2 = gadd(valm,gun);
	for (k=1; k<=ru; k++)
	{
	  lambd = gsub(lambd,gdiv(gcoeff(cik,i,k),valk2));
	  lambd = gsub(lambd,gdiv(gcoeff(cik,i,k),valkm2));
	  valk2 = gmul(val2,valk2); valkm2 = gmul(valm2,valkm2);
	}
      }
      val = gadd(val,gdeux); valm = gadd(valm,gdeux);
    }
  }
  if (!flag) lambd = gdiv(lambd,gmul(gar,cs)); /* zetak */

  /* Safe: the stack is big enough */
  avma = av; return gprec(lambd, (long)((prec2-2)*pariK));
}

GEN
gzetak(GEN nfz, GEN s, long prec)
{
  return gzetakall(nfz,s,0,prec);
}

GEN
glambdak(GEN nfz, GEN s, long prec)
{
  return gzetakall(nfz,s,1,prec);
}
