/*******************************************************************/
/*******************************************************************/
/*                                                                 */
/*              PROGRAMME D'INITIALISATION DU SYSTEME              */
/*                    ET TRAITEMENT DES ERREURS                    */
/*                                                                 */
/*          (Fichier pour la calculette gp uniquement)             */
/*                                                                 */
/*******************************************************************/
/*******************************************************************/
/* $Id: gp_init.c,v 2.0.0.8 1998/05/04 12:54:11 belabas Exp belabas $ */
#include "pari.h"
#include "rect.h"

void  addhelp(entree *ep, char *s);
void  allocatemem0(unsigned long newsize);
GEN   default0(char *a, char *b, long flag);
void  error0(GEN *g);
GEN   extern0(char *cmd);
void  gp_quit(void);
GEN   input0();
void  install0(char *name, char *code, char *gpname, char *lib);
void  kill0(entree *ep);
void  print0(GEN *g,long flag);
GEN   read0(char *s);
long  setprecr(long n);
void  system0(char *cmd);
GEN   type0(GEN x, char *st);
int   whatnow(char *s, int silent);
void  write0(char *s, GEN *g, long flag);

static void
whatnow0(char *s) { whatnow(s,0); }

entree functions_gp[]={
{"addhelp",99,(void*)addhelp,11,"vSs"},
{"allocatemem",0,(void*)allocatemem0,11,"vD0,L,"},
{"default",0,(void*)default0,11,"D\"\",r,D\"\",s,D0,L,"},
{"error",0,(void*)error0,11,"vs*"},
{"extern",1,(void*)extern0,11,"s"},
{"input",0,(void*)input0,11,""},
{"install",4,(void*)install0,11,"vrrD\"\",r,D\"\",r,"},
{"kill",85,(void*)kill0,11,"vS"},
{"plot",37,(void*)plot,10,"vV=GGI"},
{"plotbox",35,(void*)rectbox,10,"vLGG"},
{"plotcolor",2,(void*)rectcolor,10,"vLL"},
{"plotcopy",44,(void*)rectcopy,10,"vLLLL"},
{"plotcursor",11,(void*)rectcursor,10,"L"},
{"plotdraw",1,(void*)rectdraw,10,"vG"},
{"ploth",37,(void*)ploth,10,"V=GGIpD0,L,D0,L,"},
{"plothraw",2,(void*)plothraw,10,"GGD0,L,"},
{"plothsizes",0,(void*)plothsizes,10,""},
{"plotinit",34,(void*)initrect,10,"vLLL"},
{"plotkill",11,(void*)killrect,10,"vL"},
{"plotlines",35,(void*)rectlines,10,"vLGGD0,L,"},
{"plotlinetype",19,(void*)rectlinetype,10,"vLL"},
{"plotmove",35,(void*)rectmove,10,"vLGG"},
{"plotpoints",35,(void*)rectpoints,10,"vLGG"},
{"plotpointtype",19,(void*)rectpointtype,10,"vLL"},
{"plotrbox",35,(void*)rectrbox,10,"vLGG"},
{"plotrecth",73,(void*)rectploth,10,"LV=GGIpD0,L,D0,L,"},
{"plotrecthraw",45,(void*)rectplothraw,10,"LGD0,L,"},
{"plotrline",35,(void*)rectrline,10,"vLGG"},
{"plotrmove",35,(void*)rectrmove,10,"vLGG"},
{"plotrpoint",35,(void*)rectrpoint,10,"vLGG"},
{"plotscale",59,(void*)rectscale,10,"vLGGGG"},
{"plotstring",57,(void*)rectstring,10,"vLs"},
{"plotterm",16,(void*)term_set,10,"sl"},
{"print",0,(void*)print0,11,"vs*D0,L,"},
{"print1",0,(void*)print0,11,"vs*D4,L,"},
{"printp",0,(void*)print0,11,"vs*D2,L,"},
{"printp1",0,(void*)print0,11,"vs*D6,L,"},
{"printtex",0,(void*)print0,11,"vs*D3,L,"},
{"psdraw",1,(void*)postdraw,10,"vG"},
{"psploth",37,(void*)postploth,10,"V=GGIpD0,L,D0,L,"},
{"psplothraw",2,(void*)postplothraw,10,"GGD0,L,"},
{"quit",0,(void*)gp_quit,11,"v"},
{"read",0,(void*)read0,11,"D\"\",s,"},
{"system",70,(void*) system0,11,"vs"},
{"type",1,(void*)type0,11,"GD\"\",r,"},
{"whatnow",1,(void*)whatnow0,11,"vr"},
{"write",0,(void*)write0,11,"vss*D0,L,"},
{"write1",0,(void*)write0,11,"vss*D4,L,"},
{"writetex",0,(void*)write0,11,"vss*D3,L,"},

{NULL,0,NULL,0,NULL} /* sentinel */
};

char *helpmessages_gp[]={
  "addhelp(symbol,\"message\"): add/change help message for a symbol",
  "allocatemem({s=0}): allocates a new stack of s bytes. doubles the stack if s is omitted",
  "default({opt},{v},{flag}): set the default opt to v. If v is omitted, print the current default for opt. If no argument is given, print a list of all defaults as well as their values. If flag is non-zero, return the result instead of printing it on screen. See manual for details",
  "error(\"msg\"): abort script with error message msg",
  "extern(cmd): execute shell command cmd, and feeds the result to GP (as if loading from file)",
  "input(): read an expression from the input file or standard input",
  "install(name,code,{gpname},{lib}): load from dynamic library 'lib' the function 'name'. Assign to it the name 'gpname' in this GP session, with argument code 'code'. If 'lib' is omitted use 'libpari.so'. If 'gpname' is omitted, use 'name'",
  "kill(x):  kills the present value of the variable or function x. Returns new value or 0",
  "plot(X=a,b,expr): crude plot of expression expr, X goes from a to b",
  "plotbox(w,x2,y2): if the cursor is at position (x1,y1), draw a box with diagonal (x1,y1) and (x2,y2) in rectwindow w (cursor does not move)",
  "plotcolor(w,c): in rectwindow w, set default color to c. Possible values for c are 1=black, 2=blue, 3=sienna, 4=red, 5=cornsilk, 6=grey, 7=gainsborough",
  "plotcopy(sourcew,destw,dx,dy): copy the contents of rectwindow sourcew to rectwindow destw with offset (dx,dy)",
  "plotcursor(w): current position of cursor in rectwindow w",
  "plotdraw(list): draw vector of rectwindows list at indicated x,y positions; list is a vector w1,x1,y1,w2,x2,y2,etc. . ",
  "ploth(X=a,b,expr,{flags=0},{n=0}): plot of expression expr, X goes from a to b in high resolution. Both flags and n are optional. Binary digits of flags mean : 1 parametric plot, 2 recursive plot, 8 omit x-axis, 16 omit y-axis, 32 omit frame, 64 do not join points. n specifies number of reference points on the graph (0=use default value). Returns a vector for the bounding box",
  "plothraw(listx,listy,{flag=0}): plot in high resolution points whose x (resp. y) coordinates are in listx (resp. listy). If flag is non zero, join points",
  "plothsizes(): returns array of 6 elements: terminal width and height, sizes for ticks in horizontal and vertical directions (in pixels), width and height of characters",
  "plotinit(w,x,y): initialize rectwindow w to size x,y",
  "plotkill(w): erase the rectwindow w",
  "plotlines(w,listx,listy,{flag=0}): draws an open polygon in rectwindow w where listx and listy contain the x (resp. y) coordinates of the vertices. If listx and listy are both single values (i.e not vectors), draw the corresponding line (and move cursor). If (optional) flag is non-zero, close the polygon",
  "plotlinetype(w,type): change the type of following lines in rectwindow w. -2 corresponds to frames, -1 to axes, larger values may correspond to something else",
  "plotmove(w,x,y): move cursor to position x,y in rectwindow w",
  "plotpoints(w,listx,listy): draws in rectwindow w the points whose x (resp y) coordinates are in listx (resp listy). If listx and listy are both single values (i.e not vectors), draw the corresponding point (and move cursor)",
  "plotpointtype(w,type): change the type of following points in rectwindow w. -1 corresponds to a dot, larger values may correspond to something else",
  "plotrbox(w,dx,dy): if the cursor is at (x1,y1), draw a box with diagonal (x1,y1)-(x1+dx,y1+dy) in rectwindow w (cursor does not move)",
  "plotrecth(w,X=xmin,xmax,expr,{flags=0},{n=0}): plot graph(s) for expr in rectwindow w, where expr is scalar for a single non-parametric plot, and a vector otherwise. If plotting is parametric, its length should be even and pairs of entries give points coordinates. If not, all entries but the first are y-coordinates. Both flags and n are optional. Binary digits of flags mean: 1 parametric plot, 2 recursive plot, 4 do not rescale w, 8 omit x-axis, 16 omit y-axis, 32 omit frame, 64 do not join points. n specifies the number of reference points on the graph (0=use default value). Returns a vector for the bounding box",
  "plotrecthraw(w,data,{flags=0}): plot graph(s) for data in rectwindow w, where data is a vector of vectors. If plot is parametric, length of data should be even, and pairs of entries give curves to plot. If not, first entry gives x-coordinate, and the other ones y-coordinates. Admits the same optional flags as plotrecth, save that recursive plot is meaningless",
  "plotrline(w,dx,dy): if the cursor is at (x1,y1), draw a line from (x1,y1) to (x1+dx,y1+dy) (and move the cursor) in the rectwindow w",
  "plotrmove(w,dx,dy): move cursor to position (dx,dy) relative to the present position in the rectwindow w",
  "plotrpoint(w,dx,dy): draw a point (and move cursor) at position dx,dy relative to present position of the cursor in rectwindow w",
  "plotscale(w,x1,x2,y1,y2): scale the coordinates in rectwindow w so that x goes from x1 to x2 and y from y1 to y2 (y2<y1 is allowed)",
  "plotstring(w,x): draw in rectwindow w the string corresponding to x",
  "plotterm(\"termname\"): set terminal to plot in high resolution to. Ignored by some drivers. In gnuplot driver possible terminals are the same as in gnuplot. Positive value means success",
  "print(a): outputs a (in raw format) ending with newline",
  "print1(a): outputs a (in raw format) without ending with newline",
  "printp(a): outputs a (in beautified format) ending with newline",
  "printp1(a): outputs a (in beautified format) without ending with newline",
  "printtex(a): outputs a in TeX format",
  "psdraw(list): same as draw, except that the output is a postscript program in psfile (pari.ps by default)",
  "psploth(X=a,b,expr,{flags=0},{n=0}): same as ploth, except that the output is a postscript program in psfile (pari.ps by default)",
  "psplothraw(listx,listy,{flag=0}): same as plothraw, except that the output is a postscript program in psfile (pari.ps by default)",
  "quit(): quits GP and return to the system",
  "read({filename}): read from the input file filename. If filename is omitted, reread last input file (be it from readfile or \\r)",
  "system(a): a being a string, execute the system command a (not valid on every machine)",
  "type(x,{t}): if t is not present, output the type of the GEN x. Else make a copy of x with type t. Use with extreme care, usually with t = t_FRACN or t = t_RFRACN). Try \\t for a list of types",
  "whatnow(fun): if f was present in GP version 1.39.15 or lower, gives the new function name",
  "write(filename,a): write the string expression a (same output as print) to filename",
  "write1(filename,a): write the string expression a (same output as print1) to filename",
  "writetex(filename,a): write the string expression a (same format as print) to filename, in TeX format",
};

/* Backward Compatibility */

static GEN
gtype(GEN x)
{
  return stoi(typ(x));
}

static GEN
gsettype(GEN x,long t)
{
  x=gcopy(x); settyp(x,t); return x;
}

static long
setserieslength(long n)
{
  long m=precdl;
  if(n>0) precdl=n;
  return m;
}

entree functions_oldgp[] = {
{"allocatemem",11,(void *)allocatemem0,2,"vLp"},
{"box",35,(void *)rectbox,10,"vLGG"},
{"color",2,(void *)rectcolor,2,"vLL"},      
{"cursor",11,(void*)rectcursor,10,"vLp"},
{"default",0,(void*)default0,11,"D\"\",r,D\"\",s,D0,L,"},
{"draw",1,(void*)rectdraw,10,"vGp"},
{"initrect",34,(void*)initrect,10,"vLLL"},
{"kill",85,(void*)kill0,11,"vS"},
{"killrect",11,(void *)killrect,10,"vL"},
{"line",35,(void *)rectline,10,"vLGG"},
{"lines",35,(void *)rectlines,10,"vLGG"},
{"move",35,(void*)rectmove,10,"vLGG"},
{"plot",37,(void *)plot,10,"vV=GGIp"},
{"ploth",37,(void *)ploth,10,"V=GGIp"},
{"ploth2",37,(void *)ploth2,10,"V=GGIp"},
{"plothmult",37,(void *)plothmult,10,"V=GGIp"},
{"plothraw",2,(void *)plothraw,10,"GGp"},
{"point",35,(void *)rectpoint,10,"vLGG"},
{"points",35,(void *)rectpoints,10,"vLGG"},
{"postdraw",1,(void *)postdraw,10,"vG"},
{"postploth",37,(void *)postploth,10,"V=GGIpD0,L,D0,L,"},
{"postploth2",37,(void *)postploth2,10,"V=GGIpD0,L,"},
{"postplothraw",2,(void *)postplothraw,10,"GGD0,L,"},
{"pprint",0,(void*)print0,11,"vs*D2,L,"},
{"pprint1",0,(void*)print0,11,"vs*D6,L,"},
{"print",0,(void*)print0,11,"vs*D0,L,"},
{"print1",0,(void*)print0,11,"vs*D4,L,"},
{"rbox",35,(void *)rectrbox,10,"vLGG"},
{"read",0,(void *)input0,11,""},
{"rline",35,(void *)rectrline,10,"vLGG"},
{"rlines",35,(void *)rectlines,10,"vLGG"},
{"rmove",35,(void *)rectrmove,10,"vLGG"},      
{"rpoint",35,(void *)rectrpoint,10,"vLGG"},      
{"rpoints",35,(void *)rectpoints,10,"vLGG"},      
{"scale",59,(void *)rectscale,10,"vLGGGG"},
{"setprecision",15,(void *)setprecr,2,"Ll"},
{"setserieslength",15,(void *)setserieslength,2,"Ll"},
{"settype",21,(void *)gsettype,2,"GL"},
{"string",57,(void*)rectstring,10,"vLs"},
{"system",70,(void*) system0,11,"vs"},
{"texprint",0,(void*)print0,11,"vs*D3,L,"},
{"type",1,(void *)gtype,2,"Gp"},

{NULL,0,NULL,0,NULL} /* sentinel */
};

char *helpmessages_oldgp[] = {
  "allocatemem(s)=allocates a new stack of s bytes, or doubles the stack if size is 0",
  "box(w,x2,y2)=if the cursor is at position (x1,y1), draw a box with diagonal (x1,y1) and (x2,y2) in rectwindow w (cursor does not move)",
  "color(w,c)=set default color to c in rectwindow. Possible values for c are 1=sienna, 2=cornsilk, 3=red, 4=black, 5=grey, 6=blue, 7=gainsborough",
  "cursor(w)=current position of cursor in rectwindow w",
  "default({opt},{v},{flag}): set the default opt to v. If v is omitted, print the current default for opt. If no argument is given, print a list of all defaults as well as their values. If flag is non-zero, return the result instead of printing it on screen. See manual for details",
  "draw(list)=draw vector of rectwindows list at indicated x,y positions; list is a vector w1,x1,y1,w2,x2,y2,etc...",
  "initrect(w,x,y)=initialize rectwindow w to size x,y",
  "kill(x)= kills the present value of the variable or function x. Returns new value or 0",
  "killrect(w)=erase the rectwindow w",
  "line(w,x2,y2)=if cursor is at position (x1,y1), draw a line from (x1,y1) to (x2,y2) (and move the cursor) in the rectwindow w",
  "lines(w,listx,listy)=draws an open polygon in rectwindow w where listx and listy contain the x (resp. y) coordinates of the vertices",
  "move(w,x,y)=move cursor to position x,y in rectwindow w",
  "plot(X=a,b,expr)=crude plot of expression expr, X goes from a to b",
  "ploth(X=a,b,expr)=plot of expression expr, X goes from a to b in high resolution",
  "ploth2(X=a,b,[expr1,expr2])=plot of points [expr1,expr2], X goes from a to b in high resolution",
  "plothmult(X=a,b,[expr1,...])=plot of expressions expr1,..., X goes from a to b in high resolution",
  "plothraw(listx,listy)=plot in high resolution points whose x (resp. y) coordinates are in listx (resp. listy)",
  "point(w,x,y)=draw a point (and move cursor) at position x,y in rectwindow w",
  "points(w,listx,listy)=draws in rectwindow w the points whose x (resp y) coordinates are in listx (resp listy)",
  "postdraw(list)=same as draw, except that the output is a postscript program in file \"pari.ps\"",
  "postploth(X=a,b,expr)=same as ploth, except that the output is a postscript program in the file \"pari.ps\"",
  "postploth2(X=a,b,[expr1,expr2])=same as ploth2, except that the output is a postscript program in the file \"pari.ps\"",
  "postplothraw(listx,listy)=same as plothraw, except that the output is a postscript program in the file \"pari.ps\"",
  "pprint(a)=outputs a in beautified format ending with newline",
  "pprint1(a)=outputs a in beautified format without ending with newline",
  "print(a)=outputs a in raw format ending with newline",
  "print1(a)=outputs a in raw format without ending with newline",
  "rbox(w,dx,dy)=if the cursor is at (x1,y1), draw a box with diagonal (x1,y1)-(x1+dx,y1+dy) in rectwindow w (cursor does not move)",
  "read()=read an expression from the input file or standard input",
  "rline(w,dx,dy)=if the cursor is at (x1,y1), draw a line from (x1,y1) to (x1+dx,y1+dy) (and move the cursor) in the rectwindow w",
  "rlines(w,dx,dy)=draw in rectwindow w the points given by vector of first coordinates xsand vector of second coordinates, connect them by lines",
  "rmove(w,dx,dy)=move cursor to position (dx,dy) relative to the present position in the rectwindow w",
  "rpoint(w,dx,dy)=draw a point (and move cursor) at position dx,dy relative to present position of the cursor in rectwindow w",
  "rpoints(w,xs,ys)=draw in rectwindow w the points given by vector of first coordinates xs and vector of second coordinates ys",
  "scale(w,x1,x2,y1,y2)=scale the coordinates in rectwindow w so that x goes from x1 to x2 and y from y1 to y2 (y2<y1 is allowed)",
  "setprecision(n)=set the current precision to n decimal digits if n>0, or return the current precision if n<=0",
  "setserieslength(n)=set the default length of power series to n if n>0, or return the current default length if n<=0",
  "settype(x,t)=make a copy of x with type t (to use with extreme care)",
  "string(w,x)=draw in rectwindow w the string corresponding to x, where x is either a string, or a number in R, written in format 9.3",
  "system(a): a being a string, execute the system command a (not valid on every machine)",
  "texprint(a)=outputs a in TeX format",
  "type(x)=internal type number of the GEN x"
};
