/******************************************************************/
/* This file contains memory and I/O management definitions       */
/* $Id: parimemio.h,v 2.0.0.8 1998/05/04 12:54:11 belabas Exp belabas $ */

typedef unsigned char *byteptr;

typedef struct stackzone
{
  long zonetop, bot, top, avma, memused;
} stackzone;

typedef struct entree {
  char *name;
  ulong valence;
  void *value;
  long menu;
  char *code;
  struct entree *next;
  char *help;
  void *args;
} entree;

typedef struct PariOUT {
  void (*putch)(char);
  void (*puts)(char*);
  void (*flush)();
  void (*die)();
} PariOUT;

/* Common global variables: */

extern PariOUT *pariOut, *pariErr;
extern FILE    *outfile, *logfile, *infile, *errfile;

extern ulong avma,bot,top,memused;
extern byteptr diffptr;
extern entree  **varentries;
extern char    *errmessage[], current_psfile[128];


/* This may not be exact on all machines [Ptitboul] */
#define is_universal_constant(x) \
  ((long)(x) >= (long)gzero && (long)(x)<=(long)gi)

#define copyifstack(x,y) {long t=(long)(x); y=(t>=bot &&t<top)? lcopy((GEN)t): t;}
#define isonstack(x) (x>=(GEN)bot && x<(GEN)top)

/* Define this to (1) locally (in a given file, NOT here) to check the global
 * "random" garbage collecting
 */
#ifdef DYNAMIC_STACK
#  define low_stack(x,l) (avma < (l))
#else
#  define low_stack(x,l) (avma < (x))
#endif

