# For SunOS
#   If __GNUC__, most level0 functions are "asm inline"
#   If not, they are "asm extern"
#   The object kernel.o contains entries for the functions that can be inline.
#   The object kernel2.o contains entries for the functions that cannot be
#   inline.
#   There is a problem with "divll" that uses "overflow". So kernel2.o is not
#   the same when compiled with gcc or with cc. We should try to find sone
#   workaround.
# For NextStep or Linux
#   We don't accept "asm inline" since it does not work.
#   (Why, I don't know -- Ptitboul)

# Level 1 kernel is the C generic one

kernel="$kernel kernel2"

kernel1=$src/kernel/sparcv8/level0
kernel2=$src/kernel/sparcv8/level0_$asmarch
level0=$src/kernel/sparcv8/level0
case "$osname" in
  nextstep|linux)
cat >> $file << EOT
kernel1.s: $kernel1.s
	\$(CPP) $kernel1.s > kernel1.s
kernel2.s: $kernel2.s
	\$(CPP) $kernel2.s > kernel2.s
EOT
kernel1=kernel1
kernel2=kernel2
level0=$src/kernel/none/asm0
  ;;
esac

cat >> $file << EOT
pariinline.h: $level0.h $src/kernel/none/level1.h
	cat $level0.h $src/kernel/none/level1.h > \$@
kernel.o:  $kernel1.s
	\$(AS) \$(ASFLAGS) -o kernel.o $kernel1.s
kernel2.o:  $kernel2.s
	\$(AS) \$(ASFLAGS) -o kernel2.o $kernel2.s
mp.o: .headers $src/kernel/none/mp.c
	\$(CC) -c \$(CFLAGS) \$(CPPFLAGS) -o mp.o $src/kernel/none/mp.c
mpinline.o: .headers $src/kernel/none/level1.h
	\$(CC) -c \$(CFLAGS) \$(CPPFLAGS) -o mpinline.o $src/kernel/none/level1.c

EOT
