/* Author Mike White, 1996. Based on original WizUnZip code by
 * Robert Heath.
 */
#include <windows.h>    /* required for all Windows applications */
#include <stdio.h>
#include "wiz.h"
#include "unzip\unzip.h"      /* needed only for the function prototypes */
#include "wizver.h"
#include "api.h"

#ifndef WIN32
#define UNZIP_DLL_NAME "UnZip16.dll"
#define DLL_VERSION "(16-bit Version)"
#define ZIP_DLL_NAME "Zip16.dll"
#else
#define UNZIP_DLL_NAME "UnZip32.dll"
#define DLL_VERSION "(32-bit Version)"
#define ZIP_DLL_NAME "Zip32.dll"
#endif

/****************************************************************************

    FUNCTION: About(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/

#ifdef __BORLANDC__
#pragma argsused
#endif
BOOL WINAPI
AboutProc(HWND hwndDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
UzpVer far * pVersionUzp;
ZpVer * pVersionZp;
typedef UzpVer far * (WINAPI * _get_unzip_ver) (void);
typedef ZpVer far * (WINAPI * _get_zip_ver) (void);
char string[80];
_get_unzip_ver GetUnzipVersion;
_get_zip_ver GetZipVersion;

if ((wMessage == WM_CLOSE) ||
    (wMessage == WM_COMMAND && LOWORD(wParam) == IDOK))
        EndDialog(hwndDlg, TRUE);

if (wMessage == WM_INITDIALOG)
   {
#ifndef BETA
   sprintf(string, "%s %s", APPLICATION, DLL_VERSION);
   SetWindowText(hwndDlg, string);
#else
   SetWindowText(hwndDlg, "BETA - Do Not Distribute");
#endif

   sprintf(string, "Info-ZIP's WiZ version %d.%d.%d%s %s",
      WIZ_MAJORVER, WIZ_MINORVER, WIZ_PATCHLEVEL, WIZBETALEVEL,
      WIZ_VERSION_DATE);
   SetDlgItemText(hwndDlg, IDM_ABOUT_VERSION_INFO, string);

   (_get_zip_ver) GetZipVersion = (_get_zip_ver)GetProcAddress(hZipDll, "ZpVersion");
   if (!GetZipVersion)
      {
      lstrcpy(string, "Cannot get ZpVersion address");
      }
   else
      {
      pVersionZp = (*GetZipVersion)();
      sprintf(string, "%s Version %d.%d%d %s",
         ZIP_DLL_NAME,
         pVersionZp->windll.major,
         pVersionZp->windll.minor,
         pVersionZp->windll.patchlevel,
         pVersionZp->betalevel);
      }
   SetDlgItemText(hwndDlg, IDM_ABOUT_ZIP_INFO, string);

   (_get_unzip_ver) GetUnzipVersion = (_get_unzip_ver)GetProcAddress(hUnzipDll, "UzpVersion");
   if (!GetUnzipVersion)
      {
      lstrcpy(string, "Cannot get UzpVersion address");
      }
   else
      {
      pVersionUzp = (*GetUnzipVersion)();
      sprintf(string, "%s Version %d.%d%d %s",
         UNZIP_DLL_NAME,
         pVersionUzp->windll.major,
         pVersionUzp->windll.minor,
         pVersionUzp->windll.patchlevel,
         pVersionUzp->betalevel);
      }
   SetDlgItemText(hwndDlg, IDM_ABOUT_UNZIP_INFO, string);

   CenterDialog(GetParent(hwndDlg), hwndDlg);
   }
return ((wMessage == WM_CLOSE) || (wMessage == WM_INITDIALOG) || (wMessage == WM_COMMAND))
            ? TRUE : FALSE;
}

/*
 *      CenterDialog
 *
 *      Purpose:
 *              Moves the dialog specified by hwndDlg so that it is centered on
 *              the window specified by hwndParent. If hwndParent is null,
 *              hwndDlg gets centered on the screen.
 *
 *              Should be called while processing the WM_INITDIALOG message
 *              from the dialog's DlgProc().
 *
 *      Arguments:
 *              HWND    parent hwnd
 *              HWND    dialog's hwnd
 *
 *      Returns:
 *              Nothing.
 *
 */
void
CenterDialog(HWND hwndParent, HWND hwndDlg)
{
RECT    rectDlg;
RECT    rect;
int             dx;
int             dy;

if (hwndParent == NULL)
   {
   rect.top = rect.left = 0;
   rect.right = GetSystemMetrics(SM_CXSCREEN);
   rect.bottom = GetSystemMetrics(SM_CYSCREEN);
   }
else
   {
   GetWindowRect(hwndParent, &rect);
   }

GetWindowRect(hwndDlg, &rectDlg);
OffsetRect(&rectDlg, -rectDlg.left, -rectDlg.top);

dx = (rect.left + (rect.right - rect.left -
     rectDlg.right) / 2 + 4) & ~7;
dy = rect.top + (rect.bottom - rect.top -
     rectDlg.bottom) / 2;
WinAssert(hwndDlg);
MoveWindow(hwndDlg, dx, dy, rectDlg.right, rectDlg.bottom, 0);
}

