/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "wiz.h"
#include "helpids.h"

/****************************************************************************

    FUNCTION: EditBoxProc(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "Comment Edit Box" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/

LPSTR szCommentBuf;
HANDLE hStr;

#ifdef __BORLANDC__
#pragma warn -par
#pragma warn -aus
#endif
BOOL WINAPI
CommentBoxProc(HWND hwndDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
   switch (wMessage) {
   case WM_INITDIALOG:
      {
      if (szCommentBuf[0] != '\0')
         {
         SendMessage(GetDlgItem(hwndDlg, IDM_EDIT_BOX), WM_SETTEXT, 0, (LPARAM)szCommentBuf);
         }
      CenterDialog(GetParent(hwndDlg), hwndDlg); /* center on parent */
      SetFocus(GetDlgItem(hwndDlg, IDM_EDIT_BOX));
      }
      break;
   case WM_COMMAND:
      switch (LOWORD(wParam)) {
         case IDCANCEL:
            szCommentBuf[0] = '\0';
            EndDialog(hwndDlg, wParam);
            break;
         case ID_HELP:
            WinHelp(hwndDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_ADD_COMMENT));
            break;
         case IDOK:
            {
            DWORD iEBItems;
            /* Get multi-line comment for the zip file */
            SendMessage(GetDlgItem(hwndDlg, IDM_EDIT_BOX), EM_FMTLINES, TRUE, 0L);
            iEBItems = (DWORD) SendMessage(GetDlgItem(hwndDlg, IDM_EDIT_BOX),
               WM_GETTEXTLENGTH, 0, 0L) + 1;
            if (iEBItems)
               {
               if (iEBItems > 65534L)
                  iEBItems = (DWORD) 65534L;
               SendMessage(GetDlgItem(hwndDlg, IDM_EDIT_BOX),
                  WM_GETTEXT, (WPARAM)iEBItems, (LPARAM)szCommentBuf);
               }
            else
               szCommentBuf[0] = '\0';
            EndDialog(hwndDlg, wParam);
            break;
            }
         }
      default:
         break;
   }
   return FALSE;
}
#ifdef __BORLANDC__
#pragma warn .par
#pragma warn .aus
#endif

char far * WINAPI comment(char far *szBuf)
{
#ifndef WIN32
FARPROC lpfnComment;
#endif
hStr = GlobalAlloc( GPTR, (DWORD)32768L);
if ( !hStr )
   {
   szBuf[0] = '\0';
   return szBuf;
   }

szCommentBuf = GlobalLock(hStr);
if (lstrlen(szBuf) != 0)
   {
   lstrcpy(szCommentBuf, szBuf);
   }
else
   {
   szCommentBuf[0] = '\0';
   }
#ifndef WIN32
lpfnComment = MakeProcInstance(CommentBoxProc, hInst);
DialogBox(hInst, "COMMENTBOX", hWndMain, lpfnComment);
FreeProcInstance(lpfnComment);
#else
DialogBox(hInst, "COMMENTBOX", hWndMain, CommentBoxProc);
#endif
if (szCommentBuf[0] != '\0')
   {
   lstrcpy(szBuf, szCommentBuf);
   }
else
   {
   szBuf[0] = '\0';
   }
GlobalUnlock(hStr);
GlobalFree(hStr);
return szBuf;
}

