/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <io.h>
#include <dos.h>
#ifndef __BORLANDC__
#include <direct.h>
#else
#include <dir.h>
#endif
#include <process.h>
#include <commdlg.h>
#include "wiz.h"
/*
 * FindFile - find files matching a pattern files on specified drives
 * parameters:
 *            drives   - An array of drive letters to search.
 *            pattern  - A file name pattern.
 */
void FindFile(char far *drives, char *pattern, HWND hDlg)
{
char tree[] = "Z:";

/* Process all selected drives. Not truly necessary for current usage, but
   retained for potential future use as file finder, grep etc.
 */
while (*drives)
   {
   tree[0] = *drives++;

   if (lstrrchr(pattern, '\\') != NULL)
      {
      char str[80], *p;
      lstrcpy(str, pattern);
      p = lstrrchr(str, '\\');
      str[(int)(p-str)] = '\0';
      p = lstrrchr(pattern, '\\');
      p++;
      lstrcpy(pattern, p);
      DoADir(str, "*.*", pattern, hDlg, tree[0]);
      }
   else
      DoADir(tree, "*.*", pattern, hDlg, tree[0]);
    }
}

/*
 * DoADir - search a directory for files matching a file name pattern
 *          recursivly search sub directories
 * parameters:
 *             patternp  - A path to search.
 *             patternn  - A file name pattern to use to find directories.
 *             include   - A file name pattern to use to select files.
 *             hDlg      - handle to the count dialog window
 *             drive     - Drive letter to search on
 */
void DoADir(char *patternp, char *patternn,
   char *include, HWND hDlg, char drive)
{
char  patternw[PATH_MAX],npatternp[PATH_MAX];
BOOL  have_subs, included_files;
#ifndef WIN32
struct find_t fileinfo;
#else
HANDLE hFoundFile;
WIN32_FIND_DATA fileinfo;
#endif

lstrcpy(patternw, patternp);
if (patternp[lstrlen(patternw)-1] != '\\')
   lstrcat(patternw, "\\");
lstrcat(patternw, patternn);

have_subs = FALSE;
#ifndef WIN32
if (!_dos_findfirst(patternw, _A_SUBDIR, &fileinfo))
#else
if ((hFoundFile = FindFirstFile(patternw, &fileinfo)) != INVALID_HANDLE_VALUE)
#endif
   {
   included_files = FALSE;
   do
      {
#ifndef WIN32
      if (fileinfo.attrib & _A_SUBDIR)  /* subdirectory */
         {
         if (fileinfo.name[0] != '.')   /* ignore . and .. */
            have_subs = TRUE;
         }
       else                             /* file */
         {
         if (FnMatch(include, fileinfo.name))
#else
      if (fileinfo.dwFileAttributes == FILE_ATTRIBUTE_DIRECTORY)  /* subdirectory */
         {
         if (fileinfo.cFileName[0] != '.')  /* ignore . and .. */
            have_subs = TRUE;
         }
       else                                 /* file */
         {
         if (FnMatch(include, fileinfo.cFileName))
#endif
            {
            char buf[PATH_MAX];
            /* If hDlg == NULL, then we got here from the Search
               Archive menu item.
             */
            if ((!included_files) && (hDlg != NULL))
               {
               buf[0] = drive;
               buf[1] = ':';
               buf[2] = '\0';
               lstrcat(buf, patternp);
               if (buf[lstrlen(buf)-1] != '\\')
                  lstrcat(buf, "\\");
               lstrcat(buf, include);
               included_files = TRUE;
               SendMessage(GetDlgItem(hDlg, IDC_FILE_LIST),
                     LB_INSERTSTRING, 0, (LONG) ((LPSTR) buf));
               }
            else if(hDlg == NULL)
               {
               buf[0] = drive;
               buf[1] = ':';
               buf[2] = '\0';
               lstrcat(buf, patternp);
               if (buf[lstrlen(buf)-1] != '\\')
                  lstrcat(buf, "\\");
#ifdef WIN32
               lstrcat(buf, fileinfo.cFileName);
#else
               lstrcat(buf, fileinfo.name);
#endif
               SearchArchive(buf);
               }
            }
         }
#ifndef WIN32
      } while (!_dos_findnext(&fileinfo));
#else
      } while (FindNextFile(hFoundFile, &fileinfo));
   FindClose(hFoundFile);
#endif
   }

if (have_subs)
   {
#ifndef WIN32
   if (!_dos_findfirst(patternw, _A_SUBDIR, &fileinfo))
#else
   if ((hFoundFile = FindFirstFile(patternw, &fileinfo)) != INVALID_HANDLE_VALUE)
#endif
      {
      do
         {
#ifndef WIN32
         if (fileinfo.attrib & _A_SUBDIR)  /* subdirectory */
            {
            if (fileinfo.name[0] != '.')   /* ignore . and .. */
#else
      if (fileinfo.dwFileAttributes == FILE_ATTRIBUTE_DIRECTORY)  /* subdirectory */
            {
            if (fileinfo.cFileName[0] != '.')  /* ignore . and .. */
#endif
               {
               lstrcpy(npatternp, patternp);
               if (patternp[lstrlen(npatternp)-1] != '\\')
                  lstrcat(npatternp, "\\");
#ifndef WIN32
               lstrcat(npatternp, fileinfo.name);
#else
               lstrcat(npatternp, fileinfo.cFileName);
#endif

               DoADir(npatternp, patternn, include, hDlg, drive);
               }
            }
#ifndef WIN32
         } while (!_dos_findnext(&fileinfo));
#else
         } while (FindNextFile(hFoundFile, &fileinfo));
      FindClose(hFoundFile);
#endif
      }
   }
}

/*
 *FnMatch - test if a file name matches a file name pattern.
 *           handles * and ? wildcard characters.
 * parameters:
 *             pat   - A file name pattern (ie. xyz?.*)
 *             name  - A file name to test against pat (ie. xyz1.c)
 * returns:
 *             1 - if name_match
 *             0 - if not a name_match
 */
BOOL FnMatch(char *pat, char *name)
{
BOOL name_match = TRUE, ndone = TRUE;
char *cpp, *cpn;

cpp = pat;
cpn = name;
while (ndone)
   {
   switch (*cpp)
      {
      case '*':
         /* skip to . or end of pat */
         while (*cpp && *cpp != '.')
            cpp++;

         /* skip to . or end of name */
         while (*cpn && *cpn != '.')
            cpn++;
         break;

      case '?':
         cpp++;
         cpn++;
         break;

      case 0:
         if (*cpn != 0)
            name_match = FALSE;
         ndone = FALSE;
         break;

      default:
         if (tolower(*cpp) == tolower(*cpn))
            {
            cpp++;
            cpn++;
            }
         else
            {
            name_match = FALSE;
            ndone = FALSE;
            }
         break;
      }
   }
return(name_match);
}

