/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include "wiz.h"
#include <string.h>
#include <stdio.h>
#ifdef __BORLANDC__
#include <dir.h>
#else
#include <direct.h>
#endif
#include "helpids.h"

// This is the length of a string that is required before a horizontal
// scroll bar shows up, and the basis for computing the horizontal extent
// required for the scroll bar.
#define SCROLLWIDTH 15

int cSelLBItems;
int numFiles;
char **pszIndex;
char *sz;
char baseDir[PATH_MAX], tempName[PATH_MAX];
LPSTR szFileList;
HANDLE hFileList;
char szPattern[PATH_MAX], szLastPat[PATH_MAX];


/****************************************************************************

    FUNCTION: GetFilesProc(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "Get Files For Archive" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#pragma warn -aus
#endif
BOOL WINAPI
GetFilesProc(HWND hwndDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
char szFName[PATH_MAX];
int __far * __far *ppnSelItems;
int i, far *pnSelItems;
DWORD iScrollWidth=0;
HGLOBAL pHND;
HWND hTemp;

   switch (wMessage) {
   case WM_INITDIALOG:
      /* This hides the actual OK button associated with the file open
         dialog. We basically want to disable this button, as pressing
         enter will otherwise cause the OK button to be pressed, and the
         dialog to terminate.
       */
      hTemp = GetDlgItem(hwndDlg, IDOK);
      WinAssert(hTemp);
      EnableWindow(hTemp, FALSE);
      ShowWindow(hTemp, SW_HIDE);

      ZpOpt.szRootDir[0] = '\0';
      lstrcpy(szLastPat, "*.*");
      numFiles = 0;
      ZpZCL.argc = 0;
      SetWindowText(GetDlgItem(hwndDlg, IDC_RECURSE_EDITBOX), "*.*");
      CenterDialog(GetParent(hwndDlg), hwndDlg); /* center on parent */
      break;
   case WM_COMMAND:
      switch (LOWORD(wParam)) {
         case IDC_TEMP_PREFERENCES:
            {
#ifndef WIN32
            FARPROC lpfnPrefs;
            lpfnPrefs = MakeProcInstance((FARPROC)ZipPreferencesProc, hInst);
            DialogBox(hInst, "ZIP_PREFS", hwndDlg, lpfnPrefs);
            FreeProcInstance(lpfnPrefs);
#else
            DialogBox(hInst, "ZIP_PREFS", hwndDlg, (DLGPROC)ZipPreferencesProc);
#endif
            }
            break;
         case IDOK:
            if ((HWND)lParam != NULL)
               {
               GetWindowText(GetDlgItem(hwndDlg, edt1), szLastPat, PATH_MAX);
               break;
               }
         case IDC_ADD:
            {
            cSelLBItems = (int)SendMessage(GetDlgItem(hwndDlg, lst1),
               LB_GETSELCOUNT, 0, 0L);
            if (cSelLBItems == (int)SendMessage(GetDlgItem(hwndDlg, lst1),
               LB_GETCOUNT, 0, 0L))
               {
               getcwd(baseDir, PATH_MAX);
               if (baseDir[lstrlen(baseDir)-1] != '\\')
                  lstrcat(baseDir, "\\");
               lstrcat(baseDir, szLastPat);
               SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                  LB_INSERTSTRING, 0, (LONG) ((LPSTR) baseDir));
               if (lstrlen(baseDir) > (int)iScrollWidth)
                  {
                  iScrollWidth = lstrlen(baseDir);
                  if (iScrollWidth > SCROLLWIDTH)
                     SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                                 LB_SETHORIZONTALEXTENT,
                                 (WPARAM)(dxChar*iScrollWidth),
                                 0);
                  }
               return TRUE;
               }
            if (cSelLBItems)
               {
               pHND = GlobalAlloc(GMEM_FIXED, cSelLBItems * sizeof(int));
               WinAssert(pHND);

               pnSelItems = (int __far *)GlobalLock(pHND);
               ppnSelItems = &pnSelItems;
               if ( !*ppnSelItems )
                  {
                  GlobalFree(pHND);
                  return -1;
                  }

               /* Get list of selected items. Return value is number of
                  selected items */
               if (SendMessage(GetDlgItem(hwndDlg, lst1), LB_GETSELITEMS,
                  cSelLBItems, (LONG)*ppnSelItems) != cSelLBItems)
                  {
                  GlobalUnlock(pHND);
                  GlobalFree(pHND);
                  return -1;
                  }

               getcwd(baseDir, PATH_MAX);
               lstrcat(baseDir, "\\");
               for (i = cSelLBItems - 1; i >= 0; i--)
                  {
                  SendMessage(GetDlgItem(hwndDlg, lst1), LB_GETTEXT,
                     pnSelItems[i],(LPARAM) (LPCSTR) szFName);
                  lstrcpy(tempName, baseDir);
                  lstrcat(tempName, szFName);
                  SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                     LB_INSERTSTRING, 0, (LONG)(LPSTR) tempName);
                  if (lstrlen(tempName) > (int)iScrollWidth)
                     {
                     iScrollWidth = lstrlen(tempName);
                     if (iScrollWidth > SCROLLWIDTH)
                        SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                                    LB_SETHORIZONTALEXTENT,
                                    (WPARAM)(dxChar*iScrollWidth),
                                    0);
                     }
                  numFiles++;
                  }
               GlobalUnlock(pHND);
               GlobalFree(pHND);
               }
            SendMessage(GetDlgItem(hwndDlg, lst1) , LB_SELITEMRANGE,
               (WPARAM)FALSE,
                MAKELONG(0,-1));
            SetWindowText(GetDlgItem(hwndDlg, edt1), szLastPat);
            }
            return TRUE;
         case IDC_DELETE:
            {
            DWORD iNumEntries;
            cSelLBItems = (int)SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
               LB_GETSELCOUNT, 0, 0L);

            if (cSelLBItems)
               {
               pHND = GlobalAlloc(GMEM_FIXED, cSelLBItems * sizeof(int));
               WinAssert(pHND);

               pnSelItems = (int __far *)GlobalLock(pHND);
               ppnSelItems = &pnSelItems;
               if ( !*ppnSelItems )
                  {
                  GlobalFree(pHND);
                  return -1;
                  }

               /* Get list of selected items. */
               if (SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST), LB_GETSELITEMS,
                  cSelLBItems, (LONG)*ppnSelItems) != cSelLBItems)
                  {
                  GlobalUnlock(pHND);
                  GlobalFree(pHND);
                  return -1;
                  }

               for (i = cSelLBItems - 1; i >= 0; i--)
                  {
                  SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST), LB_DELETESTRING,
                     pnSelItems[i],0);
                  numFiles--;
                  }
               GlobalUnlock(pHND);
               GlobalFree(pHND);
               }
            iNumEntries = SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                                      LB_GETCOUNT, 0, 0);
            iScrollWidth = 0;
            if (iNumEntries > 0)
               {
               DWORD i, j;
               for (i = 0; i < iNumEntries; i++)
                   {
                   j = SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                               LB_GETTEXTLEN, (WPARAM)i, 0);
                   if (j > iScrollWidth)
                      {
                      iScrollWidth = j;
                      if (iScrollWidth > SCROLLWIDTH)
                         SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                                     LB_SETHORIZONTALEXTENT,
                                    (WPARAM)(dxChar*iScrollWidth),
                                    0);
                      }
                   }
               }
            else
               {
                SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                            LB_SETHORIZONTALEXTENT,
                            (WPARAM) 0,
                            0);
               }
            }
            break;
         case IDC_SET_ROOT:
            getcwd(ZpOpt.szRootDir, PATH_MAX);
            SetWindowText(GetDlgItem(hwndDlg, IDC_ROOT_DIR), ZpOpt.szRootDir);
            break;
         case IDC_FREE_ROOT:
            ZpOpt.szRootDir[0] = '\0';
            SetWindowText(GetDlgItem(hwndDlg, IDC_ROOT_DIR), ZpOpt.szRootDir);
            break;
         case IDC_INCLUDE:
            /* We don't want to get what is selected in the file box by
               mistake.
             */
            if (SendMessage(GetDlgItem(hwndDlg, lst1),
                  LB_GETSELCOUNT, 0, 0L) > 0)
               break;
            {
            getcwd(baseDir, PATH_MAX);
            lstrcat(baseDir, "\\");
            GetWindowText(GetDlgItem(hwndDlg, edt1), tempName, PATH_MAX);
            lstrcat(baseDir, tempName);
            SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
               LB_INSERTSTRING, 0, (LONG) ((LPSTR) baseDir));
            if (lstrlen(baseDir) > (int)iScrollWidth)
               {
               iScrollWidth = lstrlen(baseDir);
               if (iScrollWidth > SCROLLWIDTH)
                   SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                               LB_SETHORIZONTALEXTENT,
                               (WPARAM)(dxChar*iScrollWidth),
                               0);
               }
            }
            break;
         case IDC_RECURSE:
            /* We don't want to get what is selected in the file box by
               mistake.
             */
            {
            char *p, drive[2];
            DWORD iNumEntries;
            getcwd(baseDir, PATH_MAX);
            lstrcat(baseDir, "\\");
            GetWindowText(GetDlgItem(hwndDlg, edt1), tempName, PATH_MAX);
            lstrcat(baseDir, tempName);
            drive[0] = baseDir[0];
            drive[1] = '\0';
            p = &baseDir[2];
            FindFile(drive, p, hwndDlg);
            iNumEntries = SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                                      LB_GETCOUNT, 0, 0);
            if (iNumEntries > 0)
               {
               DWORD i, j;
               for (i = 0; i < iNumEntries; i++)
                   {
                   j = SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                               LB_GETTEXTLEN, (WPARAM)i, 0);
                   if (j > iScrollWidth)
                      {
                      iScrollWidth = j;
                      if (iScrollWidth > SCROLLWIDTH)
                         SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                                     LB_SETHORIZONTALEXTENT,
                                    (WPARAM)(dxChar*iScrollWidth),
                                    0);
                      }
                   }
               }
            }
            break;
         case IDC_SELECT_ALL:
         case IDC_DESELECT_ALL:
            {
            WORD cZippedFiles;
            cZippedFiles = (WORD)SendMessage(GetDlgItem(hwndDlg, lst1),
               LB_GETCOUNT, 0, 0L);
            SendMessage(GetDlgItem(hwndDlg, lst1) , LB_SELITEMRANGE,
               (WPARAM)(LOWORD(wParam) == IDC_DESELECT_ALL ? FALSE : TRUE),
               MAKELONG(0, (cZippedFiles-1)));
            }
            SetWindowText(GetDlgItem(hwndDlg, edt1), szLastPat);
            break;
         case IDCANCEL:
            ZpZCL.lpszZipFN[0] = '\0';
            lpumb->szZipFileName[0] = '\0';
            break;
         case IDC_DONE:
            {
            int cc;
            char **index;

            SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST) , LB_SELITEMRANGE,
               (WPARAM)TRUE,
                MAKELONG(0, (numFiles-1)));
            cSelLBItems = (int)SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
               LB_GETSELCOUNT, 0, 0L);

            if (cSelLBItems < 1)
               {
               if (!ZpOpt.fRepair)
                  {
                  ZpZCL.lpszZipFN[0] = '\0';
                  lpumb->szZipFileName[0] = '\0';
                  }
               ZpZCL.argc = 0;
               goto pau;
               }

            ZpZCL.argc = cSelLBItems; /* keep count to transfer to dll */

            hFileList = GlobalAlloc( GPTR, FILENAME_BUF_SIZE);
            if ( hFileList )
               {
               szFileList = (char far *)GlobalLock(hFileList);
               }
            else
               {
               MessageBox(hWndMain, "Try archiving fewer files at a time",
                  "Insufficient Memory", MB_OK |MB_SYSTEMMODAL|
                  MB_ICONEXCLAMATION);
               ZpZCL.lpszZipFN[0] = '\0';
               lpumb->szZipFileName[0] = '\0';
               goto pau;
               }

            if (cSelLBItems)
               {
               index = (char **)szFileList;
               cc = (sizeof(char *) * ZpZCL.argc);
               sz = szFileList + cc;

               for (i = 0; i < ZpZCL.argc; i++)
                  {
                  cc = (int)SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST),
                     LB_GETTEXT, i,(LPARAM) (LPCSTR) szFName);
                  lstrcpy(sz, szFName);
                  index[i] = sz;
                  sz += (cc + 1);
                  }
               }
            }
            SendMessage(GetDlgItem(hwndDlg, IDC_FILE_LIST) , LB_SELITEMRANGE,
               (WPARAM)FALSE,
                MAKELONG(0,-1));
            SendMessage(GetDlgItem(hwndDlg, lst1) , LB_SELITEMRANGE,
               (WPARAM)FALSE,
                MAKELONG(0,-1));
pau:
            EndDialog(hwndDlg, TRUE);
            break;
         }
      default:
         break;
   }
   return FALSE;
}
#ifdef __BORLANDC__
#pragma warn .aus
#pragma warn .par
#endif

