/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

 This is not a true grep function, rather it will look for files in an
 archive, based on a particular pattern, including wildcards, and display
 the results in the status/display window.

*/

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include "wiz.h"
#ifdef __BORLANDC__
#include <dir.h>
#else
#include <direct.h>
#endif
#include "helpids.h"

extern char baseDir[PATH_MAX];
char SearchPattern[PATH_MAX];

/****************************************************************************

    FUNCTION: GrepArchiveProc(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "Grep Archive" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/
#ifdef __BORLANDC__
#pragma argsused
#endif
BOOL WINAPI
GrepArchiveProc(HWND hDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
HWND hTemp;
char *p;

switch (wMessage) {
   case WM_INITDIALOG:
      hTemp = GetDlgItem(hDlg, lst1);
      WinAssert(hTemp);
      EnableWindow(hTemp, FALSE);
      ShowWindow(hTemp, SW_HIDE);
      hTemp = GetDlgItem(hDlg, edt1);
      WinAssert(hTemp);
      EnableWindow(hTemp, FALSE);
      ShowWindow(hTemp, SW_HIDE);
      SearchPattern[0] = '\0'; /* Init pattern */

      CenterDialog(GetParent(hDlg), hDlg); /* center on parent */
      break;
   case WM_COMMAND:
      switch (LOWORD(wParam)) {
         case IDOK:
            /* Get the pattern to search for */
            GetWindowText(GetDlgItem(hDlg, IDC_PATTERN), SearchPattern, PATH_MAX);
            for (p = SearchPattern; *p; p++)
                if (*p == '\\')
                    *p = '/';

            /* Get directory to start in */
            getcwd(baseDir, PATH_MAX);
            lstrcat(baseDir, "\\");
            lstrcat(baseDir, "*.zip");
            EndDialog(hDlg, TRUE);
            break;
         case IDCANCEL:
            EndDialog(hDlg, TRUE);
            break;
         }
      default:
         break;
   }
   return FALSE;
}

char ScannedName[PATH_MAX];
BOOL fScanning = FALSE;

void SearchArchive(LPSTR sz)
{
extern char SearchPattern[PATH_MAX];

lpDCL->ncflag = 0;
lpDCL->ntflag = 0;
lpDCL->nvflag = (int)(!uf.fFormatLong ? 1 : 2);
lpDCL->nUflag = 1;
lpDCL->nzflag = 0;
lpDCL->ndflag = 0;
lpDCL->noflag = 0;
lpDCL->naflag = 0;
lpDCL->lpszZipFN = sz;

BufferOut("Searching %s for %s\n", sz, SearchPattern);

fScanning = TRUE;
windll_unzip(0, NULL, lpDCL, lpUserFunctions);
fScanning = FALSE;
}

