/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include "wiz.h"

#include "unzip\zip.h"

#include "password.h"
#include "helpids.h"

int pwflag;
char *prompt;
char *szPassword;
LPSTR lpPasswordStr;

/****************************************************************************

    FUNCTION: PasswordProc(HWND, WORD, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "Password" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/
BOOL WINAPI PasswordProc(HWND hDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
    switch (wMessage)
    {
    case WM_INITDIALOG:
        SetDlgItemText(hDlg, IDM_PASSWORD_INCORRECT, prompt);

        if ((LPSTR)lParam != NULL)
           {
           SetDlgItemText(hDlg, IDM_PASSWORD_TEXT, (LPSTR)lParam);
           }
        SetDlgItemText(hDlg, IDM_NEW_PASSWORD_NAME_TEXT, "");
        CenterDialog(GetParent(hDlg), hDlg); /* center on parent */
        return TRUE;

    case WM_SETFOCUS:
        SetFocus(GetDlgItem(hDlg, IDM_NEW_PASSWORD_NAME_TEXT));
        return TRUE;

    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
        case IDM_PASSWORD_RENAME:
            GetDlgItemText(hDlg, IDM_NEW_PASSWORD_NAME_TEXT, lpPasswordStr, 80);
            pwflag = IZ_PW_ENTERED;
            EndDialog(hDlg, wParam);
            break;
        case IDM_PASSWORD_CANCEL:
            szPassword[0] = '\0';
            pwflag = IZ_PW_CANCELALL;
            EndDialog(hDlg, wParam);
            break;
        case IDM_PASSWORD_HELP:
            WinHelp(hDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_PASSWORD));
            break;
        }
        return TRUE;
    }
    return FALSE;
}

int WINAPI password(char *p, int n, const char *m, const char * name)
{
FARPROC lpProcPassword;

    prompt = (char *)malloc(strlen(m) + 1);
    szPassword = (char *)malloc(n);
    if ((prompt == (char *)NULL) || (szPassword == (char *)NULL)) {
        return IZ_PW_ERROR;
    }
    lpPasswordStr = szPassword;
    pwflag = IZ_PW_ERROR;

    lpProcPassword = MakeProcInstance(PasswordProc, hInst);
    lstrcpy(prompt, m);

    DialogBoxParam(hInst, "Password", hWndMain, lpProcPassword,
       (DWORD)(LPSTR)name);

#ifndef WIN32
    FreeProcInstance(lpProcPassword);
#endif
    lstrcpy(p, szPassword);
    free(szPassword);
    free(prompt);
    return pwflag;
}

