/* Author Mike White, 1996. Based on original WizUnZip code by
 * Robert Heath.
 */
#include <stdio.h>
#include <windows.h>
#include <string.h>
#include "pattern.h"
#include "wiz.h"
#include "helpids.h"


char __based(__segname("STRINGS_TEXT")) szNoMatch[] =
            "No entry matches the pattern!";
/****************************************************************************

    FUNCTION: PatternSelectProc(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "Select Files by Pattern" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL WINAPI
PatternSelectProc(HWND hwndDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
static HWND hSelect, hDeselect, hPattern;
PSTR psLBEntry = NULL;  /* list box entry */
PSTR psPatternBuf = NULL;   /* pattern collection   */
DWORD cListItems;   /* no. items in listbox   */
UINT Fname_Inx;      /* index into LB entry   */
#ifndef WIN32
BOOL fSelect;      /* we're selecting if TRUE */
#endif
int nPatternLength;   /* length of data in pattern edit window */
char *p;

   switch (wMessage) {
   case WM_INITDIALOG:
      hSelect = GetDlgItem(hwndDlg, IDOK);
      hDeselect = GetDlgItem(hwndDlg, IDM_PATTERN_DESELECT);
      hPattern = GetDlgItem(hwndDlg, IDM_PATTERN_PATTERN);
      CenterDialog(GetParent(hwndDlg), hwndDlg);
      return TRUE;
   case WM_COMMAND:
      switch (LOWORD(wParam)) {
        case IDM_PATTERN_PATTERN:
            if (GET_WM_COMMAND_CMD(wParam, lParam) == EN_CHANGE)
               {
               if ((nPatternLength = GetWindowTextLength(hPattern))==1)
                  {
         /* Enable or disable buttons depending on fullness of
          * "Suffix" box.
          */
                  BOOL fButtonState = TRUE ;
                  WinAssert(hSelect);
                  EnableWindow(hSelect, fButtonState);
                  WinAssert(hDeselect);
                  EnableWindow(hDeselect, fButtonState);
                  }
               if (nPatternLength == 0)
                  {
                  BOOL fButtonState = FALSE;
                  WinAssert(hSelect);
                  EnableWindow(hSelect, fButtonState);
                  WinAssert(hDeselect);
                  EnableWindow(hDeselect, fButtonState);
                  }
               }
            break;

      case IDOK: /* Select items using pattern */
      case IDM_PATTERN_DESELECT:
#ifndef WIN32
         fSelect = (BOOL)(LOWORD(wParam) == IDOK);
#endif
         /* Be sure that listbox contains at least 1 item,
          * that a pattern exists (is non-null), and
          * that we can buffer them.
          */
#ifndef WIN32
         if ((cListItems = SendMessage(hWndList, (UINT)LB_GETCOUNT, 0, 0L)) != (UINT)LB_ERR &&
              cListItems >= 1U &&
#else
         if ((cListItems = ListView_GetItemCount(hWndList)) != 0 &&
#endif
            (nPatternLength = GetWindowTextLength(hPattern)) >= 1 &&
            (psPatternBuf =   /* get a buffer   for the file name               */
              (PSTR)GlobalAlloc(GMEM_FIXED, nPatternLength+1)) != NULL &&
           (psLBEntry =   /* get a buffer   for the file name               */
              (PSTR)GlobalAlloc(GMEM_FIXED, PATH_MAX+LONG_FORM_FNAME_INX)) != NULL &&
            GetWindowText(hPattern, psPatternBuf, nPatternLength+1) > 0)
         {
         DWORD cItemsSelected = 0; /* no. "hits" during pattern search   */
         UINT uLBInx;
         LPSTR psPattern;   /* points to any one pattern in buffer      */
         static char DELIMS[] = " \t,"; /* delimiters, mostly whitespace */

#ifndef __BORLANDC__
            _strlwr(psPatternBuf);   /* convert pattern to lower case   */
#else
            strlwr(psPatternBuf);   /* convert pattern to lower case   */
#endif
            for (p = psPatternBuf; *p; p++)
                if (*p == '\\')
                    *p = '/';
#ifndef WIN32
            Fname_Inx = (UINT)(uf.fFormatLong ? LONG_FORM_FNAME_INX : SHORT_FORM_FNAME_INX);
#else
            Fname_Inx = 1;
#endif
            /* march through list of patterns in edit field            */
#if (defined MSC) && (!defined WIN32)
            for (psPattern = _fstrtok(psPatternBuf, DELIMS);
                psPattern != NULL; psPattern = _fstrtok(NULL, DELIMS))
#else
            for (psPattern = (PSTR)strtok(psPatternBuf, DELIMS);
                psPattern != NULL; psPattern = (PSTR)strtok(NULL, DELIMS))
#endif
            {

               /* March thru listbox matching the complete path with every entry.
                * Note: unzip's match() function probably won't work for national
                * characters above the ASCII range.
                */
               for (uLBInx = 0; uLBInx < cListItems; uLBInx++)
               {
                  /* Retrieve listbox entry                        */
#ifndef WIN32
                   if (SendMessage(hWndList, LB_GETTEXT, uLBInx, (LPARAM)((LPSTR)psLBEntry)) >
                     (LRESULT)Fname_Inx)
#else
                   ListView_GetItemText(hWndList, uLBInx, 0, psLBEntry, PATH_MAX);
#endif
                  {
#ifndef __BORLANDC__
                     _strlwr(&psLBEntry[Fname_Inx]); /* convert filename to lower case */
#else
                     strlwr(&psLBEntry[Fname_Inx]); /* convert filename to lower case */
#endif
                     /* Use UnZip's match() function                  */
                     if (match(&psLBEntry[Fname_Inx], psPattern, TRUE))
                     {
#ifndef WIN32
                        SendMessage(hWndList, LB_SETSEL, (WPARAM)fSelect,
                                 MAKELPARAM(uLBInx,0));
#else
                        ListViewSetSel(uLBInx, TRUE);
#endif
                        cItemsSelected++;
                     }
                  }
               }
            }
            if (!cItemsSelected)   /* If no pattern match               */
            {
               MessageBox(hwndDlg, szNoMatch, szAppName, MB_OK | MB_ICONASTERISK);
            }
            else /* one or more items were selected */
            {
               UpdateButtons(); /* turn main push buttons on or off */
            }
         }
         if (psLBEntry)
            GlobalFree((HGLOBAL)psLBEntry);

         if (psPatternBuf)
            GlobalFree((HGLOBAL)psPatternBuf);
         break;
      case IDCANCEL:
         PostMessage(hwndDlg, WM_CLOSE, 0, 0L);
         break;
      case IDM_PATTERN_HELP:
            WinHelp(hwndDlg,szHelpFileName,HELP_CONTEXT, (DWORD)(HELPID_SELECT_BY_PATTERN));
         break;
      }
      return TRUE;
   case WM_CLOSE:
      DestroyWindow(hwndDlg);
      hPatternSelectDlg = 0; /* flag dialog inactive   */
      return TRUE;
   }
   return FALSE;
}
#ifdef __BORLANDC__
#pragma warn .par
#endif

