/* sizewndw.c module of WiZ.
 * Author: Robert A. Heath
 * I, Robert Heath, place this source code module in the public domain.
 *
 * Modifications Mike White 1995, 1996
 */
#include <stdio.h>
#include "wiz.h"

/* Call this when the window size changes or needs to change. */
void SizeWindow(void)
{
static WORD wOriWidth =1;
WORD wClientWidth;       /* width of hWndMain client area  */
RECT rectT;
static BOOL doneOnce = FALSE;

/* Set up to do button sizing */
BtnMult = (float)BTNWIDTH; /* Reset multiplier to original setting */
BtnSeparator = 1;          /* Set distance between buttons back to 1 */
Width = (int)(BtnMult*dxChar);

WinAssert(hWndMain);
if (!doneOnce)
   {
   MoveWindow(hWndMain,
         MainRc.left,
         MainRc.top,
         MainRc.right,
         MainRc.bottom,
         FALSE);
   }
GetClientRect(hWndMain, &rectT);
wClientWidth = (WORD)(rectT.right-rectT.left+1);  /* x size of client area */
#ifdef RESIZE_BUTTONS
if (((Width * NumOfBtns) + NumOfBtns) > rectT.right)
   {
   /* Okay, we've got to reduce the button sizes to get them to fit on the
    * screen.
    */
   while (BtnMult > MIN_BTN_WIDTH)
      {
      BtnMult = (float)(BtnMult - 0.1);
      Width = (int)(BtnMult*dxChar);
      if (((Width * NumOfBtns) + NumOfBtns) < rectT.right)
         break;
      }
   if (((Width * NumOfBtns) + NumOfBtns) > rectT.right)
      BtnSeparator = 0;
   }
#endif
if (wClientWidth != wOriWidth)
   {
   wOriWidth = wClientWidth;
   WinAssert(hWndButtonBar);
   MoveWindow(hWndButtonBar,
            0, 1,
            wClientWidth,2 * dyChar,
            TRUE);
   MoveButtons();
   }

/*
 * Position the archive display listbox.
 */
WinAssert(hWndList);
GetClientRect(hWndMain, &rectT);
#ifndef WIN32
rectT.bottom = rectT.bottom - (2 * GetSystemMetrics(SM_CYDLGFRAME)) -
   (5 * dyChar); /* This 5 * dyChar is to allow for the two lines we're
                  * being dropped down for the button row, two lines for
                  * the actual "trailers", and one additional line so the
                  * totals line doesn't show up on the very edge of the
                  * main window.
                  */
MoveWindow(hWndList,
   0, (3 * dyChar), /* drop listbox two lines down for buttons, and one for */
   rectT.right,     /* headings */
   rectT.bottom,
   TRUE);
#else
rectT.bottom = rectT.bottom - (2 * dyChar);
                  /* This 2 * dyChar is to allow for the two lines we're
                  * being dropped down for the button row
                  */
MoveWindow(hWndList,
   0, (2 * dyChar), /* drop listbox two lines down for buttons */
   rectT.right,
   rectT.bottom,
   TRUE);
#endif

    /* Position the status (Message) window.
     * The Message windows is positioned relative to the bottom
     * of the main window initially, then never repositioned again.
     */
if (!doneOnce)
   {
   int top;
   HMENU hSysMenu;
   /* Make the Edit/Status Window 1/3 the size of the client area of
    * hWndMain.
    */
   GetWindowRect(hWndMain, &rectT);
   top = rectT.bottom;
   rectT.bottom = (rectT.bottom - rectT.top)/3;
   rectT.top = top;
   rectT.right = rectT.right - rectT.left;

   WinAssert(hWndStatic);
   MoveWindow(hWndStatic,
            rectT.left, rectT.top,
            rectT.right, rectT.bottom,
            FALSE);
   GetClientRect(hWndStatic, &rectT);
   MoveWindow(hWndEdit,
            rectT.left, rectT.top,
            rectT.right, rectT.bottom,
            FALSE);
   /* Limit user actions on window */
   hSysMenu = GetSystemMenu(hWndStatic, FALSE);
   DeleteMenu(hSysMenu, SC_CLOSE, MF_BYCOMMAND);
   DeleteMenu(hSysMenu, SC_TASKLIST, MF_BYCOMMAND);
   /* walk thru menu and delete all separator bars */
   for (top = GetMenuItemCount(hSysMenu); top; top--)
       if (GetMenuState(hSysMenu, top-1, MF_BYPOSITION) & MF_SEPARATOR)
          DeleteMenu(hSysMenu, top-1, MF_BYPOSITION);
   ShowWindow(hWndStatic, SW_HIDE);
   ShowWindow(hWndEdit, SW_HIDE);
   doneOnce = TRUE;
   }
}

