/* Author Mike White, 1996. Based on original WizUnZip code by
 * Robert Heath.
 */
#include <stdio.h>
#include "wiz.h"

long extern WINAPI StaticWndProc(HWND hWnd, WORD wMessage, WPARAM wParam, LPARAM lParam);
long extern WINAPI WiZMainWndProc(HWND, WORD, WPARAM, LPARAM);

/****************************************************************************

    FUNCTION: WiZInit(HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

        Sets up a structures to register the window class.  Structure includes
        such information as what function will process messages, what cursor
        and icon to use, etc.

****************************************************************************/
BOOL WiZInit(HANDLE hInstance)
{
    WNDCLASS wndclass;

    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc = (LRESULT (WINAPI*)(HWND,unsigned ,
                            WPARAM,LPARAM)) WiZMainWndProc;
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon(hInstance, "zipped");
    wndclass.hCursor = (HCURSOR)LoadCursor((HINSTANCE)NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH)COLOR_BACKGROUND; /* set background color */
    wndclass.lpszMenuName = (LPSTR) "WiZ";
    wndclass.lpszClassName = (LPSTR) szAppName;
    wndclass.cbClsExtra     = 0;
    wndclass.cbWndExtra     = 0;

    if ( !RegisterClass(&wndclass) )
       {
        return FALSE;
       }

    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc = (LRESULT (WINAPI*)(HWND,unsigned ,
       WPARAM,LPARAM)) StaticWndProc;
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon(hInstance, "infozip");
    wndclass.hCursor = LoadCursor((HINSTANCE)NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH)COLOR_WINDOW; /* set background color */
    wndclass.lpszMenuName = (LPSTR) "editmenu";
    wndclass.lpszClassName = (LPSTR) "StaticClass";
    wndclass.cbClsExtra     = 0;
    wndclass.cbWndExtra     = 0;

    if ( !RegisterClass(&wndclass) )
       {
        return FALSE;
       }

   wndclass.style         = (UINT) NULL;
   wndclass.lpfnWndProc   = (WNDPROC) ButtonBarWndProc;
   wndclass.cbClsExtra    = 0;
   wndclass.cbWndExtra    = 0;
   wndclass.hInstance     = hInstance;
   wndclass.hIcon         = (HICON)NULL;
   wndclass.hCursor       = (HCURSOR)NULL;
   wndclass.hbrBackground = (HBRUSH) COLOR_WINDOW;
   wndclass.lpszMenuName  = NULL;
   wndclass.lpszClassName = "ButtonBar";
   if( !RegisterClass(&wndclass))
      {
      return( FALSE );
      }

    return TRUE;
}


