/****************************************************************************

    PURPOSE:  Windows Info-ZIP
    FUNCTIONS:

        WinMain() - calls initialization function, processes message loop
        WiZInit() - initializes window data and registers window
        WiZMainWndProc() - processes messages
        About() - processes messages for "About" dialog box

    AUTHOR: Robert A. Heath,  157 Chartwell Rd. Columbia, SC 29210
    I place this source module, WizUnZip.c, in the public domain.  Use it as
    you will.

    Modifications: M. White - 1995, 1996
      - Ported to Borland C
      - Ported to WinNT and Win95
      - Added dll functionality
      - Added zip functionality
      - renamed to wizmain.c
      - extensively modified for WiZ
****************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <string.h>
#include "wiz.h"
#include "wizver.h"
#ifdef WIN32
#include <winver.h>
#else
#include <ver.h>
#endif

#ifdef WIN32
#define UNZ_DLL_NAME "UNZIP32.DLL\0"
#define ZIP_DLL_NAME "ZIP32.DLL\0"
#else
#define UNZ_DLL_NAME "UNZIP16.DLL\0"
#define ZIP_DLL_NAME "ZIP16.DLL\0"

#  ifndef TEXT
#    define TEXT(x) x
#  endif
#endif

static char __based(__segname("STRINGS_TEXT")) szFirstUse[] = "FirstUse"; /* first use keyword in WiZ.INI */
char __based(__segname("STRINGS_TEXT")) szDefaultUnzipToDir[] = "DefaultUnzipToDir";
char __based(__segname("STRINGS_TEXT")) szDefaultUnzipFromDir[] = "DefaultUnzipFromDir";
char __based(__segname("STRINGS_TEXT")) szLBSelectionKey[] = "LBSelection"; /* LBSelection keyword in WiZ.INI */
char __based(__segname("STRINGS_TEXT")) szHideStatus[] = "HideStatusWindow";
char __based(__segname("STRINGS_TEXT")) szWiZIniFile[] = "WIZ.INI";
char __based(__segname("STRINGS_TEXT")) szZipOptionKey[] = "ZipOptions";
char __based(__segname("STRINGS_TEXT")) szZipToDirKey[] = "ZipToDir";

/* File and Path Name variables */
char __based(__segname("STRINGS_TEXT")) szAppName[] = "WiZ";       /* application title        */
char __based(__segname("STRINGS_TEXT")) szStatusClass[] = "MsgWndw";/* status window class  */
char __based(__segname("STRINGS_TEXT")) szUnzipToDirName[PATH_MAX];    /* extraction ("windll_unzip to") directory name in ANSI */

/* Note that szHelpFileName will be expanded to a fully qualified path
   and file name when we go search for the help file.
 */
#ifdef WIN32
char szHelpFileName[PATH_MAX] = "WIZ32.HLP";
#else
char szHelpFileName[PATH_MAX] = "WIZ16.HLP";
#endif

#define DLL_WARNING "Cannot find %s."\
            " The Dll must be in the application directory, the path, "\
            "the Windows directory or the Windows System directory."
#define DLL_VERSION_WARNING "%s has the wrong version number."\
            " Insure that you have the correct dll's installed, and that "\
            "an older dll is not in your path or Windows System directory."

#ifdef WIN32
extern HWND hSplashScreen;
void ShowSplashScreen(HWND);
#endif
HANDLE hInst;               /* current instance */
HMENU  hMenu;               /* main menu handle */
HANDLE hAccTable;

HANDLE hHourGlass;          /* handle to hourglass cursor */
HANDLE hSaveCursor;         /* current cursor handle */
HANDLE hHelpCursor;         /* help cursor */
HANDLE hFixedFont;          /* handle to fixed font */
HANDLE hOldFont;            /* handle to old font */

int hFile;              /* file handle */
HWND hWndMain;          /* the main window handle. */
HWND hWndList;          /* list box handle */
HWND hWndEdit;        /* status   (a.k.a. Messages) window */
HWND hWndStatic;
HWND hExtract;          /* extract button */
HWND hDisplay;          /*display button */
HWND hTest;             /* test button */
HWND hZipInfo;          /* Zip Info button */
HWND hShowComment;      /* show comment button */
HWND hHelp;   /* help button */
HWND hOpen;   /* open button */
HWND hArchive; /* create archive button */
HWND hDeleteArchive; /* delete button */
HWND hCopyArchive;   /* copy archive button */
HWND hMoveArchive;   /* move archive button */
HWND hRenameArchive; /* rename archive button */
HWND hExit;
HWND hMakeDir;
HWND hSelectAll;
HWND hDeselectAll;
HWND hSelectPattern;
HWND hClearStatus;
HWND hUnzipToDir;
HWND hStatusButton;
HWND hListBoxButton;
int fLB_Selection;

UF  uf;

WPARAM wLBSelection = IDM_LB_DISPLAY; /* default listbox selection action */

HBRUSH hBrush ;         /* brush for  standard window backgrounds  */
LPUMB lpumb;

LPUSERFUNCTIONS lpUserFunctions;
LPZIPUSERFUNCTIONS lpZipUserFunctions;
HANDLE hUF       = (HANDLE)NULL;
LPDCL lpDCL      = NULL;
HANDLE hZUF      = (HANDLE)NULL;
HANDLE hDCL      = (HANDLE)NULL;
ZCL ZpZCL;
ZPOPT ZpOpt;
#ifdef WIN32
HWND       hRTF;
HANDLE  hRTFLib  = (HANDLE)NULL;
DWORD dwPlatformId = 0xFFFFFFFF;
#endif
HINSTANCE hZipDll;
HINSTANCE hUnzipDll;


HANDLE  hStrings = (HANDLE)NULL;
HANDLE  hEditor = (HANDLE)NULL;

int ofretval;       /* return value from initial open if filename given */

WORD cZippedFiles;      /* total personal records in file   */
WORD cListBoxLines; /* max list box lines showing on screen */
WORD cLinesMessageWin; /* max visible lines on message window  */

/* Forward References */
_DLL_ZIP ZpArchive;
_DLL_UNZIP windll_unzip;
_USER_FUNCTIONS UzInit;
_ZIP_USER_FUNCTIONS ZpInit;
ZIPSETOPTIONS ZpSetOptions;
ZIPGETOPTIONS ZpGetOptions;

void FreeUpMemory(void);
#ifdef WIN32
BOOL IsNT(VOID);
#endif
int WINAPI WinMain(HANDLE, HANDLE, LPSTR, int);
long WINAPI WiZMainWndProc(HWND, WORD, WPARAM, LPARAM);

/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

    COMMENTS:

        This will initialize the window class if it is the first time this
        application is run.  It then creates the window, and processes the
        message loop until a WM_QUIT message is received.  It exits the
        application by returning the value passed by the PostQuitMessage.

****************************************************************************/
#ifdef __BORLANDC__
#  ifdef WIN32
#pragma argsused
#  endif
#endif
int WINAPI WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;         /* current instance             */
HANDLE hPrevInstance;     /* previous instance            */
LPSTR lpCmdLine;          /* command line                 */
int nCmdShow;             /* show-window type (open/icon) */
{
#ifdef WIN32
DWORD second;   /* Used for timing the splash screen */
#endif
DWORD dwVerInfoSize;
DWORD dwVerHnd;
char szFullPath[PATH_MAX];
int i;
#ifdef WIN32
char *ptr;
#else
HFILE hfile;
OFSTRUCT ofs;
#endif
HANDLE  hMem;         /* handle to mem alloc'ed */
BOOL fFirstUse;           /* first use if TRUE         */

#ifndef WIN32
if (!hPrevInstance)       /* Has application been initialized? */
#endif
   if (!WiZInit(hInstance))
      return 0;           /* Exits if unable to initialize     */

#ifdef WIN32
      InitCommonControls();
if (!hRTFLib)
   hRTFLib = LoadLibrary("RICHED32.DLL");

if (!hRTFLib)
    {
    char szErr[255];
    wsprintf(szErr, "LoadLibrary Failed. Error Code %ld", GetLastError());
    MessageBox(NULL, szErr, szAppName, MB_OK );
    return 0;
    }
IsNT(); /* Are we running on NT? */
#endif
hStrings = GlobalAlloc( GPTR, (DWORD)sizeof(UMB));
if ( !hStrings )
   {
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

lpumb = (LPUMB)GlobalLock( hStrings );
if ( !lpumb )
   {
   GlobalFree( hStrings );
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

hDCL = GlobalAlloc( GPTR, (DWORD)sizeof(DCL));
if (!hDCL)
   {
   FreeUpMemory();
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
lpDCL = (LPDCL)GlobalLock(hDCL);
if (!lpDCL)
   {
   FreeUpMemory();
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

hUF = GlobalAlloc( GPTR, (DWORD)sizeof(USERFUNCTIONS));
if (!hUF)
   {
   FreeUpMemory();
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
lpUserFunctions = (LPUSERFUNCTIONS)GlobalLock(hUF);

if (!lpUserFunctions)
   {
   FreeUpMemory();
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

hZUF = GlobalAlloc( GPTR, (DWORD)sizeof(ZIPUSERFUNCTIONS));
if (!hZUF)
   {
   FreeUpMemory();
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
lpZipUserFunctions = (LPZIPUSERFUNCTIONS)GlobalLock(hZUF);

if (!lpZipUserFunctions)
   {
   FreeUpMemory();
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

uf.fCanDragDrop = FALSE;
#ifndef WIN32
if ((hHourGlass = GetModuleHandle("SHELL"))!=0)
   {
   if (GetProcAddress(hHourGlass, "DragAcceptFiles" ))
      uf.fCanDragDrop = TRUE;
   }
#else
uf.fCanDragDrop = TRUE;
#endif

lpZipUserFunctions->print = DisplayBuf;
lpZipUserFunctions->password = password;
lpUserFunctions->password = password;
lpZipUserFunctions->comment = comment;

lpUserFunctions->print = DisplayBuf;
lpUserFunctions->sound = SoundDuring;
lpUserFunctions->replace = GetReplaceDlgRetVal;
lpUserFunctions->SendApplicationMessage = ReceiveDllMessage;

hWndMain = CreateWindow(szAppName,      /* window class     */
        szAppName,                      /* window name      */
        WS_OVERLAPPEDWINDOW,            /* window style     */
        0, 0, 0, 0,
        (HWND)0,                        /* parent handle    */
        (HWND)0,                        /* menu or child ID */
        hInstance,                      /* instance         */
        NULL);                          /* additional info  */

if ( !hWndMain )
   {
   FreeUpMemory();
#ifdef WIN32
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

#ifdef WIN32
ShowSplashScreen(hSplashScreen);
#endif

/* Let's try to find the help file first */
#ifdef WIN32
if (SearchPath(
    NULL,               /* address of search path               */
    szHelpFileName,     /* address of filename                  */
    NULL,               /* address of extension                 */
    PATH_MAX,           /* size, in characters, of buffer       */
    szFullPath,         /* address of buffer for found filename */
    &ptr                /* address of pointer to file component */
   ) != 0)
   {
   lstrcpy(szHelpFileName, szFullPath);
   }
#else
hfile = OpenFile(szHelpFileName,  &ofs, OF_SEARCH);
if (hfile != HFILE_ERROR)
   {
   lstrcpy(szHelpFileName, ofs.szPathName);
   }
#endif

#ifndef WIN32
_lclose(hfile);
#endif

#ifdef WIN32
if (SearchPath(
    NULL,               /* address of search path               */
    UNZ_DLL_NAME,       /* address of filename                  */
    NULL,               /* address of extension                 */
    PATH_MAX,           /* size, in characters, of buffer       */
    szFullPath,         /* address of buffer for found filename */
    &ptr                /* address of pointer to file component */
   ) == 0)
#else
hfile = OpenFile(UNZ_DLL_NAME,  &ofs, OF_SEARCH);
if (hfile == HFILE_ERROR)
#endif
   {
   char str[256];
   wsprintf (str, DLL_WARNING, UNZ_DLL_NAME);
   MessageBox ((HWND)NULL, str, szAppName, MB_ICONHAND | MB_SYSTEMMODAL | MB_OK);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
#ifndef WIN32
else
   lstrcpy(szFullPath, ofs.szPathName);
_lclose(hfile);
#endif

/* First we'll check the windll_unzip dll version information */
dwVerInfoSize =
    GetFileVersionInfoSize(szFullPath, &dwVerHnd);

if (dwVerInfoSize)
   {
   BOOL  fRet, fRetName;
   char str[256];
   LPSTR   lpstrVffInfo; /* Pointer to block to hold info */
   LPSTR lszVer = NULL;
   LPSTR lszVerName = NULL;
   UINT  cchVer = 0;

   /* Get a block big enough to hold the version information */
   hMem          = GlobalAlloc(GMEM_MOVEABLE, dwVerInfoSize);
   lpstrVffInfo  = GlobalLock(hMem);

   /* Get the version information */
   if (GetFileVersionInfo(szFullPath, 0L, dwVerInfoSize, lpstrVffInfo))
      {
      fRet = VerQueryValue(lpstrVffInfo,
               TEXT("\\StringFileInfo\\040904E4\\FileVersion"),
              (LPVOID)&lszVer,
              &cchVer);
      fRetName = VerQueryValue(lpstrVffInfo,
               TEXT("\\StringFileInfo\\040904E4\\CompanyName"),
               (LPVOID)&lszVerName,
               &cchVer);
      if (!fRet || !fRetName ||
         (lstrcmpi(lszVer, UNZ_DLL_VERSION) != 0) ||
         (lstrcmpi(lszVerName, COMPANY_NAME) != 0))
         {
         wsprintf (str, DLL_VERSION_WARNING, UNZ_DLL_NAME);
         MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
         FreeUpMemory();
         GlobalUnlock(hMem);
         GlobalFree(hMem);
#ifdef WIN32
         DestroyWindow(hSplashScreen);
         FreeLibrary(hRTFLib);
#endif
         return 0;
         }
      }
      /* free memory */
   GlobalUnlock(hMem);
   GlobalFree(hMem);
   }
else
   {
   char str[256];
   wsprintf (str, DLL_VERSION_WARNING, UNZ_DLL_NAME);
   MessageBox (hWndMain, str, szAppName, MB_ICONSTOP | MB_OK);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
#ifdef WIN32
if (SearchPath(
    NULL,               /* address of search path               */
    ZIP_DLL_NAME,       /* address of filename                  */
    NULL,               /* address of extension                 */
    PATH_MAX,           /* size, in characters, of buffer       */
    szFullPath,         /* address of buffer for found filename */
    &ptr                /* address of pointer to file component */
   ) == 0)
#else
hfile = OpenFile(ZIP_DLL_NAME,  &ofs, OF_SEARCH);
if (hfile == HFILE_ERROR)
#endif
   {
   char str[256];
   wsprintf (str, DLL_WARNING, ZIP_DLL_NAME);
   MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
#ifndef WIN32
else
   lstrcpy(szFullPath, ofs.szPathName);
_lclose(hfile);
#endif

/* Now we'll check the zip dll version information */
dwVerInfoSize =
    GetFileVersionInfoSize(szFullPath, &dwVerHnd);

if (dwVerInfoSize)
   {
   BOOL  fRet, fRetName;
   char str[256];
   LPSTR   lpstrVffInfo; /* Pointer to block to hold info */
   LPSTR lszVer = NULL;
   LPSTR lszVerName = NULL;
   UINT  cchVer = 0;

   /* Get a block big enough to hold the version information */
   hMem          = GlobalAlloc(GMEM_MOVEABLE, dwVerInfoSize);
   lpstrVffInfo  = GlobalLock(hMem);

   /* Get the version information */
   GetFileVersionInfo(szFullPath, 0L, dwVerInfoSize, lpstrVffInfo);
   fRet = VerQueryValue(lpstrVffInfo,
              TEXT("\\StringFileInfo\\040904E4\\FileVersion"),
               (LPVOID)&lszVer,
               &cchVer);
   fRetName = VerQueryValue(lpstrVffInfo,
               TEXT("\\StringFileInfo\\040904E4\\CompanyName"),
              (LPVOID)&lszVerName,
              &cchVer);
   if (!fRet || !fRetName ||
      (lstrcmpi(lszVer, ZIP_DLL_VERSION) != 0) ||
      (lstrcmpi(lszVerName, COMPANY_NAME) != 0))
      {
      wsprintf (str, DLL_VERSION_WARNING, ZIP_DLL_NAME);
      MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
      FreeUpMemory();
      GlobalUnlock(hMem);
      GlobalFree(hMem);
#ifdef WIN32
      DestroyWindow(hSplashScreen);
      FreeLibrary(hRTFLib);
#endif
      return 0;
      }
   /* free memory */
   GlobalUnlock(hMem);
   GlobalFree(hMem);
   }
else
   {
   char str[256];
   wsprintf (str, DLL_VERSION_WARNING, ZIP_DLL_NAME);
   MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
   FreeUpMemory();
   GlobalUnlock(hMem);
   GlobalFree(hMem);
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
/* Okay, now we know that the dll's exist, and have the proper version
 * information in them. We can go ahead and load them.
 */
hUnzipDll = LoadLibrary(UNZ_DLL_NAME);
#ifndef WIN32
if (hUnzipDll > HINSTANCE_ERROR)
#else
if (hUnzipDll != NULL)
#endif
   {
   (_DLL_UNZIP)windll_unzip = (_DLL_UNZIP)GetProcAddress(hUnzipDll, "windll_unzip");
   if (!windll_unzip)
      {
      char str[256];
      wsprintf (str, "Could not get entry point to %s", UNZ_DLL_NAME);
      MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
      FreeUpMemory();
#ifdef WIN32
      DestroyWindow(hSplashScreen);
      FreeLibrary(hRTFLib);
#endif
      return 0;
      }
   }
else
   {
   char str[256];
   wsprintf (str, "Could not load %s", UNZ_DLL_NAME);
   MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

hZipDll = LoadLibrary(ZIP_DLL_NAME);
#ifndef WIN32
if (hZipDll > HINSTANCE_ERROR)
#else
if (hZipDll != NULL)
#endif
   {
   (_DLL_ZIP)ZpArchive = (_DLL_ZIP)GetProcAddress(hZipDll, "ZpArchive");
   (ZIPSETOPTIONS)ZpSetOptions = (ZIPSETOPTIONS)GetProcAddress(hZipDll, "ZpSetOptions");
   (ZIPGETOPTIONS)ZpGetOptions = (ZIPGETOPTIONS)GetProcAddress(hZipDll, "ZpGetOptions");
   if (!ZpArchive || !ZpSetOptions || !ZpGetOptions)
      {
      char str[256];
      wsprintf (str, "Could not get entry point to %s", ZIP_DLL_NAME);
      MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
      FreeUpMemory();
#ifdef WIN32
      DestroyWindow(hSplashScreen);
      FreeLibrary(hRTFLib);
#endif
      return 0;
      }
   }
else
   {
   char str[256];
   wsprintf (str, "Could not load %s", ZIP_DLL_NAME);
   MessageBox((HWND)NULL, str, szAppName, MB_ICONSTOP | MB_OK);
   FreeLibrary(hUnzipDll);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }

GetPrivateProfileString(szAppName, szFirstUse, "Yes", lpumb->szBuffer, 256, szWiZIniFile);
if ((fFirstUse = !lstrcmpi(lpumb->szBuffer, "Yes"))!=0) /* first time used as WiZ 4.0   */
   {
/* Flag that this is no longer the first time.                              */
   WritePrivateProfileString(szAppName, szFirstUse, "No", szWiZIniFile);
/* After first use, all options come out of WIZ.INI file                  */
   }

InitSoundOptions();               /* initialize sound options         */
wLBSelection = IDM_LB_DISPLAY;      /* assume default is to display     */

hEditor = GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT, (DWORD)EDIT_BUF_SIZE);
if (!hEditor)
   {
   MessageBox((HWND)NULL, "Could not allocate memory", szAppName, MB_ICONSTOP | MB_OK);
   FreeLibrary(hUnzipDll);
   FreeLibrary(hZipDll);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
pszBuffer = (LPSTR)GlobalLock(hEditor);
CreateButtonBar(hWndMain);

(_ZIP_USER_FUNCTIONS)ZpInit = (_ZIP_USER_FUNCTIONS)GetProcAddress(hZipDll, "ZpInit");
if (!ZpInit)
   {
   MessageBox((HWND)NULL, "Cannot get address of ZpInit in Zip dll. Terminating...",
      szAppName, MB_ICONSTOP | MB_OK);
   FreeLibrary(hUnzipDll);
   FreeLibrary(hZipDll);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
if (!ZpInit(lpZipUserFunctions))
   {
   MessageBox((HWND)NULL, "Application functions not set up properly. Terminating...",
      szAppName, MB_ICONSTOP | MB_OK);
   FreeLibrary(hUnzipDll);
   FreeLibrary(hZipDll);
   FreeUpMemory();
#ifdef WIN32
   DestroyWindow(hSplashScreen);
   FreeLibrary(hRTFLib);
#endif
   return 0;
   }
#ifndef WIN32
if (_fstrlen(lpCmdLine))            /* if filename passed on start-up   */
#else
if (strlen(lpCmdLine))            /* if filename passed on start-up   */
#endif
   {
   if ((lstrcmpi(&lpCmdLine[lstrlen(lpCmdLine) - 4],
      ".zip") != 0) &&
      (lstrcmpi(&lpCmdLine[lstrlen(lpCmdLine) - 4],
      ".exe") != 0))
      {
      lstrcat(lpCmdLine, ".zip");
      }
   if (lstrcmpi(&lpCmdLine[lstrlen(lpCmdLine) - 8],
      ".zip.zip") == 0)
      lpCmdLine[lstrlen(lpCmdLine) - 4] = '\0';
   if ((ofretval = OpenFile(lpCmdLine, &lpumb->of, OF_EXIST)) >= 0)
      {
      lstrcpy(lpumb->szFileName, lpumb->of.szPathName); /* save file name */


      /* If valid filename change dir to where it lives */
      GetArchiveDir(lpumb->szDirName); /* get archive dir. in ANSI char set */
      if (uf.fUnzipToZipDir || /* unzipping to same directory as archive */
          szUnzipToDirName[0] == '\0') /* or no default */
          {
          /* take only path portion */
          lstrcpy(szUnzipToDirName, lpumb->szDirName);
          }
      lstrcpy(lpumb->szBuffer, lpumb->szDirName);
      DlgDirList(hWndMain, lpumb->szBuffer, 0, 0, 0); /* go to where archive lives */
      }
   else /* bad file name */
      {
      wsprintf (lpumb->szBuffer, "Cannot open %s", lpCmdLine);
      MessageBox (NULL, lpumb->szBuffer, szAppName, MB_ICONINFORMATION | MB_OK);
      lpumb->szFileName[0] = '\0'; /* pretend filename doesn't exist  */
      lpumb->szDirName[0] = '\0'; /* pretend archive dir. doesn't exist  */
      }
   }

UpdateListBox();
UpdateButtons();
/* Enable/Disable buttons */
WinAssert(hSelectAll);
EnableWindow( hSelectAll, FALSE);
WinAssert(hDeselectAll);
EnableWindow( hDeselectAll, FALSE);
WinAssert(hSelectPattern);
EnableWindow( hSelectPattern, FALSE);

/* Throw up splash screen */
#ifdef WIN32
second = (GetTickCount()/1000) + 5;
while ((GetTickCount()/1000) <= second);
DestroyWindow(hSplashScreen);
#endif
SizeWindow();

WinAssert(hWndMain);
ShowWindow(hWndMain, nCmdShow);
ShowWindow(hWndList, SW_SHOW);
ShowWindow(hWndStatic, SW_SHOW);
ShowWindow(hWndEdit, SW_SHOW);

/* On first use, throw up About box, saying what WiZ is, etc. */
if (fFirstUse)
   {
   PostMessage(hWndMain, WM_COMMAND, IDM_ABOUT, 0L);
   }
hHelpCursor = LoadCursor(hInstance, "HelpCursor");

while ( GetMessage(&lpumb->msg, 0, 0, 0) )
   {
   if (hPatternSelectDlg == 0 || /* Pattern select dialog is non-modal */
      !IsDialogMessage(hPatternSelectDlg, &lpumb->msg))
      {
      /* What we are doing here is to intercept the right mouse button up
         command if it is being sent to Wiz's main window, or any of it's
         child windows - such as the list box or edit box. We then process
         the WM_RBUTTONUP message for either the listbox or the editbox
         as though it were sent to the main window. Another way to do this
         would be to subclass both those windows, but this seems a lot
         easier, with less code involved.

         This would also be much easier if we were only dealing with 32
         bit windows, but we also have to deal with the 16 bit version.
       */
      if ((lpumb->msg.message == WM_RBUTTONUP) &&
         ((lpumb->msg.hwnd == hWndStatic) ||
         (lpumb->msg.hwnd == hWndEdit) ||
         (lpumb->msg.hwnd == hWndList)))
         {
         lpumb->msg.hwnd = hWndMain;
         DispatchMessage(&lpumb->msg);
         }
      else
           if ( !TranslateAccelerator(hWndMain, hAccTable, &lpumb->msg) )
              {
              TranslateMessage(&lpumb->msg);
              DispatchMessage(&lpumb->msg);
              }
      }
   }
/* Don't turn on compiler aliasing or C7 will move */
/* the following assignment after the GlobalFree() */
/* which contains the memory for pumb! */
i = (int)lpumb->msg.wParam;

FreeUpMemory();
FreeLibrary(hZipDll);
FreeLibrary(hUnzipDll);
#ifdef WIN32
FreeLibrary(hRTFLib);
#endif
return i;
}

int WINAPI GetReplaceDlgRetVal(char *filename)
{
FARPROC lpfnprocReplace;
int ReplaceDlgRetVal;   /* replace dialog return value */

ShowCursor(FALSE);      /* turn off cursor */
SetCursor(hSaveCursor); /* restore the cursor */
lpfnprocReplace = MakeProcInstance(ReplaceProc, hInst);
ReplaceDlgRetVal = DialogBoxParam(hInst, "Replace",
   hWndMain, lpfnprocReplace, (DWORD)(LPSTR)filename);
#ifndef WIN32
FreeProcInstance(lpfnprocReplace);
#endif
hSaveCursor = SetCursor(hHourGlass);
ShowCursor(TRUE);
return ReplaceDlgRetVal;
}

void FreeUpMemory(void)
{
if (hStrings)
   {
   GlobalUnlock(hStrings);
   GlobalFree(hStrings);
   }
if (hDCL)
   {
   GlobalUnlock(hDCL);
   GlobalFree(hDCL);
   }
if (hEditor)
   {
   GlobalUnlock(hEditor);
   GlobalFree(hEditor);
   }
if (hUF)
   {
   GlobalUnlock(hUF);
   GlobalFree(hUF);
   }
if (hZUF)
   {
   GlobalUnlock(hZUF);
   GlobalFree(hZUF);
   }
}
#ifdef WIN32
BOOL IsNT(VOID)
{
if(dwPlatformId != 0xFFFFFFFF)
   return dwPlatformId;
else
/* note: GetVersionEx() doesn't exist on WinNT 3.1 */
   {
   if(GetVersion() < 0x80000000)
      {
      (BOOL)dwPlatformId = TRUE;
      }
   else
      {
      (BOOL)dwPlatformId = FALSE;
      }
    }
return dwPlatformId;
}
#endif

