/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include <stdio.h>
#include "wiz.h"
#include "helpids.h"
#ifdef ZE_MEM
#undef ZE_MEM
#define ZE_MEM 4
#endif
#include "ziperr.h"


RECT MainRc;  /* Used solely to remember WiZ window position/size */

int ZipRetCode;
BOOL fSaveZipToDir;
BOOL fSaveUnZipFromDir;

char szFilesToAdd[80];
HWND hGetFilesDlg;

/* Forward references */
void WriteZipOptionsProfile(void);
void ReadZipOptionsProfile(void);

void GetWizOptions()
{
ReadZipOptionsProfile();
}

void ReadZipOptionsProfile()
{
int width, height;
RECT rectT;
HWND hWndDesktop;
char szZipOptions[80];
/* NOTE: ZpOpt.fLevel defaults to 6 unless specified otherwise */
char szZipOptionsDefault[] = "6000000000000000000010100110111001001";
int i=0;
BOOL flag = FALSE;

GetPrivateProfileString(szAppName, szZipOptionKey, szZipOptionsDefault,
   szZipOptions, 80, szWiZIniFile);

if (lstrlen(szZipOptions) != lstrlen(szZipOptionsDefault))
   {
   lstrcpy(szZipOptions, szZipOptionsDefault);
   flag = TRUE;
   }

ZpOpt.fLevel         = szZipOptions[i++];
ZpOpt.fSuffix        = szZipOptions[i++]-'0';
ZpOpt.fEncrypt       = szZipOptions[i++]-'0';
ZpOpt.fSystem        = szZipOptions[i++]-'0';
ZpOpt.fVolume        = szZipOptions[i++]-'0';
ZpOpt.fExtra         = szZipOptions[i++]-'0';
ZpOpt.fNoDirEntries  = szZipOptions[i++]-'0';
ZpOpt.fVerbose       = szZipOptions[i++]-'0';
ZpOpt.fQuiet         = szZipOptions[i++]-'0';
ZpOpt.fCRLF_LF       = szZipOptions[i++]-'0';
ZpOpt.fLF_CRLF       = szZipOptions[i++]-'0';
ZpOpt.fJunkDir       = szZipOptions[i++]-'0';
ZpOpt.fRecurse       = szZipOptions[i++]-'0';
ZpOpt.fGrow          = szZipOptions[i++]-'0';
ZpOpt.fForce         = szZipOptions[i++]-'0';
ZpOpt.fMove          = szZipOptions[i++]-'0';
ZpOpt.fUpdate        = szZipOptions[i++]-'0';
ZpOpt.fFreshen       = szZipOptions[i++]-'0';
ZpOpt.fLatestTime    = szZipOptions[i++]-'0';
ZpOpt.fComment       = szZipOptions[i++]-'0';
fSaveZipToDir      = szZipOptions[i++]-'0';
lpDCL->Overwrite      = szZipOptions[i++]-'0';
lpDCL->PromptToOverwrite = szZipOptions[i++]-'0';
lpDCL->ExtractOnlyNewer = szZipOptions[i++]-'0';
lpDCL->SpaceToUnderscore = szZipOptions[i++]-'0';
uf.fSaveUnZipToDir     = szZipOptions[i++]-'0';
uf.fSaveUnZipFromDir   = szZipOptions[i++]-'0';
uf.fTranslate          = szZipOptions[i++]-'0';
uf.fRecreateDirs       = szZipOptions[i++]-'0';
uf.fFormatLong         = szZipOptions[i++]-'0';
uf.fShowBubbleHelp     = szZipOptions[i++]-'0';
uf.fUnzipToZipDir      = szZipOptions[i++]-'0';
fMakeSFX               = szZipOptions[i++]-'0';
fLB_Selection          = szZipOptions[i++]-'0';
lpDCL->fPrivilege      = szZipOptions[i++]-'0';
ZpOpt.fPrivilege      = szZipOptions[i++]-'0';
fMakeDosSFX            = szZipOptions[i]  -'0';

/* If this is a 16 bit version, or if we are not running on NT, force
   disabling of privilege/acl stuff
 */
#ifdef WIN32
if (!dwPlatformId)
#endif
   {
   lpDCL->fPrivilege = FALSE;
   ZpOpt.fPrivilege = FALSE;
   }
/* Verify that all entries are valid */
if ((ZpOpt.fLevel < '0') || (ZpOpt.fLevel > '9'))
   {
   ZpOpt.fLevel = '6'; /* Set compression level to default */
   flag = TRUE;
   }
if ((ZpOpt.fPrivilege < 0) || (ZpOpt.fPrivilege > 3))
   {
   ZpOpt.fPrivilege = 0; /* Turn off privilege */
   flag = TRUE;
   }
if ((lpDCL->fPrivilege < 0) || (lpDCL->fPrivilege > 3))
   {
   lpDCL->fPrivilege = 0; /* Turn off privilege */
   flag = TRUE;
   }
if ((ZpOpt.fSuffix != 0) && (ZpOpt.fSuffix != 1))
   {
   ZpOpt.fSuffix = 0;
   flag = TRUE;
   }
if ((ZpOpt.fEncrypt!= 0) && (ZpOpt.fEncrypt!= 1))
   {
   ZpOpt.fEncrypt= 0;
   flag = TRUE;
   }
if ((ZpOpt.fSystem!= 0) && (ZpOpt.fSystem!= 1))
   {
   ZpOpt.fSystem= 0;
   flag = TRUE;
   }
if ((ZpOpt.fVolume!= 0) && (ZpOpt.fVolume!= 1))
   {
   ZpOpt.fVolume= 0;
   flag = TRUE;
   }
if ((ZpOpt.fExtra!= 0) && (ZpOpt.fExtra!= 1))
   {
   ZpOpt.fExtra= 0;
   flag = TRUE;
   }
if ((ZpOpt.fNoDirEntries!= 0) && (ZpOpt.fNoDirEntries!= 1))
   {
   ZpOpt.fNoDirEntries= 0;
   flag = TRUE;
   }
if ((ZpOpt.fVerbose!= 0) && (ZpOpt.fVerbose!= 1))
   {
   ZpOpt.fVerbose= 0;
   flag = TRUE;
   }
if ((ZpOpt.fQuiet!= 0) && (ZpOpt.fQuiet!= 1))
   {
   ZpOpt.fQuiet= 0;
   flag = TRUE;
   }
if ((ZpOpt.fCRLF_LF!= 0) && (ZpOpt.fCRLF_LF!= 1))
   {
   ZpOpt.fCRLF_LF= 0;
   flag = TRUE;
   }
if ((ZpOpt.fLF_CRLF!= 0) && (ZpOpt.fLF_CRLF!= 1))
   {
   ZpOpt.fLF_CRLF= 0;
   flag = TRUE;
   }
if ((ZpOpt.fJunkDir!= 0) && (ZpOpt.fJunkDir!= 1))
   {
   ZpOpt.fJunkDir= 0;
   flag = TRUE;
   }
if ((ZpOpt.fRecurse!= 0) && (ZpOpt.fRecurse!= 1))
   {
   ZpOpt.fRecurse= 0;
   flag = TRUE;
   }
if ((ZpOpt.fGrow!= 0) && (ZpOpt.fGrow!= 1))
   {
   ZpOpt.fGrow= 0;
   flag = TRUE;
   }
if ((ZpOpt.fForce!= 0) && (ZpOpt.fForce!= 1))
   {
   ZpOpt.fForce= 0;
   flag = TRUE;
   }
if ((ZpOpt.fMove!= 0) && (ZpOpt.fMove!= 1))
   {
   ZpOpt.fMove= 0;
   flag = TRUE;
   }
if ((ZpOpt.fUpdate!= 0) && (ZpOpt.fUpdate!= 1))
   {
   ZpOpt.fUpdate= 0;
   flag = TRUE;
   }
if ((ZpOpt.fFreshen!= 0) && (ZpOpt.fFreshen!= 1))
   {
   ZpOpt.fFreshen= 0;
   flag = TRUE;
   }
ZpOpt.fJunkSFX = 0;
if ((ZpOpt.fLatestTime != 0) && (ZpOpt.fLatestTime != 1))
   {
   ZpOpt.fLatestTime = 0;
   flag = TRUE;
   }
if ((ZpOpt.fComment != 0) && (ZpOpt.fComment != 1))
   {
   ZpOpt.fComment = 0;
   flag = TRUE;
   }
if ((fSaveZipToDir != 0) && (fSaveZipToDir != 1))
   {
   fSaveZipToDir = 0;
   flag = TRUE;
   }
if ((lpDCL->Overwrite != 0) && (lpDCL->Overwrite != 1))
   {
   lpDCL->Overwrite = 0;
   flag = TRUE;
   }
if ((lpDCL->PromptToOverwrite != 0) && (lpDCL->PromptToOverwrite != 1))
   {
   lpDCL->PromptToOverwrite = 0;
   flag = TRUE;
   }
if ((lpDCL->ExtractOnlyNewer != 0) && (lpDCL->ExtractOnlyNewer != 1))
   {
   lpDCL->ExtractOnlyNewer = 0;
   flag = TRUE;
   }
if ((lpDCL->SpaceToUnderscore != 0) && (lpDCL->SpaceToUnderscore != 1))
   {
   lpDCL->SpaceToUnderscore = 0;
   flag = TRUE;
   }
if ((uf.fSaveUnZipToDir != 0) && (uf.fSaveUnZipToDir != 1))
   {
   uf.fSaveUnZipToDir = 0;
   flag = TRUE;
   }
if ((uf.fSaveUnZipFromDir != 0) && (uf.fSaveUnZipFromDir != 1))
   {
   uf.fSaveUnZipFromDir = 0;
   flag = TRUE;
   }
if ((uf.fTranslate != 0) && (uf.fTranslate != 1))
   {
   uf.fTranslate = 0;
   flag = TRUE;
   }
if ((uf.fRecreateDirs != 0) && (uf.fRecreateDirs != 1))
   {
   uf.fRecreateDirs = 0;
   flag = TRUE;
   }
if ((uf.fFormatLong != 0) && (uf.fFormatLong != 1))
   {
   uf.fFormatLong = 0;
   flag = TRUE;
   }
if ((uf.fShowBubbleHelp != 0) && (uf.fShowBubbleHelp != 1))
   {
   uf.fShowBubbleHelp = 0;
   flag = TRUE;
   }
if ((uf.fUnzipToZipDir != 0) && (uf.fUnzipToZipDir != 1))
   {
   uf.fUnzipToZipDir = 0;
   flag = TRUE;
   }
if ((fMakeSFX != 0) && (fMakeSFX != 1))
   {
   fMakeSFX = 0;
   flag = TRUE;
   }
/* If 16 bit version, then this will always be true */
#ifdef WIN32
if ((fMakeDosSFX != 0) && (fMakeDosSFX != 1))
   {
   fMakeDosSFX = 1;
   flag = TRUE;
   }
#endif
if ((fLB_Selection < 0) || (fLB_Selection > 2))
   {
   fLB_Selection = 1;
   wLBSelection = IDM_LB_DISPLAY; /* default listbox selection action */
   flag = TRUE;
   }
else
   {
   switch (fLB_Selection)
      {
      case 0:
              wLBSelection = IDM_LB_EXTRACT;
              break;
      case 1:
              wLBSelection = IDM_LB_DISPLAY;
              break;
      case 2:
              wLBSelection = IDM_LB_TEST;
              break;
      }
   }

   /* We never want these options to be saved, or restored */
ZpOpt.fDate= FALSE;     /* Date option */
ZpOpt.fOffsets = FALSE; /* Adjust offsets option */
ZpOpt.fRepair = FALSE;  /* Fix archive options */

/* Under WIN32 only long format is supported */
#ifdef WIN32
uf.fFormatLong = TRUE;
#endif

/* All entries have now been validated. */
CheckMenuItem(hMenu, IDM_SHOW_BUBBLE_HELP, MF_BYCOMMAND|
   (WORD)(uf.fShowBubbleHelp ? MF_CHECKED : MF_UNCHECKED));
CheckMenuItem(hMenu, IDM_SHORT, MF_BYCOMMAND|
   (WORD)(uf.fFormatLong ? MF_UNCHECKED : MF_CHECKED));
CheckMenuItem(hMenu, IDM_LONG, MF_BYCOMMAND|
   (WORD)(uf.fFormatLong ? MF_CHECKED : MF_UNCHECKED));
CheckMenuItem(hMenu, IDM_RECR_DIR_STRUCT, MF_BYCOMMAND |
             (uf.fRecreateDirs ? MF_CHECKED : MF_UNCHECKED));

CheckMenuItem(hMenu, IDM_SAVE_UNZIP_TO_DIR, MF_BYCOMMAND |
             (uf.fSaveUnZipToDir ? MF_CHECKED : MF_UNCHECKED));
CheckMenuItem(hMenu, IDM_SAVE_UNZIP_FROM_DIR, MF_BYCOMMAND |
             (uf.fSaveUnZipFromDir ? MF_CHECKED : MF_UNCHECKED));
CheckMenuItem(hMenu, wLBSelection, MF_BYCOMMAND | MF_CHECKED);
CheckMenuItem(hMenu, IDM_UNZIP_TO_ZIP_DIR, MF_BYCOMMAND |
             (uf.fUnzipToZipDir ? MF_CHECKED : MF_UNCHECKED));
EnableMenuItem(hMenu, IDM_CHDIR, MF_BYCOMMAND |
             (uf.fUnzipToZipDir ? MF_GRAYED : MF_ENABLED));
CheckMenuItem(hMenu, IDM_SAVE_ZIP_TO_DIR, MF_BYCOMMAND |
   (fSaveZipToDir ? MF_CHECKED : MF_UNCHECKED));


if (flag) /* Something was wrong with the options string, re-write it */
   WriteZipOptionsProfile();

/* Get default "Zip To" directory */
GetPrivateProfileString(szAppName, szZipToDirKey, "", szTargetZipDir,
   PATH_MAX, szWiZIniFile);
/* Get default "unzip-to" directory */
GetPrivateProfileString(szAppName, szDefaultUnzipToDir, "",
   szUnzipToDirName, PATH_MAX, szWiZIniFile);
/* Get default "unzip-from" directory */
GetPrivateProfileString(szAppName, szDefaultUnzipFromDir, "",
   lpumb->szUnzipFromDirName, PATH_MAX, szWiZIniFile);

/* Set up default values for position and size */
hWndDesktop = GetDesktopWindow();
GetClientRect(hWndDesktop, &rectT);
rectT.top =  2 * dyChar;
/*
 * Adjust for 640 x 480 displays
 */
width = GetSystemMetrics(SM_CXSCREEN);
height = GetSystemMetrics(SM_CYSCREEN);
if ((width == 640) || (height == 480))
   {
   /* If we are on a 640 x 480 display, take up two thirds of the
      real estate top to bottom, and three fourths of the screen
      display left to right.
    */
   rectT.bottom = ((rectT.bottom/3) * 2) +
      (2 * GetSystemMetrics(SM_CYDLGFRAME));
   rectT.right =  ((rectT.right/4) * 3) +
      (4 * GetSystemMetrics(SM_CXFRAME) +
      (2 * GetSystemMetrics(SM_CXVSCROLL)));
   }
else
   {
   /* If we are not on a 640 x 480 display, take up one half of the
      real estate top to bottom, and one half of the screen display
      from left to right.
    */
   rectT.bottom = (rectT.bottom/2) +
      (2 * GetSystemMetrics(SM_CYDLGFRAME));
   rectT.right =  (rectT.right/2) +
      (4 * GetSystemMetrics(SM_CXFRAME) +
      (2 * GetSystemMetrics(SM_CXVSCROLL)));
   }
rectT.left = 0;

MainRc.left =   GetPrivateProfileInt(szAppName, "left",
                                     rectT.left,   szWiZIniFile);
MainRc.right =  GetPrivateProfileInt(szAppName, "right",
                                     rectT.right,  szWiZIniFile);
MainRc.top =    GetPrivateProfileInt(szAppName, "top",
                                     rectT.top,    szWiZIniFile);
MainRc.bottom = GetPrivateProfileInt(szAppName, "bottom",
                                     rectT.bottom, szWiZIniFile);
MoveWindow(hWndMain,
           MainRc.left,
           MainRc.top,
           MainRc.right,
           MainRc.bottom,
           TRUE);
}

/* WriteZipOptionsProfile simply writes the WiZ options out to one string,
   rather than having an entire series of profile strings in the .ini file
*/
void WriteZipOptionsProfile()
{
POINT pt;
char szZipOptions[80];
sprintf(szZipOptions,
   "%c%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u%u",
   ZpOpt.fLevel,
   ZpOpt.fSuffix,
   ZpOpt.fEncrypt,
   ZpOpt.fSystem,
   ZpOpt.fVolume,
   ZpOpt.fExtra,
   ZpOpt.fNoDirEntries,
   ZpOpt.fVerbose,
   ZpOpt.fQuiet,
   ZpOpt.fCRLF_LF,
   ZpOpt.fLF_CRLF,
   ZpOpt.fJunkDir,
   ZpOpt.fRecurse,
   ZpOpt.fGrow,
   ZpOpt.fForce,
   ZpOpt.fMove,
   ZpOpt.fUpdate,
   ZpOpt.fFreshen,
   ZpOpt.fLatestTime,
   ZpOpt.fComment,
   fSaveZipToDir,
   lpDCL->Overwrite,
   lpDCL->PromptToOverwrite,
   lpDCL->ExtractOnlyNewer,
   lpDCL->SpaceToUnderscore,
   uf.fSaveUnZipToDir,
   uf.fSaveUnZipFromDir,
   uf.fTranslate,
   uf.fRecreateDirs,
   uf.fFormatLong,
   uf.fShowBubbleHelp,
   uf.fUnzipToZipDir,
   fMakeSFX,
   fLB_Selection,
   lpDCL->fPrivilege,
   ZpOpt.fPrivilege,
   fMakeDosSFX);


WritePrivateProfileString(szAppName, szZipOptionKey,
   szZipOptions, szWiZIniFile);

if (fSaveZipToDir)
   WritePrivateProfileString(szAppName, szZipToDirKey, szTargetZipDir,
      szWiZIniFile);
else
   WritePrivateProfileString(szAppName, szZipToDirKey, "",
      szWiZIniFile);

GetWindowRect(hWndMain, &MainRc);
pt.x = MainRc.left;
pt.y = MainRc.top;
ScreenToClient(GetDesktopWindow(), &pt);
MainRc.left = pt.x;
MainRc.top = pt.y;

pt.x = MainRc.right;
pt.y = MainRc.bottom;
ScreenToClient(GetDesktopWindow(), &pt);
MainRc.right = pt.x - MainRc.left;
MainRc.bottom = pt.y - MainRc.top;

/* Save off the current window position/size */
WritePrivateProfileString(szAppName, "left",
   itoa(MainRc.left,   szZipOptions, 10),
   szWiZIniFile);
WritePrivateProfileString(szAppName, "right",
   itoa(MainRc.right,  szZipOptions, 10),
   szWiZIniFile);
WritePrivateProfileString(szAppName, "top",
   itoa(MainRc.top,    szZipOptions, 10),
   szWiZIniFile);
WritePrivateProfileString(szAppName, "bottom",
   itoa(MainRc.bottom, szZipOptions, 10),
   szWiZIniFile);
}

#ifdef __BORLANDC__
#pragma warn -par
#endif
void ZipWndProc(HWND hWnd, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
RECT  rClient;
#ifndef WIN32
FARPROC lpfnPrefs;
#endif
switch (LOWORD(wParam))
   {
   case IDM_ZIP_TARGET:
         ZipRetCode = FALSE;
         MakeArchive(hWnd);
         lstrcpy(lpumb->szZipFileName, ZpZCL.lpszZipFN);
         if (ZipRetCode == ZE_OK)
            {
            lstrcpy(lpumb->szFileName, lpumb->szZipFileName);
            UpdateListBox();
            WinAssert(hWndList);
            GetClientRect( hWndList, &rClient );
            OffsetRect( &rClient, 0, dyChar );
            rClient.top = rClient.bottom;
            rClient.bottom = rClient.top + (6*dyChar);
#ifndef WIN32
            SendMessage(hWndList, LB_SETSEL, 1, 0L);
#else
            ListViewSetSel(0, TRUE);
#endif
            UpdateButtons(); /* update state of buttons */
            SetCaption(hWnd);
            InvalidateRect( hWnd, &rClient, TRUE);
            }
         break;
   case IDM_ZIP_PREFERENCES:
         {
#ifndef WIN32
         lpfnPrefs = MakeProcInstance((FARPROC)ZipPreferencesProc, hInst);
         DialogBox(hInst, "ZIP_PREFS", hWnd, lpfnPrefs);
         FreeProcInstance(lpfnPrefs);
#else
         DialogBox(hInst, "ZIP_PREFS", hWnd, (DLGPROC)ZipPreferencesProc);
#endif
         }
         break;
   case IDM_UNZIP_PREFERENCES:
         {
#ifndef WIN32
         lpfnPrefs = MakeProcInstance((FARPROC)UnZipPreferencesProc, hInst);
         DialogBox(hInst, "UNZIP_PREFS", hWnd, lpfnPrefs);
         FreeProcInstance(lpfnPrefs);
#else
         DialogBox(hInst, "UNZIP_PREFS", hWnd, (DLGPROC)UnZipPreferencesProc);
#endif
         }
         break;
   }
return;
}
#ifdef __BORLANDC__
#pragma warn .par
#endif

