//
// File: MKADAPI.C
//   By: Jamey Kirby (jkirby@mkallc.com)
// Date: Jan 28, 1998
//
// Confidential Information.
//
// Limited Distribution to Authorized Persons Only.
//
// Created 1998 and Protected as an Unpublished Work.
// Copyright (c) 1998 Magnuson, Kirby & Associates, LLC.
// All Rights Reserved.
//

#include <stdlib.h>
#include <stdio.h>

#pragma warning (disable : 4115 4201 4214)
#include <windows.h>
#pragma warning (default : 4115 4201 4214)

#include <winioctl.h>
#include <tchar.h>
#include <winerror.h>
#include <assert.h>

#include "mkadapi.h"

// MountDisk()
DWORD MountDisk
(
    ULONG DeviceNumber,
    PUCHAR VolumeName,
    UCHAR DriveLetter,
    PVOID Blob
)
{
    DWORD dwStatus = NO_ERROR;
    HANDLE hDevice;
    ULONG dummy;
    UCHAR buffer[MAX_PATH];
    MKADISK_MOUNT_IOCTL mountIoctl;
    UCHAR driveLetterString[4] = {0};
    UCHAR deviceName[256] = {0};

    sprintf(buffer, "\\\\.\\MKAdisk%d", DeviceNumber);

    // Open the device
    hDevice = CreateFile
    (
        buffer,
        GENERIC_READ | GENERIC_WRITE,
        FILE_SHARE_READ | FILE_SHARE_WRITE,
        NULL,
        OPEN_EXISTING,
        0,
        0
    );

    if (hDevice == INVALID_HANDLE_VALUE)
    {
        dwStatus = GetLastError();
        goto MountDiskExit;
    }

    // Mount the image
    strcpy(mountIoctl.VolumeName, VolumeName);

    if
    (
        DeviceIoControl
        (
            hDevice,
            IOCTL_MKADISK_INSERT,
            &mountIoctl,
            sizeof (mountIoctl),
            NULL,
            0,
            &dummy,
            NULL
        ) == 0
    )
    {
        printf("MKADAPI: Error mounting.\n");
        dwStatus = GetLastError();
        CloseHandle(hDevice);
        goto MountDiskExit;
    }

    sprintf(driveLetterString, "%C:", DriveLetter);
    sprintf(deviceName, "\\Device\\MKAdisk\\Volume%d", DeviceNumber);

    if
    (
        DefineDosDevice
        (
            DDD_RAW_TARGET_PATH,
            driveLetterString,
            deviceName
        ) == FALSE
    )
        printf("MKADAPI: Error defining drive letter.\n");

MountDiskExit:

    return (dwStatus);
}

// DismountDisk()
BOOL DismountDisk
(
    ULONG DeviceNumber,
    UCHAR DriveLetter
)
{
    HANDLE hDevice;
    ULONG dummy;
    UCHAR buffer[MAX_PATH];
    BOOL status = FALSE;
    UCHAR driveLetterString[4] = {0};

    sprintf(buffer, "\\\\.\\MKAdisk%d", DeviceNumber);

    hDevice = CreateFile
    (
        buffer,
        GENERIC_READ | GENERIC_WRITE,
        FILE_SHARE_READ | FILE_SHARE_WRITE,
        NULL,
        OPEN_EXISTING,
        0,
        0
    );

    if (hDevice == INVALID_HANDLE_VALUE)
        goto DismountDiskExit;

    if (MKADiskLockVolume(hDevice))
        if (MKADiskDismountVolume(hDevice))
        {
            status = DeviceIoControl
            (
                hDevice,
                IOCTL_MKADISK_REMOVE,
                NULL,
                0,
                NULL,
                0,
                &dummy,
                NULL
            );

            sprintf(driveLetterString, "%C:", DriveLetter);
    
            if
            (
                DefineDosDevice
                (
                    DDD_REMOVE_DEFINITION,
                    driveLetterString,
                    NULL
                ) == FALSE
            )
                printf("MKADAPI: Error removing drive letter.\n");
        }
        else
            printf("MKADAPI: Error dismounting volume: %s", status);
    else
        printf("MKADAPI: Unable to lock volume.\n");

    CloseHandle(hDevice);

DismountDiskExit:

    return (status);
}

// MKADiskIsDiskDrive(...)
BOOLEAN MKADiskIsMKADiskDrive
(
    ULONG DeviceNumber,
    USHORT DriveLetter
)
{
    BOOLEAN dwStatus = FALSE;
    CHAR dosDeviceName[256] = {0};
    CHAR ubDeviceName[256] = {0};
    CHAR ubDeviceNamePrefix[256];
    DWORD maxNameSize = 256;

    sprintf(ubDeviceNamePrefix, "\\DEVICE\\MKADISK\\VOLUME%d", DeviceNumber);
    sprintf(dosDeviceName, "%C:", DriveLetter);

    if (QueryDosDevice(dosDeviceName, ubDeviceName, maxNameSize) != 0)
    {
        printf("MKADAPI: Checking: %s", ubDeviceName);

        strupr(ubDeviceName);

        if (strstr(ubDeviceName, ubDeviceNamePrefix) != 0)
        {
            printf("; [MKADISK].\n");
            dwStatus = TRUE;
        }
        else
            printf(".\n");
    }
    else
        printf("MKADAPI: Invalid drive.\n");

    return (dwStatus);
}

// MKADiskLockVolume(...)
BOOLEAN MKADiskLockVolume
(
    HANDLE hDisk
)
{
    DWORD byteCount;

    return
    (
        DeviceIoControl
        (
            hDisk,
            FSCTL_LOCK_VOLUME,
            NULL,
            0,
            NULL,
            0,
            &byteCount,
            NULL
        )
    );
}

// MKADiskUnlockVolume(...)
BOOLEAN MKADiskUnlockVolume
(
    HANDLE hDisk
)
{
    DWORD byteCount;

    return
    (
        DeviceIoControl
        (
            hDisk,
            FSCTL_UNLOCK_VOLUME,
            NULL,
            0,
            NULL,
            0,
            &byteCount,
            NULL
        )
    );
}

// MKADiskDismountVolume(...)
BOOLEAN MKADiskDismountVolume
(
    HANDLE hDisk
)
{
    DWORD byteCount;

    return
    (
        DeviceIoControl
        (
            hDisk,
            FSCTL_DISMOUNT_VOLUME,
            NULL,
            0,
            NULL,
            0,
            &byteCount,
            NULL
        )
    );
}

VOID main(int argc, char *argv[])
{
    DWORD status;

    printf("MKADAPI, Mount test utility, (c) 1998 MKA, LLC.\n\n");

    if (argc == 2)
        if (argv[1][1] == 'm')
            if ((status = MountDisk(0,"\\??\\D:\\DISK.DSK", 'Z', NULL)) != 0)
                printf("MKADAPI: Mount error [%x]\n", status);
            else
                printf("MKADAPI: Device mounted.\n");
        else
            if (argv[1][1] == 'u')
            {
                if (MKADiskIsMKADiskDrive(0, 'Z') == TRUE)
                    if (!DismountDisk(0, 'Z'))
                        printf
                        (
                            "MKADAPI: Error [%x] dismounting.\n",
                            status
                        );
            }
            else
                printf("MKADAPI: Invalid argument.\n");
    else
        printf("MKADAPI: Usage: mkadapi -m -u\n");
}

