//
// File: MKADAPI.H
//   By: Jamey Kirby (jkirby@mkallc.com)
// Date: Jan 2, 1998
//
// Confidential Information.
//
// Limited Distribution to Authorized Persons Only.
//
// Created 1998 and Protected as an Unpublished Work.
// Copyright (c) 1998 Magnuson, Kirby & Associates, LLC.
// All Rights Reserved.
//

#ifndef MKADAPI_H
#define MKADAPI_H

// Private IOCTL definitions
#define IOCTL_MKADISK_BASE   FILE_DEVICE_DISK
#define IOCTL_MKADISK_INSERT CTL_CODE(IOCTL_MKADISK_BASE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MKADISK_REMOVE CTL_CODE(IOCTL_MKADISK_BASE, 0x801, METHOD_NEITHER, FILE_ANY_ACCESS)

// File system APIs
#define FSCTL_SHUTDOWN_VOLUME   CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_IS_VOLUME_MOUNTED CTL_CODE(FILE_DEVICE_FILE_SYSTEM,10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_IS_PATHNAME_VALID CTL_CODE(FILE_DEVICE_FILE_SYSTEM,11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_MARK_VOLUME_DIRTY CTL_CODE(FILE_DEVICE_FILE_SYSTEM,12, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Parameter block for ioctl mount requests.
typedef struct _MKADISK_MOUNT_IOCTL
{
    UCHAR VolumeName[256];
    UCHAR Key[256];
}
MKADISK_MOUNT_IOCTL, *PMKADISK_MOUNT_IOCTL;

DWORD MountDisk
(
    ULONG DeviceNumber,
    PUCHAR VolumeName,
    UCHAR DriveLetter,
    PVOID Blob
);

BOOL DismountDisk
(
    ULONG DeviceNumber,
    UCHAR DriveLetter
);

BOOLEAN MKADiskIsMKADiskDrive
(
    ULONG DeviceNumber,
    USHORT DriveLetter
);

BOOLEAN MKADiskLockVolume
(
    HANDLE hDisk
);

BOOLEAN MKADiskUnlockVolume
(
    HANDLE hDisk
);

BOOLEAN MKADiskDismountVolume
(
    HANDLE hDisk
);

#endif

