/*++

Copyright (c) 1994,1995,1996,1997,1998  Digital Equipment Corporation

Module Name:

    linload.c

Abstract:

    Linux bootstrap loader

Author:

    Jim Paradis [DEC]

Environment:


Revision History:


--*/

#include <arc.h>
#include <vendor.h>
#include <errno.h>
/* #include <stdlib.h> */
/* #include <stdio.h> */
#include <string.h>

#define BUFFER_SIZE  (16 * 1024)

#define NO_LOAD_ADDRESS 0xdeadbeef      /* Impossible load address */
char *  Linux_Entry = (CHAR *)NO_LOAD_ADDRESS;

extern void JumpToPal();

ARC_STATUS
LoadFile (
	  PCHAR LoadFile,
	  PVOID LoadAddress
	 )
{
  ARC_STATUS Status;
  ULONG FileId;
  ULONG Count;

  Print("Opening file %s ...\r\n", LoadFile);

  Status = Open (LoadFile, OpenReadOnly, &FileId);

  if (Status != ESUCCESS) {
    Print("? File Open Error, Status = 0x%x.\r\n", Status);
    return Status;
  }

  Print("Loading file at 0x%x ...\r\n\n", LoadAddress);

  do {
    
    Status = Read (FileId, LoadAddress, BUFFER_SIZE, &Count);
    
    if (Status != ESUCCESS) {
      Print("? File I/O Error, Status = 0x%x.\r\n", Status);
      return (Status);
    }

    (ULONG)LoadAddress += Count;

  } while (Count == BUFFER_SIZE);

  Close(FileId);
  
  return ESUCCESS;
}


VOID
WaitForKeypress (
    )
{
    UCHAR Character;
    ULONG Count;

    Print("Press any key to continue");

    while(GetReadStatus(StandardIn) != ESUCCESS);

    Read(StandardIn, &Character, 1, &Count);
    Print("%c2J", ASCII_CSI);
}

VOID
GetMemorySize (
    PULONG MemorySizeInBytes,
    PULONG PageSize
    )
{
    MEMORY_DESCRIPTOR * pMemoryDescriptor;
    EXTENDED_SYSTEM_INFORMATION SystemInfo;
    ULONG HighestPageNumber;
    ULONG Tmp;

#ifdef VERBOSE
    Print("in GetMemorySize\r\n");
    Print("  Args: 0x%x 0x%x\r\n",
	    MemorySizeInBytes,
	    PageSize);
#endif

    // Get the system page size

#ifdef VERBOSE
    Print("Calling ReturnExtendedSystemInformation(0x%x)\r\n",
		&SystemInfo);
#endif
    ReturnExtendedSystemInformation(&SystemInfo);

    *PageSize = SystemInfo.ProcessorPageSize;
#ifdef VERBOSE
    Print("Processor page size = %d\r\n", *PageSize);
#endif

    //
    // Walk the memory desciptors to determine the size of memory
    //
    pMemoryDescriptor = GetMemoryDescriptor(NULL);
    HighestPageNumber = 0;

    while(pMemoryDescriptor != NULL) {
	Tmp = pMemoryDescriptor->BasePage + pMemoryDescriptor->PageCount - 1;

	if (Tmp > HighestPageNumber)
	    HighestPageNumber = Tmp;

	pMemoryDescriptor = GetMemoryDescriptor(pMemoryDescriptor);
    }

    *MemorySizeInBytes = (HighestPageNumber + 1) * (*PageSize);

#ifdef VERBOSE
    Print("MemorySizeInBytes = 0x%x\r\n", *MemorySizeInBytes);
#endif

}



VOID
main (
      int argc,
      char *argv[],
      char *envp[]
     ) 

{
  
  CHAR LoadPath[128];
  CHAR FileName[128];
  PCHAR LoadPartition = argv[4];
  PCHAR SystemPartition = argv[2];
  PCHAR LoadFileName = argv[3];
  PCHAR MiloArgs;
  PVOID Buffer;
  ULONG MemorySizeInBytes;
  ULONG Page_Size;
  int i;
  MEMORY_DESCRIPTOR    *md;
  unsigned int *ip;
  ULONG TestFileId;
  FILE_INFORMATION      fi;
  ARC_STATUS Status;

#ifdef VERBOSE
  Print("Arguments:\r\n");
  for(i = 0; i < argc; i++) {
      Print("%s\r\n", argv[i]);
  }
  WaitForKeypress();
  Print("Environment:\r\n");
  for(i = 0; envp[i]; i++) {
      Print("%s\r\n", envp[i]);
  }
  WaitForKeypress();
#endif

  if (argc != 8) {
    Print("? Incorrect number of command arguments.\r\n");
    WaitForKeypress();
    return;
  }

  strcpy (LoadPath, &SystemPartition[strlen("SystemPartition=")]);

  strcat (LoadPath, &LoadFileName[strlen("OsloadFilename=")]);
  Print ("Linux Loader V1.5\r\n\n");
  Print ("Copyright(c) 1994,1995  Digital Equipment Corporation\r\n\n");
  Print("System Partition is %s\r\n", LoadPartition);
  Print("Load File Name is %s\r\n", LoadFileName);
  Print("Load Path is %s\r\n", LoadPath);
  Print("%s\r\n\n", argv[5]);
#ifdef VERBOSE
  WaitForKeypress();
#endif

  //
  // Fix LoadPath to not have a trailing '\'
  //   
  if (LoadPath[strlen(LoadPath) - 1] == '\\')
    LoadPath[strlen(LoadPath) - 1] = '\0';

  // HACK - If the last character of LoadPath is ")", then we've
  // got a device spec, and we can't deal with that (or, more
  // precisely, ArcGetFileAttributes treat device specs and files
  // exactly the same).  Append a trailing '\milo' to get us to the
  // milo in the root directory on the device.
  if (LoadPath[strlen(LoadPath) - 1] == ')')
    strcat(LoadPath, "\\milo");


  // Check out the file, get its type and size...
  Status = Open (LoadPath, OpenReadOnly, &TestFileId);
  if (Status == EISDIR) {
#ifdef VERBOSE
    Print("%s is a directory:\r\ntrying %s\\milo\r\n", LoadPath, LoadPath);
#endif
    strcat(LoadPath, "\\milo");
  
    Status = Open (LoadPath, OpenReadOnly, &TestFileId);

    if (Status != ESUCCESS) {
      Print("? File Open Error, Status = 0x%x.\r\n", Status);
      WaitForKeypress();
      return;
    }
  }

  GetFileInformation(TestFileId, &fi);

#ifdef VERBOSE
  Print("File information for %s:\r\n", LoadPath);
  Print("    StartingAddress: 0x%x\r\n", fi.StartingAddress);
  Print("    EndingAddress: 0x%x\r\n", fi.EndingAddress);
  Print("    CurrentPosition: 0x%x\r\n", fi.CurrentPosition);
  Print("    Type: %d\r\n", fi.Type);
  Print("    FileNameLength: %d\r\n", fi.FileNameLength);
  Print("    Attributes: 0x%x\r\n", fi.Attributes);
  Print("    FileName: %s\r\n", fi.FileName);
  WaitForKeypress();
#endif

  Close(TestFileId);

  Print("Getting memory size ...\r\n\n");   
  
  GetMemorySize(&MemorySizeInBytes, &Page_Size);

#ifdef FIXED_LINUX_ENTRY
  Linux_Entry = (char *)FIXED_LINUX_ENTRY;
#else
  // Find first free memory descriptor with enough memory to hold
  // the image.

  md = GetMemoryDescriptor(NULL);

  while(md) {
#ifdef VERBOSE
    Print("Memory descriptor: Base @0x%x, Size 0x%x, Type %d\r\n",
	md->BasePage * Page_Size, md->PageCount * Page_Size,
	md->Type);
#endif
    if((md->Type == MemoryFree) && 
	((md->PageCount * Page_Size) >= 
			(fi.EndingAddress.u.LowPart - fi.StartingAddress.u.LowPart))) {
	Linux_Entry = (char *)(md->BasePage * Page_Size);
	break;
    }
    md = GetMemoryDescriptor(md);
  }

  if(Linux_Entry == (char *)NO_LOAD_ADDRESS) {
    Print("No free memory available\r\n");
    WaitForKeypress();
    return;
  }
#endif /* FIXED_LINUX_ENTRY */

  // 
  // Load Debug Monitor Image (with PALcode)
  // Round down the load address to the nearest 1Mb boundary.
  //

  Buffer = (PVOID)(KSEG0 | (ULONG)Linux_Entry);

  strcpy (FileName, LoadPath);
  if (LoadFile (FileName, Buffer) != ESUCCESS) {
      Print("Error loading %s\r\n", FileName);
      WaitForKeypress();
      return;
  }

  //
  // Swap to PAL ...
  //



  Print("...Memory size is 0x%x bytes\r\n\n", MemorySizeInBytes);   
  
  MiloArgs = (PCHAR)(KSEG0 | (0x200000 - 1024));
  Print("Setting up argmuments for Milo @ 0x%X\r\n\n", MiloArgs);   
  strcpy(MiloArgs, "MILO");
  strcat(MiloArgs, argv[5]);
  
  MiloArgs = (PCHAR)(KSEG0 | (0x200000 - 512));
  Print("Setting up memory size for Milo @ 0x%X\r\n\n", MiloArgs);   
  strcpy(MiloArgs, "MILO");
  MiloArgs += 4 ;
  *((unsigned long *)MiloArgs) = MemorySizeInBytes / (1024 * 1024) ;
  
  
  MiloArgs = (PCHAR)(KSEG0 | (0x200000 - 256));
  Print("Setting up memory size for Milo @ 0x%X\r\n\n", MiloArgs);   
  strcpy(MiloArgs, "MILO");
  MiloArgs += 4 ;
  *((unsigned int *)MiloArgs) = (unsigned int)(MemorySizeInBytes/(1024*1024));
  
  
  Print("Swapping to PALcode at 0x%x ...\r\n\n", Linux_Entry);     
#ifdef VERBOSE
  Print("Calling JumpToPal(0x%x)\r\n", Linux_Entry);

  WaitForKeypress();

  Print("Here are the first sixteen longwords of MILO:\r\n");
  ip = (unsigned int *)(KSEG0 | (ULONG)Linux_Entry);
  for(i = 0; i < 16; i++, ip++) {
    if((i % 4) == 0) {
	Print("\r\n");
    }
    Print("%08x  ", *ip);
  }
  Print("\r\n");
#endif

  JumpToPal(Linux_Entry);

  Print("Something went wrong - we're still in LINLOAD\r\n");
  WaitForKeypress();
}
