
/*
 * mhparse.h -- definitions for parsing/building of MIME content
 *           -- (mhparse.c/mhbuildsbr.c)
 *
 * $Id$
 */

#define	NPARTS	50
#define	NTYPES	20
#define	NPARMS	10

/*
 * Abstract types for MIME parsing/building
 */
typedef struct cefile  *CE;
typedef struct CTinfo  *CI;
typedef struct Content *CT;

/*
 * type for Init function (both type and transfer encoding)
 */
typedef int (*InitFunc) (CT);

/*
 * types for various transfer encoding access functions
 */
typedef int (*OpenCEFunc) (CT, char **);
typedef void (*CloseCEFunc) (CT);
typedef unsigned long (*SizeCEFunc) (CT);

/*
 * Structure for storing parsed elements
 * of the Content-Type component.
 */
struct CTinfo {
    char *ci_type;
    char *ci_subtype;
    char *ci_attrs[NPARMS + 2];
    char *ci_values[NPARMS];
    char *ci_comment;		/* RFC-822 comments */
    char *ci_magic;
};

/*
 * Structure for storing information related
 * to Content-Transfer-Encoding handling.
 */
struct cefile {
    char *ce_file;
    FILE *ce_fp;
    int	  ce_unlink;	/* remove file when done? */
};

/*
 * Primary structure for handling Content (Entity)
 */
struct Content {
    char *c_partno;		/* within multipart content          */
    char *c_vrsn;		/* MIME-Version:                     */

    char *c_ctline;		/* Content-Type:                     */
    int	c_type;			/* internal flag for content type    */
    int	c_subtype;		/* internal flag for content subtype */
    struct CTinfo c_ctinfo;	/* parsed elements of Content-Type   */

    void *c_ctparams;		/* content type specific data        */
    struct exbody *c_ctexbody;	/* data for type message/external    */

    char *c_showproc;		/* default, if not in profile        */
    char *c_termproc;		/* for charset madness...            */
    char *c_storeproc;		/* overrides profile entry, if any   */

    InitFunc  c_ctinitfnx;	/* parse content                     */

    char *c_celine;		/* Content-Transfer-Encoding:        */
    int	c_encoding;		/* internal flag for encoding type   */
    CE c_cefile;		/* filled-in by encoding initfnx     */

    OpenCEFunc  c_ceopenfnx;	/* get a stream to decoded contents  */
    CloseCEFunc c_ceclosefnx;	/* release stream                    */
    SizeCEFunc  c_cesizefnx;	/* size of decoded contents          */

    char *c_id;			/* Content-ID:                       */
    char *c_descr;		/* Content-Description:              */
    int	c_digested;		/* Content-MD5:                      */
    unsigned char c_digest[16];	/*   ..                              */
    FILE *c_fp;			/* read contents (stream)            */
    char *c_file;		/* read contents (file)              */
    int	c_unlink;		/* remove file when done?            */
    int	c_umask;		/* associated umask                  */
    long c_begin;		/* where content body starts in file */
    long c_end;			/* where content body ends in file   */
    pid_t c_pid;		/* process doing display             */
    int	c_rfc934;		/* rfc934 compatibility flag         */

    char *c_storage;		/* write contents (file)             */
    char *c_folder;		/* write contents (folder)           */
};

/*
 * Flags for Content-Type (Content->c_type)
 */
#define	CT_UNKNOWN	0x00
#define	CT_APPLICATION	0x01
#define	CT_AUDIO	0x02
#define	CT_IMAGE	0x03
#define	CT_MESSAGE	0x04
#define	CT_MULTIPART	0x05
#define	CT_TEXT		0x06
#define	CT_VIDEO	0x07
#define	CT_EXTENSION	0x08

/*
 * Flags for Content-Transfer-Encoding (Content->c_encoding)
 */
#define	CE_UNKNOWN	0x00
#define	CE_BASE64	0x01
#define	CE_QUOTED	0x02
#define	CE_8BIT		0x03
#define	CE_7BIT		0x04
#define	CE_BINARY	0x05
#define	CE_EXTENSION	0x06
#define	CE_EXTERNAL	0x07	/* for external-body */

/*
 * TEXT content
 */

/* Flags for subtypes of TEXT */
#define	TEXT_UNKNOWN	0x00
#define	TEXT_PLAIN	0x01
#define	TEXT_RICHTEXT	0x02
#define TEXT_ENRICHED	0x03

/* Flags for character sets */
#define	CHARSET_UNKNOWN	    0x00
#define CHARSET_UNSPECIFIED 0x01  /* only needed when building drafts */
#define	CHARSET_USASCII	    0x01
#define	CHARSET_LATIN	    0x02

/* Structure for holding charset information */
struct text {
    int	tx_charset;
};

/*
 * MULTIPART content
 */

/* Flags for subtypes of MULTIPART */
#define	MULTI_UNKNOWN	0x00
#define	MULTI_MIXED	0x01
#define	MULTI_ALTERNATE	0x02
#define	MULTI_DIGEST	0x03
#define	MULTI_PARALLEL	0x04

struct part {
    CT mp_part;			/* Content structure for subpart */
    struct part *mp_next;	/* pointer to next subpart       */
};

struct multipart {
    char *mp_start;
    char *mp_stop;
    struct part *mp_parts;	/* pointer to first subpart */
};

/*
 * MESSAGE content
 */

/* Flags for subtypes of MESSAGE */
#define	MESSAGE_UNKNOWN	 0x00
#define	MESSAGE_RFC822	 0x01
#define	MESSAGE_PARTIAL	 0x02
#define	MESSAGE_EXTERNAL 0x03

/* Structure for message/partial */
struct partial {
    char *pm_partid;
    int	pm_partno;
    int	pm_maxno;
    int	pm_marked;
    int	pm_stored;
};

/* Structure for message/external */
struct exbody {
    CT eb_parent;
    CT eb_content;
    char *eb_partno;
    char *eb_access;
    int	eb_flags;
    char *eb_name;
    char *eb_permission;
    char *eb_site;
    char *eb_dir;
    char *eb_mode;
    unsigned long eb_size;
    char *eb_server;
    char *eb_subject;
    char *eb_body;
};

/*
 * APPLICATION content
 */

/* Flags for subtype of APPLICATION */
#define	APPLICATION_UNKNOWN	0x00
#define	APPLICATION_OCTETS	0x01
#define	APPLICATION_POSTSCRIPT	0x02

