// testarc.cpp

// Copyright (C) 1997  Cliff Johnson                                  //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//   

#include "arc.h"


int main()
{

	Point c(0,0);
	Point p1(10,0);
	Point p2(0,10);

	Arc a(c,p1,p2);

	cout << "arc a = " << a << '\n';

	cout << "radius = " << a.Radius() << " angle = " << a.ArcAngle() << endl;

/* 
	cout << "10 points on a are:\n";

	for(int i=0; i<=10; i++)  cout << a.U( .1 * i ) << '\n';

*/

	p1 = Point(10,-1);
	cout << "p1 = " << p1 << " distance to arc = " << a.Distance(p1) << "\n" << endl;
	p1 = Point(10,1);
	cout << "p1 = " << p1 << " distance to arc = " << a.Distance(p1) << "\n" << endl;
	p1 = Point(-1,10);
	cout << "p1 = " << p1 << " distance to arc = " << a.Distance(p1) << "\n" << endl;
	p1 = Point(-10,-10);
	cout << "p1 = " << p1 << " distance to arc = " << a.Distance(p1) << "\n" << endl;

}
