// testcircle.cpp

// Copyright (C) 1997  Cliff Johnson                                  //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//   


#include "circle.h"



int main()
{

	Point p1(1,1);
	Point p2(5,1);

	Circle c1(p1,p2);

	cout << "circle c1 = " << c1 << '\n';

	cout << "circle c1 radius = " << c1.Radius() << '\n';

	cout << "10 points on c1 are:\n";

	for(float i=0.; i<1; i = i + 1./10.)cout << c1.U(i) << '\n';

	Point p3(1, 20);
	cout << " point at " << p3 << " projected on c1 = " << c1.Project(p3) << '\n';
	cout << " u value at projected point = " << c1.UProject(p3) << '\n';
	cout << " distance = " << distance(c1.Project(p3), p3) << '\n';

	p3 = Point(0,0);
	cout << " point at " << p3 << " projected on c1 = " << c1.Project(p3) << '\n';
	cout << " u value at projected point = " << c1.UProject(p3) << '\n';
	cout << " distance = " << distance(c1.Project(p3), p3) << '\n';
	
	Circle cx = Circle( Point(), 10);
	cout << "\ncx = " << cx << '\n';

	
}
