//testentity.cpp

// Copyright (C) 1997  Cliff Johnson                                  //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//   


#include <point.h>
#include <line.h>
#include <entitylib2d.h>
#include <iostream.h>


int main(int argc, char** argv)
{

	CadLib2D entityLib;

	Point p1(1,1);
	Point p2(5,6);
	Point p3(0,2);
	Point p4(2,0);

	Line l1(p1, p2-p1);
	Line l2(p3, p4-p3);

	Point p5 = entityLib.SolveLineLineIntersection(l1,l2);

	cout << "p5 = " << p5 << '\n';


	return 0;
}
