// testlib.cpp

// Copyright (C) 1997  Cliff Johnson                                  //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//   

#include "point.h"
#include "line.h"
#include "circle.h"
#include "pick.h"
#include "entity_enum.h"
#include "cadlib2d.h"

#include <iostream.h>

void error(int code)
{
	switch(code)
	{
	case LINE_IS_VERTICAL:
		cout << " error: LINE_IS_VERTICAL\n";
		break;
	case ERROR_NORMALIZE_EXPLICIT_FORM:
		cout << " error: ERROR_NORMALIZE_EXPLICIT_FORM\n";
		break;
	case PARALLEL_LINES:
		cout << " error: PARALLEL_LINES\n";
		break;
        case DEGENERATE_LINE:
		cout << " error: DEGENERATE_LINE\n";
		break;
        case SYNTAX_ERROR:
		cout << " error: SYNTAX_ERROR\n";
		break;
	case INVALID_SELECTION_TYPE:
		cout << " error: INVALID_SELECTION_TYPE\n";
		break;
        case POINTS_ARE_EQUAL:
        	cout << " error:  POINTS_ARE_EQUAL\n";
		break;
        case POINT_COINCIDENT_WITH_CIRCLE_CENTER:
        	cout << " error:  POINT_COINCIDENT_WITH_CIRCLE_CENTER\n";
		break;
        case POINT_INSIDE_CIRCLE:
        	cout << " error:  POINT_INSIDE_CIRCLE\n";
		break;
        case SEVERE_DEGENERATE_CONDITION:
        	cout << " error:  SEVERE_DEGENERATE_CONDITION\n";
		break;
        case COINCIDENT_CIRCLE_CENTERS:
        	cout << " error:  COINCIDENT_CIRCLE_CENTERS\n";
		break;
        case CIRCLE_INSIDE_CIRCLE:
        	cout << " error:  CIRCLE_INSIDE_CIRCLE\n";
		break;
        case DEGENERATE_CIRCLE:
        	cout << " error:  DEGENERATE_CIRCLE\n";
		break;
	}
}


int main(int argc, char** argv)
{

	CadLib2D cadLib;

//	Point p1(1,1);
//	Point p2(5,6);
//	Point p3(0,2);
//	Point p4(2,0);

	Line l1(Point(10,4), Point(-1,1));
	Line l2(Point(1,1), Point(1,1));


	cout << "\nTEST: Line vs. Line intersection 1: Simple case\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	Point p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << endl;
	cout << "p = " << p << endl;
	if(cadLib.Error()) error(cadLib.Error());

	l2 = Line(Point(0,0), Point(1,0));

	cout << "\nTEST: Line vs. Line intersection 2: Horizontal line 2\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << "        p = " << p << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	l2 = Line(Point(2,10), Point(-1,1));

	cout << "\nTEST: Line vs. Line intersection 3: Parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << "        p = " << p << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	l2 = Line(Point(2,10), Point(-1,.9998));

	cout << "\nTEST: Line vs. Line intersection 4: Nearly parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << "        p = " << p << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	l2 = Line(Point(2,10), Point(-1,.9999));

	cout << "\nTEST: Line vs. Line intersection 5: Nearly parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << "        p = " << p << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	l1 = Line(Point(2,10.5), Point(0,1));

	cout << "\nTEST: Line vs. Line intersection 6: Vertical line 1\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << "        p = " << p << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	l2 = Line(Point(2,10.5), Point(0,1));

	cout << "\nTEST: Line vs. Line intersection 7: Vertical and Parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << "        p = " << p << '\n';
	if(cadLib.Error()) error(cadLib.Error());
		
	l1 = Line(Point(4,6), Point(2,3));

	cout << "\nTEST: Line vs. Line intersection 7: Vertical line 2\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	p = cadLib.SolveLineLineIntersection(l1,l2);
	cout << "cadLib.Error() = " << cadLib.Error() << "        p = " << p << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	cout << "\nTEST: point projection 1: Point(0,0) to l2 = " << l2.Project(Point()) << '\n';

	l1 = Line(Point(3,3), Point(1,-1));
	cout << "l1 = " << l1 << '\n';
	cout << "\nTEST: point projection 2: Point(0,0) to l1 = " << l1.Project(Point()) << '\n';

	// testing of general line by 2 constraints 

	Circle c1 = Circle(Point() ,5.);
	Circle c2 = Circle(Point() ,5.);
	Point pick1(-1,5);
	Point pick2(1,5);

	cout << "\nTEST: SolveLineTangentCircleCircle 1: coincident circles\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	c2 = Circle(Point(1,0),5.);

	cout << "\nTEST: SolveLineTangentCircleCircle 2: circle center inside circle 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	pick1 = Point(-1,-5);

	cout << "\nTEST: SolveLineTangentCircleCircle 3: circle center inside circle 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	c1 = Circle(Point(2,1),5.);

	cout << "\nTEST: SolveLineTangentCircleCircle 4: circle center inside circle 3\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	c1 = Circle(Point() ,5.);
	c2 = Circle(Point(2,2) ,2.);

	cout << "\nTEST: SolveLineTangentCircleCircle 5: circle inside circle 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	c2 = Circle(Point(2,0),3);
	
	cout << "\nTEST: SolveLineTangentCircleCircle 6: circle inside circle and tangent 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	c2 = Circle(Point(10,10),5);
	pick1 = Point(0,5);
	pick2 = Point(7,13);
	
	cout << "\nTEST: SolveLineTangentCircleCircle 7: general solution 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());
	
	pick2 = Point(13,7);
	
	cout << "\nTEST: SolveLineTangentCircleCircle 8: general solution 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	pick1 = Point(5,-5);
	
	cout << "\nTEST: SolveLineTangentCircleCircle 9: general solution 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	pick2 = Point(6,10);
	
	cout << "\nTEST: SolveLineTangentCircleCircle 10: general solution 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());


	Point px1(-14.2105,1.05263);
	Point px2(56.3158, 9.47368 );
	Point px3(66.0526, 3.94737);
	Point px4(-14.7368, -9.21053);

	Circle cx1(px1,px4);
	Circle cx2(px2,px3);

	pick1=Point(-10,-8.94737);
	pick2=Point( 53.6842, 20.7895);

	cout << "\nTEST: SolveLineTangentCircleCircle 11:\n";
	cout << "cx1 = " << cx1 << '\n';
	cout << "cx2 = " << cx2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	l1 = cadLib.SolveLineTangentCircleCircle(cx1,cx2,pick1,pick2);	
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());


	cout << "\nTEST: cadLib.LineConstraints2D(CIRCLE,CIRCLE)\n";
	Pick pk1(&c1,pick1);
	Pick pk2(&c2,pick2);
	cout << "pk1 = " << pk1 << '\n';
	cout << "pk2 = " << pk2 << '\n';
	l1 = cadLib.LineConstraints2D(pk1,pk2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());

	cout << "\nTEST: cadLib.LineConstraints2D(POINT,POINT)\n";
	pk1 = Pick(&pick1, pick1);
	pk2 = Pick(&pick2, pick2);
	cout << "pk1 = " << pk1 << '\n';
	cout << "pk2 = " << pk2 << '\n';
	l1 = cadLib.LineConstraints2D(pk1,pk2);
	cout << "cadLib.Error() = " << cadLib.Error() << "      l = " << l1 << '\n';
	if(cadLib.Error()) error(cadLib.Error());
	






	return 0;
}
