// arc.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef ARC_H
#define ARC_H

#include "entity.h"	// ISA
#include "point.h"	// HASA
#include <iostream.h>	// ITO

class Circle;
class EntityException;

class Arc: public Entity
{

private:
	Point center;
	Point origin;
	Point endpoint;
	double arcAngle;		// subtended angle

public:

// constructors
	Arc();
	Arc(const Point& c, const Point& o, const Point& e) throw (EntityException);	// center and arc origin

	virtual ~Arc() {}

// evaluation functions
	Point Center() const { return center; }
	Point Origin() const { return origin; }
	Point Endpoint() const { return endpoint; }
	Point U(double u) const;
	double Radius() const;
	double ArcAngle() const { return arcAngle; }
	Circle Support() const; 
	
	friend ostream& operator<<(ostream& os, const Arc& c);

	virtual double Distance(const Point&) const;

	Point Project(const Point&) const throw (EntityException);
	double UProject(const Point&) const throw (EntityException);
};


#endif
