//cadlib2d.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//
//	FreeEngineer 2D Drafting Library Functions cadlib2d 
//
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef CADLIB2D_H
#define CADLIB2D_H

class Pick;
class Point;
class Line;
class Circle;
class Segment;
class Arc;
class EntityException;


// These here functions all take the generic "Pick" as parameters... 
// This doesn't mean that all these functions take any thing at all that
// may be in the Pick. Functions will throw EntityExceptions on unhandled input. 

// all purpose function for getting midpoint, endpoint, and center of entities.
// see enum's for permissible integer parameters
	Point CadLib2D_PointByModifier(const Pick& pk1,int) 
		throw(EntityException); 
	
// intersection of point/line/circles/arc/segment combinations
	Point CadLib2D_PointByConstraints(const Pick& pk1, const Pick& pk2) 
		throw (EntityException);

//Line LineParallel(const Line& l, double d);
	Line CadLib2D_LineParallel(const Line& l, const Pick& pk) 
		throw (EntityException);
	
// Line constrained by two selections
	Line CadLib2D_LineByConstraints(const Pick& pk1, const Pick& pk2)  
		throw (EntityException);

//Line Orthoginal(const Pick& pk1 , const Pick& pk2 ); // Constraint, Subject
//
// circle with a given center and tangent/passing 1 selection
	Circle CadLib2D_CircleCenter(const Pick& pk1, const Pick& pk2) 
		throw (EntityException);

	Circle CadLib2D_CircleRadiusAndConstraints(double r, const Pick& pk1, const Pick& pk2) 
		throw (EntityException);
		
//Circle CircleParallel(const Pick& c, double d);
//Circle CircleParallel(const Pick& c, const Pick& t); // parallel to c,  tangent to t
//Circle CircleConstraint(const Pick&, const Pick&, const Pick&);


// these functions are for solving specific problems
// they may throw EntityExceptions when input is invalid, or when solutions are not found or infinite.
// The above pick based functions use these to solve specific situations. 
// In general, user programs should use the above pick based functions. 

// get a Point at the intersection of 2 lines
	Point CadLib2D_SolveLineLineIntersection(const Line& l1, const Line& l2) 
		throw (EntityException);

// get a line passing through a point and tangent to a circle
	Line CadLib2D_SolveLineTangentPointCircle(const Point& p, const Circle& c, const Point& pkpt) 
		throw (EntityException);

// get the bisector of two lines, or the midline of parallel lines
	Line CadLib2D_SolveLineConstrainedLineLine(const Line&,const Line& l2, const Point&, const Point&) 
		throw (EntityException);

// get the line tangent to two circles
	Line CadLib2D_SolveLineTangentCircleCircle(const Circle&, const Circle&, const Point&, const Point&) 
		throw (EntityException);

// get a line tangent to a circle and parallel to a line
	Line CadLib2D_SolveLineTangentCircleParallelLine(const Circle&, const Line&, const Point&) 
		throw (EntityException);

// arc passing through 3 points
	Arc CadLib2D_SolveArc3Points(const Point& , const Point& , const Point& ) 
		throw (EntityException);

// circle passing through 3 points
	Circle CadLib2D_SolveCircle3Points(const Point& , const Point& , const Point& ) 
		throw (EntityException);

// circle passing a point, tangent to a circle, radius r, solution closest to a point
	Circle CadLib2D_SolveCircleTanPointCircleRadius(const Point&, const Circle&, const double&, const Point& ) 
		throw (EntityException);
		
// circle tangent to 2 lines, radius, solution chosen by point location
	Circle CadLib2D_SolveCircleTanLineLineRadius(const Line&, const Line&, const double&, const Point&)
		throw (EntityException);
		
// circle passing a point, tangent to a line, radius r, solution closest to a point
	Circle CadLib2D_SolveCircleTanPointLineRadius(const Point&, const Line&, const double&, const Point&)
		throw (EntityException);
		
// circle passing 2 points, radius r, right handed circle between points
	Circle CadLib2D_SolveCircleTanPointPointRadius(const Point&, const Point&, const double&)
		throw (EntityException);
		
// circle tanget to 2 circles, radius r, solution chosen by proximity to 2 selection points
	Circle CadLib2D_SolveCircleTanCircleCircleRadius(const Circle&, const Circle&, const double&, const Point&, const Point&)
		throw (EntityException);
		
// circle tangent to a line, tangent to a circle, radius r, solution chosen by 2 selection points
	Circle CadLib2D_SolveCircleTanLineCircleRadius(const Line&, const Circle&, const double&, const Point&, const Point&)
		throw (EntityException);
	
// intersect a line and a circle and return the solution closest to a point 
	Point CadLib2D_SolveLineCircleIntersection(const Line& , const Circle& , const Point&) 
		throw (EntityException);

// intersect two circles returning the solution closest to a point
	Point CadLib2D_SolveCircleCircleIntersection(const Circle&,const Circle&, const Point&) 
		throw (EntityException);

// plane rotation of a vector - theta in radians
	Point CadLib2D_Rotate(const Point& v, double theta) 
		throw (EntityException); 

// formulate a normalized explicit form of a Line
	int CadLib2D_NormalizedExplicitForm(double& a, double& b, double& c, const Line& l) 
		throw (EntityException);
// returns LINE_IS_VERTICAL in that special case


#endif
