// circle.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef CIRCLE_H
#define CIRCLE_H

#include "entity.h"	// ISA
#include "point.h"	// HASA
#include <iostream.h>	// ITO

class EntityException;

class Circle: public Entity
{

private:
	Point center;
	Point origin;

public:

// constructors
	Circle();
	Circle(const Point& c, const Point& o) throw (EntityException);	// center and circle origin
	Circle(const Point& c, double r) throw (EntityException);	// center and radius

	virtual ~Circle() {}

// copy constructor and operator
	Circle(const Circle& c);
	Circle& operator=(const Circle& c);

// evaluation functions
	Point Center() const { return center; }
	Point Origin() const { return origin; }
	double Radius() const;
	Point U(double u) const;

	friend ostream& operator<<(ostream& os, const Circle& c);

	Point Project(const Point& p) const throw (EntityException);
	double UProject(const Point& p) const throw (EntityException);
	
	virtual double Distance(const Point& p) const; // return closest point.

};


#endif
