// line.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include "line.h"
#include "entity_enum.h"
#include "entityexception.h"


Line::Line():Entity(LINE),origin(),direction(1,0,0)
{
}

Line::Line(const Point& o, const Point& d) throw (EntityException):Entity(LINE),origin(o)
{
	if(d == Point())throw EntityException("Line::Line(Point,Dir) : null direction");
	direction = d.Normal();
}

ostream& operator<<(ostream& os, const Line& l)
{
	os << "Line: P = " << l.origin << "  D =  " << l.direction;
	return os;
}

Point Line::Project(const Point& p) const
{
	Point px, vp;
	if(p.Distance(origin)< Point::NullDist)return p; // point is at origin 
	vp = p - origin;
	double theta;
	try
	{
		theta = Angle(direction,vp);
	}
	catch (EntityException& ge)
	{	// point on line
		return p;
	}
	px = origin + ( vp.Magnitude() * cos(theta))* direction ;

	return px;
}

double Line::Distance(const Point& p ) const
{
	Point px = Project(p);
	return p.Distance(px);
}
