// line.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef LINE_H
#define LINE_H

#include "entity.h"  // ISA
#include "point.h" // HASA

// a line is an unlimited entity.
// defined in double precision, by a point, and a 3D vector.

// in the 2d application, the z values must be zero.
//
class EntityException;

class Line : public Entity
{
public:
	static double NullDist;

protected:	//data
	Point origin;		// one point
	Point direction;	// and a direction - always normalized
public:
// constructors
	Line();		// default creates a horizontal line through the 
	Line(const Point& o, const Point& d) throw (EntityException); // by origin and direction

	virtual ~Line() {}

// utilities
	Point Origin() const { return origin; }
	Point Direction() const { return direction; }
	friend ostream& operator<<(ostream& os, const Line& l);

	virtual Point Project(const Point& p) const;
	virtual double Distance(const Point& p) const;
};

#endif
