// pick.cpp

// Copyright (C) 1997  Cliff Johnson                                  //
//                                                                         //
// This is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//   

#include "pick.h"

Pick::Pick(const Entity* g, const Point& p,Locale l ): point(p), locale(l)
{
	entity = g;
}

//Pick::Pick(const Selection&, int r) // a selection and a rounding value
// I am temped to make a 'smart' container. responsible for
// allocating and managing itself. But as I am unsure of the best way, 
// for now, making the user allocate the entity may be better, because in 
// any case the memory freeing method must be called, and in this way the 
// user will be reminded that this is so. 

Pick::Pick(const Pick& p )
{
	entity = p.entity;
	point = p.point;
	locale = p.locale;
}


Pick& Pick::operator=(const Pick& p )
{
	entity = p.entity;
	point = p.point;
	locale = p.locale;
	return *this;
}

bool operator==(const Pick& p1, const Pick& p2)
{
	return ((p1.entity == p2.entity)&&( p1.point == p2.point)&&(p1.locale == p2.locale));
}


ostream& operator<<(ostream& os, const Pick& p)
{
	os << "Pick: Type() = " << p.entity->Type() 
		  << " address = " << p.entity
		  << " Point = " << p.point ;
	if(p.locale== UNUSED)os << " is unused\n";
	else if(p.locale==PERSISTENT)os << " is persistent";
	else if(p.locale==LOCAL) os << " is local";
	else if(p.locale==DELETED) os << " has been deleted";
	else if(p.locale==LOCKED) os << " is locked";
	return os;
		  
}

void Pick::CleanUp()
{
	if(locale == LOCAL ) 
	{
		delete entity;
		locale = DELETED;
	}
}

bool Pick::Lock() // locking a pick prevents the pointered entity from being deleted during clean up.
{
	if(locale == LOCKED ) return true;
	if(locale != LOCAL) return false;
	locale = LOCKED;
	return true;
}

bool Pick::Unlock()
{
	if(locale != LOCKED ) return false;
	locale = LOCAL;
	return true;
}
	
