// pickentity.cpp


// Copyright (C) 1998  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include "pickentity.h"


#include"point.h"
#include"line.h"
#include"segment.h"
#include"circle.h"
#include"arc.h"
#include"pick.h"
#include"entityexception.h"
#include"entity_enum.h"


//***********************************************************************************
Point GetPointFromPick(const Pick& p ) throw(EntityException) 
{
	if(p.Type() != POINT)
		throw EntityException("GetPointFromPick() : Pick is not a point");
	const Point* px;
	if((px = dynamic_cast<const Point*>(p.PointsAt()))==0)
		throw EntityException("GetPointFromPick() : Pick->const Point* dynamic_cast returns 0");
	return Point(*px);
}

//***********************************************************************************
Line GetLineFromPick(const Pick& p) throw (EntityException)
{
	Line l;
	if(p.Type() != LINE && p.Type() != SEGMENT)
		throw EntityException("GetLineFromPick() : Pick is not a Segment or a Line");

	if(p.Type() == SEGMENT)
	{
		const Segment* sx;
		if((sx = dynamic_cast<const Segment*>(p.PointsAt()))==0)
			throw EntityException("GetLineFromPick() : Pick->const Segment* dynamic_cast returns 0");
		l = (*sx).Support();
	}
	else             
	{
		const Line* lx;
		if((lx = dynamic_cast<const Line*>(p.PointsAt()))==0)
			throw EntityException("GetLineFromPick() : Pick->const Line* dynamic_cast returns 0");
		l = Line(*lx);
	}
	return l;
}
//***********************************************************************************
Segment GetSegmentFromPick(const Pick& p ) throw(EntityException) 
{
	if(p.Type() != SEGMENT)
		throw EntityException("GetSegmentFromPick() : Pick is not a segment");
	const Segment* sx;
	if((sx = dynamic_cast<const Segment*>(p.PointsAt()))==0)
		throw EntityException("GetPointFromPick() : Pick->const Segment* dynamic_cast returns 0");
	return Segment(*sx);
}

//***********************************************************************************
Circle GetCircleFromPick(const Pick& p) throw (EntityException)
{
	if(p.Type() != CIRCLE && p.Type() != ARC)
		throw EntityException("GetCircleFromPick() : Pick is not a Circle or an Arc");

	Circle c;
	if(p.Type() == ARC){
		const Arc* ax;
		if((ax = dynamic_cast<const Arc*>(p.PointsAt()))==0)
			throw EntityException("GetCircleFromPick() : Pick->const Arc* dynamic_cast returns 0");
		c = (*ax).Support();
	}
	else             
	{
		const Circle* cx;
		if((cx = dynamic_cast<const Circle*>(p.PointsAt()))==0)
			throw EntityException("GetCircleFromPick() : Pick->const Circle* dynamic_cast returns 0");
		c = Circle(*cx);
	}
	return c;
}

//***********************************************************************************

Arc GetArcFromPick(const Pick& p )throw(EntityException) 
{
	if(p.Type() != ARC)
		throw EntityException("GetArcFromPick() : Pick is not a segment");
	const Arc* ax;
	if((ax = dynamic_cast<const Arc*>(p.PointsAt()))==0)
		throw EntityException("GetPointFromPick() : Pick->const Arc* dynamic_cast returns 0");
	return Arc(*ax);
}


