// pickentity.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
// 


// pickentity.h contains support functions for getting entities from picks


#ifndef PICKENTITY_H
#define PICKENTITY_H

class Point;
class Line;
class Segment;
class Circle;
class Arc;
class EntityException;
class Pick;


Point GetPointFromPick(const Pick&) throw (EntityException); 
Line GetLineFromPick(const Pick&) throw (EntityException); 
Circle GetCircleFromPick(const Pick&) throw (EntityException); 
Arc GetArcFromPick(const Pick&) throw (EntityException);
Segment GetSegmentFromPick(const Pick&) throw (EntityException);



#endif

