// point.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef _POINT_HPP_
#define _POINT_HPP_

#include "entity.h"   //        ISA
#include <iostream.h> // 	ITO

class EntityException;

class Point : public Entity
{
public:		// global - system parameters

	static double NullDist;
	static double MaxSize;		// largest allowed entity dimension - used to avoid junk points.
	static double NullAngle;	// in radians

private:	// data

	double P[3];
public:

// constructors
	Point();
	Point(double* p);
	Point(const Point&);
	Point(double x, double y, double z=0);

	virtual ~Point() {}

// operators 
	Point& operator=(const Point&);
	double operator[] (int i) const { return P[i]; }
	Point operator+(const Point&) const; 			// vector addition
	Point operator-(const Point&) const; 			// vector subtraction
	double operator*(const Point&) const; 			// dot product
	Point operator*(double) const; 				//scalar multiplication

// utility
	double Magnitude() const ;
	Point Normal() const throw (EntityException);
	Point Round(int power ) const;    // round the coordinates to the nearest 10 ^ power

// friends
// operators  
	friend Point operator-(const Point&); // unary  minus
	friend Point operator*(double, const Point&); 	//scalar multiplication  - communitive -
	friend ostream& operator<<(ostream&,const Point&);
	friend istream& operator>>(istream&,Point&);
// services
	friend double Angle(const Point&, const Point&) throw(EntityException);
	friend Point Cross(const Point&, const Point&); // cross product
	friend double Distance(const Point&, const Point&);
	friend bool operator==(const Point&, const Point&); // for stl

	virtual double Distance(const Point&) const;

};	

typedef Point Vector;

#endif
