// segment.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include "segment.h"
#include "entity_enum.h"
#include "line.h"
#include "entityexception.h"

Segment::Segment():Entity(SEGMENT)
{
	origin = Point();
	endpoint = Point(1,0);
}

Segment::Segment(const Point& o, const Point& e)throw(EntityException)
	:Entity(SEGMENT),origin(o),endpoint(e)
{
	double d = o.Distance(e);
	if(d < Point::NullDist) throw EntityException("Segment::Segment(o,e) : Points are equal");
	if(d > Point::MaxSize) throw EntityException("Segment::Segment(o,e) : Segment too long - exceeds Point::MaxDist");
}

Point Segment::U(double u) const
{
	return origin + u * ( endpoint - origin ); 
}

ostream& operator<<(ostream& os, const Segment& l)
{
	os << "Segment: O = " << l.origin << "  E =  " << l.endpoint ;
	return os;
}

Line Segment::Support() const
{
	return Line(origin,endpoint-origin);
}

Point Segment::Project(const Point& p) const
{
	Line l = Support();
	return l.Project(p);
}

double Segment::Distance(const Point& p) const
{
	Line l = Support();
	Point px = l.Project(p);
	return p.Distance(px);
}

double Segment::Length() const
{
	return origin.Distance(endpoint);
}
