// segment.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef SEGMENT_H
#define SEGMENT_H

#include "entity.h"  // ISA

#include "point.h" // HASA

class Line;
class EntityException;

// in the 2d application, the z values must be zero.

class Segment : public Entity
{
public:
	Point origin;           // one point
	Point endpoint;
public:
// constructors
	Segment();		
	Segment(const Point&, const Point&) throw (EntityException);

	virtual ~Segment() {}

// utilities
	Point Origin() const { return origin; }
	Point Endpoint() const { return endpoint; }
	Point U(double u) const; 
	Line Support() const;
	double Length() const;

	friend ostream& operator<<(ostream& os, const Segment& s);

	virtual double Distance(const Point&) const;
	virtual Point Project(const Point&) const;
};

#endif
