// testlib.cpp

// Copyright (C) 1997  Cliff Johnson                                  //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//   

#include "point.h"
#include "line.h"
#include "circle.h"
#include "pick.h"
#include "entity_enum.h"
#include "entitylib2d.h"
#include "entityexception.h"

#include <iostream.h>

int main(int argc, char** argv)
{


	Line l1(Point(10,4), Point(-1,1));
	Line l2(Point(1,1), Point(1,1));

	Point p;

	cout << "\nTEST 1: Line vs. Line intersection : Simple case\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try { 
		p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch (const EntityException& e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	l2 = Line(Point(0,0), Point(1,0));

	cout << "\nTEST 2: Line vs. Line intersection : Horizontal line 2\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try { 
		p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	l2 = Line(Point(2,10), Point(-1,1));

	cout << "\nTEST 3: Line vs. Line intersection : Parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try {
	p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	l2 = Line(Point(2,10), Point(-1,.9998));

	cout << "\nTEST 4: Line vs. Line intersection : Nearly parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try {
		p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	l2 = Line(Point(2,10), Point(-1,.9999));

	cout << "\nTEST 5: Line vs. Line intersection : Nearly parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try {
		p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	l1 = Line(Point(2,10.5), Point(0,1));

	cout << "\nTEST 6: Line vs. Line intersection : Vertical line 1\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try {
	p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	l2 = Line(Point(2,10.5), Point(0,1));

	cout << "\nTEST 7 : Line vs. Line intersection : Vertical and Parallel lines:\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try { 
	p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;
		
	l1 = Line(Point(4,6), Point(2,3));

	cout << "\nTEST 8 : Line vs. Line intersection : Vertical line 2\n";
	cout << "l1 = " << l1 << '\n';
	cout << "l2 = " << l2 << '\n';
	try {
	p = CadLib2D_SolveLineLineIntersection(l1,l2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	cout << "\nTEST 9 : point projection 1: Point(0,0) to l2 = " << l2.Project(Point()) << '\n';

	l1 = Line(Point(3,3), Point(1,-1));
	cout << "l1 = " << l1 << '\n';
	cout << "\nTEST 10: point projection 2: Point(0,0) to l1 = " << l1.Project(Point()) << '\n';

	// testing of general line by 2 constraints 

	Circle c1 = Circle(Point() ,5.);
	Circle c2 = Circle(Point() ,5.);
	Point pick1(-1,5);
	Point pick2(1,5);

	cout << "\nTEST 11: SolveLineTangentCircleCircle 1: coincident circles\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
		l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	c2 = Circle(Point(1,0),5.);

	cout << "\nTEST 12: SolveLineTangentCircleCircle 2: circle center inside circle 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	pick1 = Point(-1,-5);

	cout << "\nTEST 13: SolveLineTangentCircleCircle 3: circle center inside circle 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	c1 = Circle(Point(2,1),5.);

	cout << "\nTEST 14: SolveLineTangentCircleCircle 4: circle center inside circle 3\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	c1 = Circle(Point() ,5.);
	c2 = Circle(Point(2,2) ,2.);

	cout << "\nTEST 15: SolveLineTangentCircleCircle 5: circle inside circle 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	c2 = Circle(Point(2,0),3);
	
	cout << "\nTEST 16: SolveLineTangentCircleCircle 6: circle inside circle and tangent 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	c2 = Circle(Point(10,10),5);
	pick1 = Point(0,5);
	pick2 = Point(7,13);
	
	cout << "\nTEST 17: SolveLineTangentCircleCircle 7: general solution 1\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;
	
	pick2 = Point(13,7);
	
	cout << "\nTEST 18: SolveLineTangentCircleCircle 8: general solution 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	pick1 = Point(5,-5);
	
	cout << "\nTEST 19: SolveLineTangentCircleCircle 9: general solution 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try {
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	pick2 = Point(6,10);
	
	cout << "\nTEST 20 : SolveLineTangentCircleCircle 10: general solution 2\n";
	cout << "c1 = " << c1 << '\n';
	cout << "c2 = " << c2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try { 
	l1 = CadLib2D_SolveLineTangentCircleCircle(c1,c2,pick1,pick2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;


	Point px1(-14.2105,1.05263);
	Point px2(56.3158, 9.47368 );
	Point px3(66.0526, 3.94737);
	Point px4(-14.7368, -9.21053);

	Circle cx1(px1,px4);
	Circle cx2(px2,px3);

	pick1=Point(-10,-8.94737);
	pick2=Point( 53.6842, 20.7895);

	cout << "\nTEST 21: SolveLineTangentCircleCircle 11:\n";
	cout << "cx1 = " << cx1 << '\n';
	cout << "cx2 = " << cx2 << '\n';
	cout << "pick1 = " << pick1 << '\n';
	cout << "pick2 = " << pick2 << '\n';
	try { 
	l1 = CadLib2D_SolveLineTangentCircleCircle(cx1,cx2,pick1,pick2);	
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;


	cout << "\nTEST 22: Using Picks...CadLib2D_LineConstraints(CIRCLE,CIRCLE)\n";
	Pick pk1(&c1,pick1);
	Pick pk2(&c2,pick2);
	cout << "pk1 = " << pk1 << '\n';
	cout << "pk2 = " << pk2 << '\n';
	try {
		l1 = CadLib2D_LineByConstraints(pk1,pk2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	cout << "\nTEST 23: CadLib2D_LineConstraints(POINT,POINT)\n";
	pk1 = Pick(&pick1, pick1);
	pk2 = Pick(&pick2, pick2);
	cout << "pk1 = " << pk1 << '\n';
	cout << "pk2 = " << pk2 << '\n';
	try 
	{
		l1 = CadLib2D_LineByConstraints(pk1,pk2);
	}
	catch ( const EntityException & e)
	{
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "l1 = " << l1 << endl;

	cout << "\nTEST 25: Using Picks...CadLib2D_PointConstraints(CIRCLE,CIRCLE)\n";
	Point pz1(10,20);
	Point pz2(-10,10);
	pk1 = Pick(&pz1,pick1);
	pk2 = Pick(&pz2,pick2);
	cout << "pk1 = " << pk1 << '\n';
	cout << "pk2 = " << pk2 << '\n';
	try {
		p = CadLib2D_PointByConstraints(pk1,pk2);
	}
	catch ( const EntityException & e){
		cout << "exception caught: " << e.what() << endl;
	}	
	cout << "p = " << p << endl;

	return 0;

}


