//geommenuarcdialog.cpp


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mas

// #include the headers we need
#include <iostream.h>

#include "geommenuarcdialog.h"
#include "geommenu_enum.h"

// This defines the dialog

    static DialogCmd arcDialogCommands[] =
      {
        {C_Label, ARCDIALOGLABEL, 0,
		"Arc Options",NoList,CA_MainMsg,isSens,NoFrame, 0, 0},
        {C_CheckBox,ARCDIALOGCENTERLINES,0,
		"centerlines",NoList,CA_None,isSens,NoFrame,0,ARCDIALOGLABEL},
        {C_Frame,ARCDIALOGRADIOFRAME,0,"",NoList,CA_None,isSens,NoFrame,0,ARCDIALOGCENTERLINES},
        {C_RadioButton,ARCDIALOGHOLE,1,
		"hole",NoList,CA_None,isSens,ARCDIALOGRADIOFRAME,0,0},
        {C_RadioButton,ARCDIALOGTHREADED,0,
		"threads",NoList,CA_None,isSens,ARCDIALOGRADIOFRAME,0,ARCDIALOGHOLE},
        {C_RadioButton,ARCDIALOGTAPPED,0,
		"tapped",NoList,CA_None,isSens,ARCDIALOGRADIOFRAME,0,ARCDIALOGTHREADED},

        {C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };


//==========================>>> GeomMenuArcDialog::GeomMenuArcDialog <<<======================
  GeomMenuArcDialog::GeomMenuArcDialog(vBaseWindow* bw) :
    vDialog(bw)
  {
    // The constructor for a derived dialog calls the superclass
    // constructor, and then adds the command objects to the dialog
    // by calling AddDialogCmds.

    AddDialogCmds(arcDialogCommands);         // add the command objects
  }

//=========================>>> GeomMenuArcDialog::~GeomMenuArcDialog <<<======================
  GeomMenuArcDialog::~GeomMenuArcDialog()
  {
    // Destructor often doesn't need to do anything

  }

//====================>>> GeomMenuArcDialog::DialogCommand <<<======================
  void GeomMenuArcDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {
    // After the user has selected a command from the dialog,
    // this routine is called with the value.

    vDialog::DialogCommand(id,retval,ctype);
  }


//====================>>> GeomMenuArcDialog::Centerlines()<<<======================

bool GeomMenuArcDialog::Centerlines() 
{
	return GetValue(ARCDIALOGCENTERLINES);
}

int GeomMenuArcDialog::HoleStyle() 
{
	if(GetValue(ARCDIALOGTHREADED))
	{
		return 1;
	}
	else if(GetValue(ARCDIALOGTAPPED))
	{
		return 2;
	}
	else
	{
		return 0;
	}
}
