// geommenuhandler.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //


#ifndef GEOMMENUHANDLER_H
#define GEOMMENUHANDLER_H

#include <menuhandler.h>

#include <drawablepoint.h>
#include <drawableline.h>
#include <drawablecircle.h>
#include <drawablesegment.h>
#include <drawablearc.h>
#include <point.h>

class Pick;

// command signatures
#include <geommenu_enum.h>

class	GeomMenuArcDialog;
class ComException;


class GeomMenuHandler: public MenuHandler
{

public:

// constructor  
	GeomMenuHandler(vdCmdWindow* cmdwin,int); // parent command window and rounding constant.

	virtual ~GeomMenuHandler();

// input functions 
	virtual void CommandActions();
	virtual void MenuCommand(int);

//solver calling functions

	void  PointByPicking0();
	void  PointByPicking1();

	void  PointByConstraints0();
	void  PointByConstraints1();
	void  PointByConstraints2();

	void  LineHorzAndVert0(int);
	void  LineHorzAndVert1();

	void  LineByConstraints0();
	void  LineByConstraints1();
	void  LineByConstraints2();

	void  LineOriented0();
	void  LineOriented1();

	void  LineOrthoginal0();
	void  LineOrthoginal1();
	void  LineOrthoginal2();

	void  CircleCenter0();
	void  CircleCenter1();
	void  CircleCenter2();

	void  CircleRadiusAndCenter0();
	void  CircleRadiusAndCenter1();
	
	void CircleRadiusAndConstraints0();
	void CircleRadiusAndConstraints1();
	void CircleRadiusAndConstraints2();
	
	void CircleConstraints0();
	void CircleConstraints1();

	void  Trace0();
	void  Trace1();
	void  Trace2();
	void  Trace3();
	//void  TraceLineDrive(Pick&,int,Pick&,int) throw (ComException);

	void  ArcConstraints0();
	void  ArcConstraints1();

	void  ArcClosed0();
	void  ArcClosed1();

	void Trim0();
	void Trim1();
	void Trim2();

	void Cut0();
	void Cut1();
	void Cut2();
	
	void ParallelAtDistance0();
	void ParallelAtDistance1();
	
	void CreateSupport0();
	void CreateSupport1();

private:

	GeomMenuArcDialog* arcDialog;

private:
	Point part; 	// for part-drive-check processing
};

#endif
