// saverecallmenuhandler.cpp

// Copyright (C) 1998  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //


// for now just a straight serial save of the canvas register contents. 
// later on, putting recall/store in its own menu space will allow all 
// kinds of necessary interaction with the save/recall process like for example
// "saving only the red curves" or " recalling the model to this transformed cs".

#include <v/vnotice.h>
#include <v/vynreply.h>

#include <string>
#include <fstream.h>
#include <iostream.h>
#include <strstream.h>

#include <saverecallmenuhandler.h>

#include <saverecallmenu_enum.h>
#include <vdapp_enum.h>
#include <entity_enum.h>
#include <drawable_enum.h>
#include <handle.h>

#include <point.h>
#include <line.h>
#include <circle.h>
#include <segment.h>
#include <arc.h>

extern "C"
{
#include <time.h>
#include <sys/stat.h>
#include <unistd.h>
}

const float FD_VERSION=0.3;
const char DBSEP = '\n';


//**********constructor ***********************************************************
SaveRecallMenuHandler::SaveRecallMenuHandler(vdCmdWindow* cmdwin,int r) 
: MenuHandler(cmdwin,r)
{

// set the menu and button labels.

	commandWindow->SetString(MENULABEL0,"Label0");
	commandWindow->SetString(MENUBUTTON00,"button00");
	commandWindow->SetString(MENUBUTTON01,"button01");

	commandWindow->SetString(MENULABEL1,"Label1");
	commandWindow->SetString(MENUBUTTON10,"button10");
	commandWindow->SetString(MENUBUTTON11,"button11");

	commandWindow->SetString(MENULABEL2,"Label2");
	commandWindow->SetString(MENUBUTTON20,"button20");
	commandWindow->SetString(MENUBUTTON21,"button21");

	commandWindow->SetString(MENULABEL3,"Label3");
	commandWindow->SetString(MENUBUTTON30,"button30");
	commandWindow->SetString(MENUBUTTON31,"button31");

	commandWindow->SetString(MENULABEL4,"Label4");
	commandWindow->SetString(MENUBUTTON40,"button40");
	commandWindow->SetString(MENUBUTTON41,"button41");

	commandWindow->SetString(MENULABEL5,"Label5");
	commandWindow->SetString(MENUBUTTON50,"button50");
	commandWindow->SetString(MENUBUTTON51,"button51");

	commandWindow->SetString(MENULABEL6,"Label6");
	commandWindow->SetString(MENUBUTTON60,"button60");
	commandWindow->SetString(MENUBUTTON61,"button61");

	commandWindow->SetString(MENULABEL7,"Label7");
	commandWindow->SetString(MENUBUTTON70,"button70");
	commandWindow->SetString(MENUBUTTON71,"button71");

	commandWindow->SetString(MENULABEL8,"Label8");
	commandWindow->SetString(MENUBUTTON80,"button80");
	commandWindow->SetString(MENUBUTTON81,"button81");

	commandWindow->SetString(MENULABEL9,"Label9");
	commandWindow->SetString(MENUBUTTON90,"button90");
	commandWindow->SetString(MENUBUTTON91,"button91");

	commandWindow->SetValue(MENUBUTTON00,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON01,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON10,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON11,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON20,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON21,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON30,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON31,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON40,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON41,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON50,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON51,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON60,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON61,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON70,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON71,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON80,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON81,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON90,notSens,Sensitive);
	commandWindow->SetValue(MENUBUTTON91,notSens,Sensitive);
}

//**********destructor ***********************************************************

SaveRecallMenuHandler::~SaveRecallMenuHandler()
{
}

//****************
void SaveRecallMenuHandler::MenuCommand(int id)
{
	switch(id)
	{
	case FD_SAVE:
		Save();
		break;
	case FD_RECALL:
		Recall();
		break;
	}
}

//****************
void SaveRecallMenuHandler::Save()
{
	RegisteredEntity re;

	string filename; 

	Handle hx;
	Attributes ax;

	Point point;
	Line line;
	Circle circle;
	Arc arc;
	Segment segment;

	vNoticeDialog note(commandWindow);
	vYNReplyDialog askYN(commandWindow);

	time_t tx = time(NULL);
	struct stat buf;
	int ans;

	filename = CurrentFileName();

	Say(NULL);
	Say("Saving file: ");
	Say(filename.c_str());

// check for existing file, prompt for overwrite
	ans = stat(filename.c_str(),&buf);
	if(ans == 0) // stat returns 0 for existing file
	{
		ans = askYN.AskYN("Overwrite existing file?");
		if(ans != 1)
		{
			Say("--- > File not saved!");
			return;
		}
	}
	

// open the file
	ofstream fs(filename.c_str());
	if(!fs.is_open())
	{
		note.Notice("Error opening file - not saved!");
		Say("--- > File not saved!");
		return;
	}
// write header information - version and save date -
	
	fs << "FREEdraft "<< FD_VERSION << '\n';
	fs << "# " << ctime(&tx);


// iterate through the canvas register
	CanvasRegisterInit();
	while(CanvasRegisterNextItem(re))
	{
// write out record header ,type, color, style, thick/size, layer , and data for each entity, space delimited, and null terminated
		hx = re.GetHandle();
		ax = re.GetAttributes();
		fs << 'E' << ' ' 
		   << hx.Type()     	<< ' ' 
                   << ax.GetColor() 	<< ' '
		   << ax.GetLineStyle() << ' '
		   << ax.GetThick() 	<< ' '
		   << ax.GetLayer()     << ' ';

		switch(hx.Type())
		{
		case POINT:
			{	
				point = Point(*(dynamic_cast<const Point*>(hx.PointsAt())));
				fs << point << '\n';
				break;
			}
		case LINE:
			{
				line = Line(*(dynamic_cast<const Line*>(hx.PointsAt())));
				fs << line.Origin() << ' ' << line.Direction() << '\n';
				break;
			}
		case CIRCLE:
			{
				circle = Circle(*(dynamic_cast<const Circle*>(hx.PointsAt())));
				fs << circle.Center() << ' ' << circle.Origin() << '\n';
				break;
			}
		case SEGMENT:
			{
				segment = Segment(*(dynamic_cast<const Segment*>(hx.PointsAt())));
				fs << segment.Origin() << ' ' << segment.Endpoint() << '\n';
				break;
			}
		case ARC:
			{
				arc = Arc(*(dynamic_cast<const Arc*>(hx.PointsAt())));
				fs << arc.Center() << ' ' << arc.Origin() << ' ' << arc.Endpoint() << '\n';
				break;
			}
		}
	}
	fs.close();
	Say(" ---> File saved.");
}

//****************
void SaveRecallMenuHandler::Recall()
{
	RegisteredEntity re;
	string filename = CurrentFileName();
	Handle hx;
	Attributes ax;
	Point point,p1,p2,p3;
	Line line;
	Circle circle;
	Arc arc;
	Segment segment;
	vNoticeDialog note(commandWindow);
	vYNReplyDialog askYN(commandWindow);
	string data;
	float checkver;
	int ans;

// message
	Say(NULL);
	Say("Reading file: ");
	Say(filename.c_str());
// open the file
	ifstream fs(filename.c_str());
// check it is open ok
	if(!fs.is_open())
	{
		note.Notice("Error opening file! - file not recalled! ");
		Say("--- > File not recalled !");
		return;
	}
// check the title and version
	fs >> data >> checkver;

	if(data != string("FREEdraft"))
	{
		note.Notice("Error in file format - file not recalled! ");
		Say("--- > File not recalled !");
		return;
	}

	if(checkver > FD_VERSION)
	{
		ans = askYN.AskYN("Warning: file version is later than FREEdraft version. Continue?");
		if(ans != 1)
		{
			Say("--- > File not recalled !");
			return;
		}
	
	}

// position at the start of the next record
	

// read the entities
	int count = 0;
// past end of line
	fs.get();

	while(DBReadRecord(fs,data))
	{
		char marker;

// use a strstream to process data
		istrstream idata(data.c_str());

// get the record marker
		idata >> marker;

// the first character on each line is the record type
// # = comment
// E = entity
		switch(marker)
		{
		case '#': // comment
			{
				cerr << data << endl;
				break;
			}
		case 'E': // entity
			{
// get the common things, the type and the attributes
// second token is the entity type
// four fields are attributes : color,style,thickness, and layer
				int type;
				unsigned int color,thick,layer;
				unsigned short style;

				idata >> type;
				idata >> color;
				idata >> style;
				idata >> thick;
				idata >> layer;
				ax = Attributes(color,style,thick,layer);
				

// process the real data,  and create the entity in the bank
				switch(type)
				{
				case POINT:
					{
						idata >> p1;
						hx = BankCreate(new Point(p1));
						Register(hx,ax,Drawable(FD_DRAWABLE_POINT));
						break;
					}
				case LINE:
					{
						idata >> p1;
						idata >> p2;
						hx = BankCreate(new Line(p1,p2));
						Register(hx,ax,Drawable(FD_DRAWABLE_LINE));
						break;
					}
				case CIRCLE:
					{
						idata >> p1;
						idata >> p2;
						hx = BankCreate(new Circle(p1,p2));
						Register(hx,ax,Drawable(FD_DRAWABLE_CIRCLE));
						break;
					}
				case SEGMENT:
					{
						idata >> p1;
						idata >> p2;
						hx = BankCreate(new Segment(p1,p2));
						Register(hx,ax,Drawable(FD_DRAWABLE_SEGMENT));
						break;
					}
				case ARC:
					{
						idata >> p1;
						idata >> p2;
						idata >> p3;
						hx = BankCreate(new Arc(p1,p2,p3));
						Register(hx,ax,Drawable(FD_DRAWABLE_ARC));
						break;
					}
				}
				count++;
				break;
			}
		}
	}

	fs.close();
	Say("---> ");
	Say(count);
	Say(" entities recalled.");
	Redraw();
}


int SaveRecallMenuHandler::DBReadRecord(ifstream& fs, string& s)
{
// if fs is not open , or in a bad state, return an error, else return number of
// characters read from current poisition up to the database delimeter
        if(!(fs.is_open()) || !(fs.good()) )return 0;
        
// clear the string
        s = "";

        char c;
        int count = 0;
        while((c = fs.get())!=DBSEP && fs.good()){
                s+=c;
                count++;
        }
        return count;
}

