// saverecallmenuhandler.h

// Copyright (C) 1998  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //


#ifndef SAVERECALLMENUHANDLER_H
#define SAVERECALLMENUHANDLER_H

#include <menuhandler.h>

#include <drawablepoint.h>
#include <drawableline.h>
#include <drawablecircle.h>
#include <drawablesegment.h>
#include <drawablearc.h>
#include <point.h>

#include <string>

// command sigs
#include <saverecallmenu_enum.h>

class ComException;
class ifstream;

class SaveRecallMenuHandler: public MenuHandler
{
private:

public:

// constructor  
	SaveRecallMenuHandler(vdCmdWindow* cmdwin,int); // parent command window and rounding constant.
	virtual ~SaveRecallMenuHandler();
	
// input functions 
	virtual void MenuCommand(int);
	
	void Save();
	void Recall();
	
	int DBReadRecord(ifstream&, string&);
};

#endif
