// colordialog.cpp

// copyright 1998 Cliff Johnson 
// iamcliff@ix.netcom.com
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

#include "colordialog.h"
#include <iostream.h>
#include <menuhandler.h>
#include <attrib_enum.h>

    static DialogCmd ColorDialogCmds[] =
      {

#define vC_Size 12
#include <v/vcb2x8.h>

 //       {C_Button, M_Cancel, M_Cancel," Cancel ",NoList,CA_None,isSens,NoFrame,CA_None,M_ColorFrame},
        {C_Button, M_OK, M_OK,"  Done  ", NoList, CA_DefaultButton,isSens, NoFrame, M_Cancel, M_ColorFrame},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}

      };


//======================>>> ColorDialog::ColorDialog <<<==================
  ColorDialog::ColorDialog(vBaseWindow* bw, MenuHandler* mh) :
    vDialog(bw)
  {
    menuHandler= mh;
    AddDialogCmds(ColorDialogCmds);		// add the predefined commands
  }

//===================>>> ColorDialog::~ColorDialog <<<====================
  ColorDialog::~ColorDialog()
  {
  }

//====================>>> ColorDialog::DialogCommand <<<====================
  void ColorDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {

	switch(retval)
	{
		case  FD_BLACK:
		case  FD_RED:
		case  FD_DIMRED:
		case  FD_GREEN:
		case  FD_DIMGREEN:
		case  FD_CYAN:
		case  FD_DIMCYAN:
		case  FD_BLUE:
		case  FD_DIMBLUE:
		case  FD_YELLOW:
		case  FD_DIMYELLOW:
		case  FD_MAGENTA:
		case  FD_DIMMAGENTA:
		case  FD_DARKGREY:
		case  FD_MEDGREY:
		case  FD_WHITE:
		{
			menuHandler->LoadColor(retval);
			break;
		}
		case  M_OK:
		{
			break;
		}
	}

    vDialog::DialogCommand(id,retval,ctype);
  }
