// inputstring.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include "inputstring.h"

extern "C"
{
#include <string.h>
}

#include <strstream.h>


InputString::InputString()
{
	c_string[0]='\0';
	cnt=0;
}

InputString::InputString(char* s)
{
	strncpy(c_string,s,255);
	cnt=strlen(s);
	if (cnt > 255){
		c_string[255]='\0';
		cnt=255;
	}
}

void InputString::Clear()
{
	for(int i=0;i<256;i++)c_string[i]='\0';
	cnt=0;
}

void InputString::AddChar(char c)
{
	c_string[cnt]=c;
	cnt++;
}

void InputString::AppendString(const int& ix)
{
	char * p;
	int pcnt;
	ostrstream data;
	data << ix;
	p = data.str();
	pcnt = data.pcount();
	for(int i=0; i< pcnt && cnt < 255 ; i++){
		c_string[cnt] = p[i];
		cnt++;
	}
}

void InputString::AppendString(const char* sx)
{
	int ix = strlen(sx);
	for(int i = 0;(i < ix) &&( cnt < 255); i++)
	{
		c_string[cnt]=sx[i];
		cnt++;
	}
}


void InputString::DelChar()
{
  if(cnt>0){
    cnt--;
    c_string[cnt]='\0';
  }
}

const char* InputString::GetString() const
{
	return c_string;
}

bool InputString::IsClear() const
{
	return (cnt==0);
}
	
int InputString::InputSize() const
{
	return cnt;
}

void InputString::ClearAndLoad(char* s)
{
	Clear();
	strncpy(c_string,s,255);
	cnt=strlen(s);
	if (cnt > 255){
		c_string[255]='\0';
		cnt=255;
	}
}
