// linestyledialog.cpp

// copyright 1998 Cliff Johnson 
// iamcliff@ix.netcom.com
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

enum {  LSD_LINESTYLE_LABEL = 1667,
	LSD_RADIOFRAME,
	LSD_SOLID_ICONBTN,
	LSD_LONGDASH_ICONBTN,
	LSD_DOTTED_ICONBTN,
	LSD_CHAIN_ICONBTN,
	LSD_THICK_RADIOFRAME,
	LSD_THICK_LABEL,
	LSD_THIN_ICONBTN,
	LSD_NORMAL_ICONBTN,
	LSD_WIDE_ICONBTN,
	LSD_VERYWIDE_ICONBTN
};

#include "linestyledialog.h"
#include <v/vicon.h>
#include <attrib_enum.h>

//#include <iostream.h>
#include <menuhandler.h>

#include "linestyle_solid.vbm"
    static vIcon linestyle_solid(&linestyle_solid_bits[0],linestyle_solid_height,linestyle_solid_width);
#include "linestyle_longdash.vbm"
    static vIcon linestyle_longdash(&linestyle_longdash_bits[0],linestyle_longdash_height,linestyle_longdash_width);
#include "linestyle_dotted.vbm"
    static vIcon linestyle_dotted(&linestyle_dotted_bits[0],linestyle_dotted_height,linestyle_dotted_width);
#include "linestyle_chain.vbm"
    static vIcon linestyle_chain(&linestyle_chain_bits[0],linestyle_chain_height,linestyle_chain_width);

#include "linethick_thin.vbm"
    static vIcon linethick_thin(&linethick_thin_bits[0],linethick_thin_height,linethick_thin_width);
#include "linethick_normal.vbm"
    static vIcon linethick_normal(&linethick_normal_bits[0],linethick_normal_height,linethick_normal_width);
#include "linethick_wide.vbm"
    static vIcon linethick_wide(&linethick_wide_bits[0],linethick_wide_height,linethick_wide_width);
#include "linethick_verywide.vbm"
    static vIcon linethick_verywide(&linethick_verywide_bits[0],linethick_verywide_height,linethick_verywide_width);

    static DialogCmd LineStyleDialogCmds[] =
      {

	{C_Frame,LSD_RADIOFRAME,0,"",NoList,CA_None,isSens,NoFrame,0,0},
	{C_Label, LSD_LINESTYLE_LABEL, 0,"Line style",NoList,CA_MainMsg,isSens,LSD_RADIOFRAME, 0, 0},
	{C_ToggleIconButton,LSD_SOLID_ICONBTN,1,"",&linestyle_solid,CA_None,isSens,LSD_RADIOFRAME,0,LSD_LINESTYLE_LABEL},
	{C_ToggleIconButton,LSD_LONGDASH_ICONBTN,0,"",&linestyle_longdash,CA_None,isSens,LSD_RADIOFRAME,0,LSD_SOLID_ICONBTN},
	{C_ToggleIconButton,LSD_DOTTED_ICONBTN,0,"",&linestyle_dotted,CA_None,isSens,LSD_RADIOFRAME,0,LSD_LONGDASH_ICONBTN},
	{C_ToggleIconButton,LSD_CHAIN_ICONBTN,0,"",&linestyle_chain,CA_None,isSens,LSD_RADIOFRAME,0,LSD_DOTTED_ICONBTN},

	{C_Frame,LSD_THICK_RADIOFRAME,0,"",NoList,CA_None,isSens,NoFrame,LSD_RADIOFRAME,0},
	{C_Label, LSD_THICK_LABEL, 0,"Thickness",NoList,CA_MainMsg,isSens,LSD_THICK_RADIOFRAME, 0, 0},
	{C_ToggleIconButton,LSD_THIN_ICONBTN,0,"",&linethick_thin,CA_None,isSens,LSD_THICK_RADIOFRAME,0,LSD_THICK_LABEL},
	{C_ToggleIconButton,LSD_NORMAL_ICONBTN,1,"",&linethick_normal,CA_None,isSens,LSD_THICK_RADIOFRAME,0,LSD_THIN_ICONBTN},
	{C_ToggleIconButton,LSD_WIDE_ICONBTN,0,"",&linethick_wide,CA_None,isSens,LSD_THICK_RADIOFRAME,0,LSD_NORMAL_ICONBTN},
	{C_ToggleIconButton,LSD_VERYWIDE_ICONBTN,0,"",&linethick_verywide,CA_None,isSens,LSD_THICK_RADIOFRAME,0,LSD_WIDE_ICONBTN},
	{C_Button, M_OK, M_OK,"   OK   ", NoList, CA_DefaultButton,isSens, NoFrame,0, LSD_RADIOFRAME},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };


//======================>>> LineStyleDialog::LineStyleDialog <<<==================
  LineStyleDialog::LineStyleDialog(vBaseWindow* bw, MenuHandler* mh) :
    vDialog(bw)
  {
    menuHandler= mh;
    AddDialogCmds(LineStyleDialogCmds);		// add the predefined commands
  }

//===================>>> LineStyleDialog::~LineStyleDialog <<<====================
  LineStyleDialog::~LineStyleDialog()
  {
  }

//====================>>> LineStyleDialog::DialogCommand <<<====================
void LineStyleDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
{

	
// radio style behavior
	switch(id)
	{
		case LSD_SOLID_ICONBTN:	
		case LSD_LONGDASH_ICONBTN:	
		case LSD_DOTTED_ICONBTN:	
		case LSD_CHAIN_ICONBTN:	
			SetValue( LSD_SOLID_ICONBTN,0,Value);
			SetValue( LSD_LONGDASH_ICONBTN,0,Value);
			SetValue( LSD_DOTTED_ICONBTN,0,Value);
			SetValue( LSD_CHAIN_ICONBTN,0,Value);
			SetValue(id,1,Value);
			break;
		case LSD_THIN_ICONBTN:	
		case LSD_NORMAL_ICONBTN:	
		case LSD_WIDE_ICONBTN:	
		case LSD_VERYWIDE_ICONBTN:	
			SetValue( LSD_THIN_ICONBTN,0,Value);
			SetValue( LSD_NORMAL_ICONBTN,0,Value);
			SetValue( LSD_WIDE_ICONBTN,0,Value);
			SetValue( LSD_VERYWIDE_ICONBTN,0,Value);
			SetValue(id,1,Value);
			break;
	}
	switch(id)
	{
		case LSD_SOLID_ICONBTN:	
			menuHandler->LoadLineStyle(FD_LINESTYLE_SOLID);
			break;
		case LSD_LONGDASH_ICONBTN:	
			menuHandler->LoadLineStyle(FD_LINESTYLE_LONGDASH);
			break;
		case LSD_DOTTED_ICONBTN:	
			menuHandler->LoadLineStyle(FD_LINESTYLE_DOTTED);
			break;
		case LSD_CHAIN_ICONBTN:	
			menuHandler->LoadLineStyle(FD_LINESTYLE_CHAIN);
			break;
		case LSD_THIN_ICONBTN:	
			menuHandler->LoadThick(FD_LINETHICK_THIN);
			break;
		case LSD_NORMAL_ICONBTN:	
			menuHandler->LoadThick(FD_LINETHICK_NORMAL);
			break;
		case LSD_WIDE_ICONBTN:	
			menuHandler->LoadThick(FD_LINETHICK_WIDE);
			break;
		case LSD_VERYWIDE_ICONBTN:	
			menuHandler->LoadThick(FD_LINETHICK_VERYWIDE);
			break;
	}

    vDialog::DialogCommand(id,retval,ctype);
}
