// attributes.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                        	   //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//                                                                         //

#include <data_enum.h>
#include "attributes.h"

// Attributes class is a manager for graphical attributes of entites
// which has been registered with the vd GL canvas pane class

Attributes::Attributes()
{
}

Attributes::Attributes(int color, unsigned short style, unsigned int thick,unsigned int lyr): // specific constructor
	colorValue(color), lineStyle(style), thickness(thick) ,layer(lyr) {}

Attributes::~Attributes(){}	// destructor 

Attributes::Attributes(const Attributes& a)	      // copy constructor
{
	colorValue = a.colorValue;
	lineStyle = a.lineStyle;
	thickness = a.thickness;
	layer = a.layer;
}

Attributes& Attributes::operator=(const Attributes& a) // assignment operator
{
	colorValue = a.colorValue;
	lineStyle = a.lineStyle;
	thickness = a.thickness;
	layer = a.layer;
	return *this;
}

bool operator==(const Attributes& a1, const Attributes& a2)
{
	return ( (a1.colorValue == a2.colorValue)
	&&       (a1.lineStyle == a2.lineStyle) 
	&&	 (a1.thickness == a2.thickness) 
	&&	 (a1.layer == a2.layer )             );
}

