// attributes.h
// 
// 
// Copyright (C) 1997,1998  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //


#ifndef ATTRIBUTES_H
#define ATTRIBUTES_H

#include <attrib_enum.h>


class Attributes
{

// manager class for graphical attributes of an entity
// a support class for the gl canvas pane

private:
	int colorValue;
	unsigned short lineStyle;
	unsigned int thickness;
	unsigned int layer;
public:
	Attributes();
	Attributes(int color, unsigned short style, unsigned int thick,unsigned int layer);
	~Attributes();

	Attributes(const Attributes& a);
	Attributes& operator=(const Attributes& a);

	inline int GetColor() const { return colorValue; }
	inline unsigned short GetLineStyle() const { return lineStyle; }
	inline unsigned int GetThick() const { return thickness; }
	inline unsigned int GetPointSize() const { return thickness; }
	inline unsigned int GetLayer() const { return layer; } 

	friend bool operator==(const Attributes& a1, const Attributes& a2);
};

#endif
