//canvasregister.cpp

// Copyright (C) 1997,1998  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <algo.h>
#include <iostream.h>

#include <canvasregister.h>	

#include <attributes.h>       //ITO   
#include <handle.h>           //ITO

#include <coreexception.h>

//-------------------------CanvasRegister::Register---------------------

void CanvasRegister::Register(	const Handle& h, 
				const Attributes& a,
				const DrawableEntity* d,
				bool v,
				bool hl)
{			
// if the entity is not in the list, add it...

	list<RegisteredEntity>::iterator i=
		find(entityRegister.begin(),entityRegister.end(),h);
	if(i==entityRegister.end()){
		entityRegister.push_back(RegisteredEntity(h,a,d,v));
	}
}

//-------------------------CanvasRegister::UnRegister---------------------
void CanvasRegister::UnRegister(const Handle& h)
{
// if the entity is in the list, remove it...

	list<RegisteredEntity>::iterator i=
		find(entityRegister.begin(),entityRegister.end(),h);
	if(i!=entityRegister.end())entityRegister.erase(i++);
}

//-------------------------CanvasRegister::SetAttributes---------------------
void CanvasRegister::SetAttributes(const Handle& h, const Attributes& a)
{
// if the entity is in the list, replace it...

	list<RegisteredEntity>::iterator i=
		find(entityRegister.begin(),entityRegister.end(),h);

	if(i!=entityRegister.end()){
		RegisteredEntity tmpRE = RegisteredEntity(*i);
		entityRegister.erase(i++);
		entityRegister.push_back(RegisteredEntity(h,a,tmpRE.GetDrawable(),
						                tmpRE.IsVisible()));
	}
}

//------------------------CanvasRegister::SetVisible----------------------
void CanvasRegister::SetVisible(const Handle& h, bool v)
{
// if the entity is in the list, replace it...

	list<RegisteredEntity>::iterator i=
		find(entityRegister.begin(),entityRegister.end(),h);

	if(i!=entityRegister.end()) i->SetVisible(v);
}
//-------------------------CanvasRegister::SetAllVisible---------------------
void CanvasRegister::SetAllVisible(bool v)
{
// go through the list, and turn off all highlighting 

	list<RegisteredEntity>::iterator i= entityRegister.begin();

	while(i != entityRegister.end())
	{
		i->SetVisible(v);
		i++;
	}
}
//-------------------------CanvasRegister::SwapVisible---------------------
void CanvasRegister::SwapVisible()
{
// go through the list, and reverse all the visible flags

	list<RegisteredEntity>::iterator i= entityRegister.begin();

	while(i != entityRegister.end())
	{
		if(i->IsVisible())i->SetVisible(false);
		else i->SetVisible(true);
		i++;
	}
}
//-------------------------CanvasRegister::SetHighlight---------------------
void CanvasRegister::SetHighlight(const Handle& h, bool hl)
{
// if the entity is in the list, replace it...

	list<RegisteredEntity>::iterator i=
		find(entityRegister.begin(),entityRegister.end(),h);

	if(i!=entityRegister.end())i->SetHighlight(hl);
}
//-------------------------CanvasRegister::SetHighlight---------------------
void CanvasRegister::SetAllHighlights(bool hl)
{
// go through the list, and turn off all highlighting 

	list<RegisteredEntity>::iterator i= entityRegister.begin();

	while(i != entityRegister.end())
	{
		i->SetHighlight(hl);
		i++;
	}
}
//-------------------------CanvasRegister::InitList---------------------
void CanvasRegister::Init()
{
	ix = entityRegister.begin();
}

//-------------------------CanvasRegister::NextItem---------------------
bool CanvasRegister::NextItem(RegisteredEntity & re)
{
	if(ix == entityRegister.end())return false;  // no more to read

	re = RegisteredEntity(*ix);	// copy
	ix++;				// increment the iterator
	return true;
}
//-------------------------CanvasRegister::GetHandleFromName---------------------
Handle CanvasRegister::GetHandleFromName(unsigned int name) const throw (CoreException)
{
	list<RegisteredEntity>::const_iterator tx = entityRegister.begin();
	while( !(tx == entityRegister.end()))
	{
		Handle hx = tx->GetHandle();
		if ( name == hx ) return Handle(hx);
		tx++;
	}
	throw CoreException("CanvasRegister::GetHandleFromName() : name not in register");
}

//-------------------------CanvasRegister::GetAttributes---------------------
Attributes CanvasRegister::GetAttributes(const Handle & h) const throw (CoreException)
{
	list<RegisteredEntity>::const_iterator i=
		find(entityRegister.begin(),entityRegister.end(),h);

	if(i == entityRegister.end() ) 
		throw CoreException("CanvasRegister::GetAttributes() : handle not found");
	
	return i->GetAttributes();
}
