// canvasregister.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef CANVASREGISTER_H
#define CANVASREGISTER_H

//++++++++++++++++++++++++ CanvasRegister +++++++++++++++++++++

#include <list.h>		//HASA
#include <registeredentity.h>	//ITO

class Attributes;
class Handle;
class DrawableEntity;
class CoreException;

class CanvasRegister

{
private:
	list<RegisteredEntity> entityRegister;
	
	list<RegisteredEntity>::iterator ix;

public:
// data services
	// Add to viewer, For example: 
	// window.Register(handle,Attributes(RED,SOLID),TRUE,drawable);
	void Register(const Handle& h,
			const Attributes& a,
			const DrawableEntity* d,
			bool v = true,
			bool hl = false);

	// remove from viewer
	void UnRegister(const Handle& h);

	// set new attributes
	void SetAttributes(const Handle& h, const Attributes& a);
	void SetVisible(const Handle& h, bool v);
	void SetAllVisible(bool v);
	void SwapVisible();
	void SetHighlight(const Handle& h, bool hl);
	void SetAllHighlights(bool);

	void Init();	// start reading the list -> return first item
	bool NextItem(RegisteredEntity &); // get the next item in the list-return false when done.
	Handle GetHandleFromName(unsigned int) const throw(CoreException);
	Attributes  GetAttributes(const Handle&) const throw(CoreException);
};

#endif
