// registeredentity.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <registeredentity.h>

#include <drawableentity.h>	

 // default constructor - principally needed for STL
RegisteredEntity::RegisteredEntity(): handle(), attributes() {}

// standard constructor
RegisteredEntity::RegisteredEntity(	const Handle& h, 
					const Attributes& a, 
					const DrawableEntity* d ,
					bool v)
: handle(h), attributes(a), drawable(d), visible(v),highlight(false) {}

RegisteredEntity::~RegisteredEntity(){} //destructor

// copy constructor
RegisteredEntity::RegisteredEntity(const RegisteredEntity& re)
{
	handle = re.handle;
	attributes = re.attributes;
	drawable = re.drawable;
	visible = re.visible;
	highlight = re.highlight;
}

// assignment operator
RegisteredEntity& RegisteredEntity::operator=(const RegisteredEntity& re)
{
	handle = re.handle;
	attributes = re.attributes;
	drawable = re.drawable;
	visible = re.visible;
	highlight = re.highlight;
	return *this;
}

// STL operators
bool operator==(const RegisteredEntity& re1, const RegisteredEntity& re2) // equivalence of handle
{							
	return re1.handle == re2.handle;
}

bool operator==(const RegisteredEntity& re, const Handle& h) // equivalence of handle
{							
	return re.handle == h;
}

bool operator!=(const RegisteredEntity& re, const Handle& h) // equivalence of handle
{							
	return !(re.handle == h);
}

void RegisteredEntity::Draw(const float& ppmm) const
{
	drawable->Draw(handle.PointsAt(),ppmm);
}

void RegisteredEntity::Select(const float& ppmm) const
{	// only visible non-highlighted stuff can be selected  
	if(visible && !highlight) drawable->Select(handle.PointsAt(),handle,ppmm);
}
