// registeredentity.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef REGISTEREDENTITY_H
#define REGISTEREDENTITY_H

// the RegisteredEntity class is designed to live in the STL list container
// which belongs to the CanvasRegister support class of the cd GL canvas pane class

#include <handle.h>
#include <attributes.h>

class DrawableEntity;

class RegisteredEntity
{
// instansiated once for each registered entity
// retains the entitiy type, and handle for each entity registered with  the canvas
// flag for entity visible is here
private:
	Handle handle;		// handle can be set to NULL when entity is deleted
	Attributes attributes;  // graphical attributes - color, size, patterns, etc
	const DrawableEntity* drawable;// handle to choose which drawable to use to draw the entity.
				// entity types may have multiple representations.
				// Each entity can have its own representation if you want. 
	bool visible;
	bool highlight;
public:
// default constructor - for STL
	RegisteredEntity();

// standard constructor. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
	RegisteredEntity(const Handle&  h, 	// handle value
			const Attributes& a,    // attributes	
			const DrawableEntity *d,	// drawable for this entity. (MUST BE COMPATABLE)
			bool v);		// visible attributes

	~RegisteredEntity();			// destructor
//. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 

// copy constructors - for STL

	RegisteredEntity(const RegisteredEntity& re );		
	RegisteredEntity& operator=(const RegisteredEntity& re);	
	
	friend bool operator==(const RegisteredEntity& re1, const RegisteredEntity& re2); //STL
	friend bool operator==(const RegisteredEntity& re, const Handle& h);  //STL
	friend bool operator!=(const RegisteredEntity& re, const Handle& h);  //STL
 
	bool operator<(const RegisteredEntity&) {return true;}	// for STL

	void SetVisible(bool v) {  visible = v ; }	// set the visible
	void SetHighlight(bool v) { highlight = v; }     // set the highlight 
	void SetAttributes( const Attributes& );		// set the attributes
	void SetDrawable(const DrawableEntity*); 			// set the drawable

	Handle GetHandle() const { return handle; }		// returns the handle of the entity
	Attributes GetAttributes() const { return attributes; } // return the current attributes
	const DrawableEntity* GetDrawable() const { return drawable; } // return the pointer to the drawable.
	bool IsVisible() const { return visible; } 		// should I draw this?
	bool IsHighlight() const { return highlight; } 

	void Draw(const float& scale) const;
	void Select(const float& scale) const;

	//int Type() const { return handle.Type(); }		// What am i?  Obsolete. bad form
};

#endif
