// selection.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <selection.h> 

Selection::Selection(const Handle& h, const Point& p, int b ):
	handle(h), point(p), button(b) {}

Selection::Selection(const Selection& s)
{
	handle = s.handle;
	point = s.point;
	button = s.button;
}

Selection& Selection::operator=(const Selection& s)
{
	handle = s.handle;
	point = s.point;
	button = s.button;
	return *this;
}

bool operator==(const Selection& s1, const Selection& s2)
{
	return ((s1.handle == s2.handle) && 
		(s1.point == s2.point)   &&
		(s1.button == s2.button));
}

ostream& operator<<(ostream& os, const Selection& s)
{
	os << "Selection:\n";
	os << "handle = " << s.handle << '\n';
	os << "point = " << s.point << " button = " << s.button << '\n';
	return os;
}
